/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.cdt.internal.ui.util.SelectionUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.search.ui.ISearchResultView;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class GotoMarkerAction
extends Action {
    public void run() {
        ISearchResultView view = SearchUI.getSearchResultView();
        Object element = SelectionUtil.getSingleElement(view.getSelection());
        if (element instanceof ISearchResultViewEntry) {
            ISearchResultViewEntry entry = (ISearchResultViewEntry)element;
            this.show(entry.getSelectedMarker());
        }
    }

    private void show(IMarker marker) {
        IResource resource = marker.getResource();
        if (resource == null || !resource.exists()) {
            return;
        }
        IWorkbenchPage page = CUIPlugin.getActivePage();
        ICElement element = CSearchUtil.getCElement(marker);
        if (SearchUI.reuseEditor()) {
            this.showWithReuse(marker, resource, element, page);
        } else {
            this.showWithoutReuse(marker, element, page);
        }
    }

    private void showWithoutReuse(IMarker marker, ICElement element, IWorkbenchPage page) {
        IEditorPart editor = null;
        try {
            ICElement objectToOpen = element != null ? element : marker.getResource();
            editor = EditorUtility.openInEditor(objectToOpen, false);
        }
        catch (CoreException coreException) {}
        if (editor != null) {
            editor.gotoMarker(marker);
        }
    }

    private void showWithReuse(IMarker marker, IResource resource, ICElement element, IWorkbenchPage page) {
        if (!(resource instanceof IFile)) {
            return;
        }
        IEditorPart editor = EditorUtility.isOpenInEditor(element);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
        }
    }
}

