/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.template;

import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateBuffer;
import org.eclipse.cdt.internal.corext.template.TemplateContext;
import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.corext.template.TemplatePosition;
import org.eclipse.cdt.internal.ui.text.ICCompletionProposal;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionManager;
import org.eclipse.cdt.internal.ui.text.link.LinkedPositionUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateProposal
implements ICCompletionProposal {
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final ITextViewer fViewer;
    private final Image fImage;
    private final IRegion fRegion;
    private TemplateBuffer fTemplateBuffer;
    private String fOldText;
    private IRegion fSelectedRegion;

    public TemplateProposal(Template template, TemplateContext context, IRegion region, ITextViewer viewer, Image image) {
        Assert.isNotNull((Object)template);
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)viewer);
        this.fTemplate = template;
        this.fContext = context;
        this.fViewer = viewer;
        this.fImage = image;
        this.fRegion = region;
    }

    public void apply(IDocument document) {
        try {
            if (this.fTemplateBuffer == null) {
                this.fTemplateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            int start = this.fRegion.getOffset();
            int end = this.fRegion.getOffset() + this.fRegion.getLength();
            String templateString = this.fTemplateBuffer.getString();
            document.replace(start, end - start, templateString);
            LinkedPositionManager manager = new LinkedPositionManager(document);
            TemplatePosition[] variables = this.fTemplateBuffer.getVariables();
            int i = 0;
            while (i != variables.length) {
                TemplatePosition variable = variables[i];
                if (!variable.isResolved()) {
                    int[] offsets = variable.getOffsets();
                    int length = variable.getLength();
                    int j = 0;
                    while (j != offsets.length) {
                        manager.addPosition(offsets[j] + start, length);
                        ++j;
                    }
                }
                ++i;
            }
            LinkedPositionUI editor = new LinkedPositionUI(this.fViewer, manager);
            editor.setFinalCaretOffset(TemplateProposal.getCaretOffset(this.fTemplateBuffer) + start);
            editor.enter();
            this.fSelectedRegion = editor.getSelectedRegion();
        }
        catch (BadLocationException e) {
            CUIPlugin.getDefault().log(e);
            this.openErrorDialog(e);
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
            this.openErrorDialog(e);
        }
    }

    private static int getCaretOffset(TemplateBuffer buffer) {
        TemplatePosition[] variables = buffer.getVariables();
        int i = 0;
        while (i != variables.length) {
            TemplatePosition variable = variables[i];
            if (variable.getName().equals("cursor")) {
                return variable.getOffsets()[0];
            }
            ++i;
        }
        return buffer.getString().length();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        try {
            if (this.fTemplateBuffer == null) {
                this.fTemplateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            return TemplateProposal.textToHTML(this.fTemplateBuffer.getString());
        }
        catch (CoreException e) {
            CUIPlugin.getDefault().log(e);
            this.openErrorDialog(e);
            return null;
        }
    }

    public String getDisplayString() {
        return String.valueOf(this.fTemplate.getName()) + TemplateMessages.getString("TemplateProposal.delimiter") + this.fTemplate.getDescription();
    }

    public Image getImage() {
        return this.fImage;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private static String textToHTML(String string) {
        StringBuffer buffer = new StringBuffer(string.length());
        buffer.append("<pre>");
        int i = 0;
        while (i != string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '\t': {
                    buffer.append("    ");
                    break;
                }
                case '\n': {
                    buffer.append("<br>");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        buffer.append("</pre>");
        return buffer.toString();
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }

    private void openErrorDialog(CoreException e) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }

    public int getRelevance() {
        return 90;
    }
}

