/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.model.IBufferFactory;
import org.eclipse.cdt.internal.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.BuildConsoleManager;
import org.eclipse.cdt.internal.ui.CElementAdapterFactory;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.ResourceAdapterFactory;
import org.eclipse.cdt.internal.ui.cview.CView;
import org.eclipse.cdt.internal.ui.editor.CDocumentProvider;
import org.eclipse.cdt.internal.ui.editor.WorkingCopyManager;
import org.eclipse.cdt.internal.ui.editor.asm.AsmTextTools;
import org.eclipse.cdt.internal.ui.preferences.BuildConsolePreferencePage;
import org.eclipse.cdt.internal.ui.preferences.CEditorPreferencePage;
import org.eclipse.cdt.internal.ui.preferences.CPluginPreferencePage;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.internal.ui.util.ProblemMarkerManager;
import org.eclipse.cdt.ui.IBuildConsoleManager;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.ui";
    public static final String PLUGIN_CORE_ID = "org.eclipse.cdt.core";
    public static final String EDITOR_ID = "org.eclipse.cdt.ui.editor.CEditor";
    public static final String CONSOLE_ID = "org.eclipse.cdt.ui.BuildConsoleView";
    public static final String CVIEW_ID = "org.eclipse.cdt.ui.CView";
    public static final String C_PROBLEMMARKER = "org.eclipse.cdt.core.problem";
    public static final String C_PROJECT_WIZARD_ID = "org.eclipse.cdt.ui.wizards.StdCWizard";
    public static final String CPP_PROJECT_WIZARD_ID = "org.eclipse.cdt.ui.wizards.StdCCWizard";
    public static final String FILE_WIZARD_ID = "org.eclipse.ui.wizards.new.file";
    public static final String FOLDER_WIZARD_ID = "org.eclipse.ui.wizards.new.folder";
    public static final String CLASS_WIZARD_ID = "org.eclipse.cdt.ui.wizards.NewClassWizard";
    public static final String SEARCH_ACTION_SET_ID = "org.eclipse.cdt.ui.SearchActionSet";
    public static final String FOLDER_ACTION_SET_ID = "org.eclipse.cdt.ui.CFolderActionSet";
    public static final String BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    private static CUIPlugin fgCPlugin;
    private static ResourceBundle fgResourceBundle;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    static String SEPARATOR;
    private CoreModel fCoreModel;
    private CDocumentProvider fDocumentProvider;
    private WorkingCopyManager fWorkingCopyManager;
    private CTextTools fTextTools;
    private AsmTextTools fAsmTextTools;
    private ProblemMarkerManager fProblemMarkerManager;
    private BuildConsoleManager fBuildConsoleManager;
    private ResourceAdapterFactory fResourceAdapterFactory;
    private CElementAdapterFactory fCElementAdapterFactory;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        SEPARATOR = System.getProperty("file.separator");
        try {
            fgResourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.internal.ui.CPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            fgResourceBundle = null;
        }
    }

    public static IBufferFactory getBufferFactory() {
        CDocumentProvider provider = CUIPlugin.getDefault().getDocumentProvider();
        if (provider != null) {
            return provider.getBufferFactory();
        }
        return null;
    }

    public static IWorkingCopy[] getSharedWorkingCopies() {
        return CCorePlugin.getSharedWorkingCopies((IBufferFactory)CUIPlugin.getBufferFactory());
    }

    public static String getResourceString(String key) {
        try {
            return fgResourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return "!" + key + "!";
        }
        catch (NullPointerException nullPointerException) {
            return "#" + key + "#";
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getFormattedString(String key, String arg) {
        return MessageFormat.format(CUIPlugin.getResourceString(key), arg);
    }

    public static String getFormattedString(String key, String[] args) {
        return MessageFormat.format(CUIPlugin.getResourceString(key), args);
    }

    public static ResourceBundle getResourceBundle() {
        return fgResourceBundle;
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        return CUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = CUIPlugin.getDefault().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public Shell getActiveWorkbenchShell() {
        return this.getActiveWorkbenchWindow().getShell();
    }

    public static CUIPlugin getDefault() {
        return fgCPlugin;
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        CUIPlugin.getDefault().log(s);
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        CUIPlugin.getDefault().log(t);
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, PLUGIN_ID, -1, "Internal Error: ", t);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public CUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgCPlugin = this;
        this.fDocumentProvider = null;
        this.fTextTools = null;
    }

    public synchronized CDocumentProvider getDocumentProvider() {
        if (this.fDocumentProvider == null) {
            this.fDocumentProvider = new CDocumentProvider();
        }
        return this.fDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            CDocumentProvider provider = this.getDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public CTextTools getTextTools() {
        if (this.fTextTools == null) {
            this.fTextTools = new CTextTools(this.getPreferenceStore(), CCorePlugin.getDefault().getPluginPreferences());
        }
        return this.fTextTools;
    }

    public AsmTextTools getAsmTextTools() {
        if (this.fAsmTextTools == null) {
            this.fAsmTextTools = new AsmTextTools(this.getPreferenceStore(), CCorePlugin.getDefault().getPluginPreferences());
        }
        return this.fAsmTextTools;
    }

    public IBuildConsoleManager getConsoleManager() {
        if (this.fBuildConsoleManager == null) {
            this.fBuildConsoleManager = new BuildConsoleManager();
            this.fBuildConsoleManager.startup();
        }
        return this.fBuildConsoleManager;
    }

    public void shutdown() throws CoreException {
        if (this.fTextTools != null) {
            this.fTextTools.dispose();
        }
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        if (this.fBuildConsoleManager != null) {
            this.fBuildConsoleManager.shutdown();
            this.fBuildConsoleManager = null;
        }
        this.unregisterAdapters();
        super.shutdown();
        if (this.fWorkingCopyManager != null) {
            this.fWorkingCopyManager.shutdown();
            this.fWorkingCopyManager = null;
        }
        if (this.fDocumentProvider != null) {
            this.fDocumentProvider.shutdown();
            this.fDocumentProvider = null;
        }
    }

    private void runUI(Runnable run) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
            display.asyncExec(run);
        } else {
            run.run();
        }
    }

    public void startup() throws CoreException {
        super.startup();
        this.runUI(new Runnable(){

            public void run() {
                CUIPlugin.this.registerAdapters();
                CPluginImages.initialize();
            }
        });
    }

    protected void initializeDefaultPreferences(final IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        PreferenceConstants.initializeDefaultValues(store);
        this.runUI(new Runnable(){

            public void run() {
                CPluginPreferencePage.initDefaults(store);
                CEditorPreferencePage.initDefaults(store);
                CView.initDefaults(store);
                BuildConsolePreferencePage.initDefaults(store);
            }
        });
    }

    public CoreModel getCoreModel() {
        return this.fCoreModel;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return CUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    private void registerAdapters() {
        this.fResourceAdapterFactory = new ResourceAdapterFactory();
        this.fCElementAdapterFactory = new CElementAdapterFactory();
        IAdapterManager manager = Platform.getAdapterManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fResourceAdapterFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)this.fCElementAdapterFactory, (Class)clazz2);
    }

    private void unregisterAdapters() {
        IAdapterManager manager = Platform.getAdapterManager();
        manager.unregisterAdapters((IAdapterFactory)this.fResourceAdapterFactory);
        manager.unregisterAdapters((IAdapterFactory)this.fCElementAdapterFactory);
    }
}

