/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.sourcelookup;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.ui.sourcelookup.CUISourceLocator;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultSourceLocator
implements IPersistableSourceLocator,
IAdaptable {
    private static final String ELEMENT_NAME = "PromptingSourceLocator";
    private static final String ATTR_PROJECT = "project";
    private static final String ATTR_MEMENTO = "memento";
    public static final String ID_DEFAULT_SOURCE_LOCATOR = String.valueOf(LaunchUIPlugin.getUniqueIdentifier()) + ".DefaultSourceLocator";
    private CUISourceLocator fSourceLocator = null;
    private static final int ERROR = 1000;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DefaultSourceLocator() {
    }

    public DefaultSourceLocator(CUISourceLocator locator) {
        this.fSourceLocator = locator;
    }

    public String getMemento() throws CoreException {
        if (this.fSourceLocator != null) {
            DocumentImpl doc = new DocumentImpl();
            Element node = doc.createElement(ELEMENT_NAME);
            doc.appendChild(node);
            node.setAttribute(ATTR_PROJECT, this.fSourceLocator.getProject().getName());
            IPersistableSourceLocator psl = this.getPersistableSourceLocator();
            if (psl != null) {
                node.setAttribute(ATTR_MEMENTO, psl.getMemento());
            }
            try {
                return CDebugUtils.serializeDocument((Document)doc, (String)" ");
            }
            catch (IOException e) {
                this.abort("Unable to create memento for C/C++ source locator.", e);
            }
        }
        return null;
    }

    public void initializeFromMemento(String memento) throws CoreException {
        Exception ex = null;
        try {
            ICSourceLocator locator;
            IProject project;
            Element root = null;
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            StringReader reader = new StringReader(memento);
            InputSource source = new InputSource(reader);
            root = parser.parse(source).getDocumentElement();
            if (!root.getNodeName().equalsIgnoreCase(ELEMENT_NAME)) {
                this.abort("Unable to restore prompting source locator - invalid format.", null);
            }
            String projectName = root.getAttribute(ATTR_PROJECT);
            String data = root.getAttribute(ATTR_MEMENTO);
            if (this.isEmpty(projectName)) {
                this.abort("Unable to restore prompting source locator - invalid format.", null);
            }
            if ((project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) == null) {
                this.abort(MessageFormat.format("Unable to restore prompting source locator - project {0} not found.", projectName), null);
            }
            if ((locator = this.getCSourceLocator()) == null) {
                this.fSourceLocator = new CUISourceLocator(project);
            } else if (locator.getProject() != null && !project.equals((Object)locator.getProject())) {
                return;
            }
            IPersistableSourceLocator psl = this.getPersistableSourceLocator();
            if (psl != null) {
                psl.initializeFromMemento(data);
            } else {
                this.abort("Unable to restore C/C++ source locator - invalid format.", null);
            }
            return;
        }
        catch (ParserConfigurationException e) {
            ex = e;
        }
        catch (SAXException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        this.abort("Exception occurred initializing source locator.", ex);
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.fSourceLocator = new CUISourceLocator(this.getProject(configuration));
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
        if (!this.isEmpty(memento)) {
            this.initializeFromMemento(memento);
        }
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        return this.fSourceLocator != null ? this.fSourceLocator.getSourceElement(stackFrame) : null;
    }

    private IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
        if (!this.isEmpty(projectName) && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists()) {
            return project;
        }
        this.abort(MessageFormat.format("Project \"{0}\" does not exist.", projectName), null);
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (this.fSourceLocator != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz)) {
                return this.fSourceLocator.getAdapter(adapter);
            }
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResourceChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz2)) {
                return this.fSourceLocator.getAdapter(adapter);
            }
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ISourceMode");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter.equals(clazz3)) {
                return this.fSourceLocator.getAdapter(adapter);
            }
        }
        return null;
    }

    private ICSourceLocator getCSourceLocator() {
        if (this.fSourceLocator != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ICSourceLocator)this.fSourceLocator.getAdapter((Class)clazz);
        }
        return null;
    }

    private IPersistableSourceLocator getPersistableSourceLocator() {
        ICSourceLocator sl = this.getCSourceLocator();
        return sl instanceof IPersistableSourceLocator ? (IPersistableSourceLocator)sl : null;
    }

    private void abort(String message, Throwable e) throws CoreException {
        Status s = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 1000, message, e);
        throw new CoreException((IStatus)s);
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }
}

