/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.util.StringTokenizer;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CConventions {
    private static final String scopeResolutionOperator = "::";
    private static final char fgDot = '.';
    private static final char fgColon = ':';

    public static IStatus validateClassName(String name) {
        char[] scannedID;
        if (name == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.nullName"), null);
        }
        String trimmed = name.trim();
        if (!name.equals(trimmed) || name.indexOf(" ") != -1) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.nameWithBlanks"), null);
        }
        int index = name.lastIndexOf(scopeResolutionOperator);
        if (index == -1) {
            scannedID = name.toCharArray();
        } else {
            String pkg = name.substring(0, index).trim();
            IStatus status = CConventions.validateScopeName(pkg);
            if (!status.isOK()) {
                return status;
            }
            String type = name.substring(index + 1).trim();
            scannedID = type.toCharArray();
        }
        if (scannedID != null) {
            IStatus status = ResourcesPlugin.getWorkspace().validateName(new String(scannedID), 1);
            if (!status.isOK()) {
                return status;
            }
            if (CharOperation.contains('$', scannedID)) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.class.dollarName"), null);
            }
            if (scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.class.lowercaseName"), null);
            }
            return CModelStatus.VERIFIED_OK;
        }
        return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.class.invalidName", name), null);
    }

    public static IStatus validateScopeName(String name) {
        if (name == null) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.nullName"), null);
        }
        int length = name.length();
        if (length == 0) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.emptyName"), null);
        }
        if (name.charAt(0) == '.' || name.charAt(length - 1) == '.') {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.dotName"), null);
        }
        if (CharOperation.isWhitespace(name.charAt(0)) || CharOperation.isWhitespace(name.charAt(name.length() - 1))) {
            return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.nameWithBlanks"), null);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        StringTokenizer st = new StringTokenizer(name, scopeResolutionOperator);
        boolean firstToken = true;
        while (st.hasMoreTokens()) {
            String typeName = st.nextToken();
            char[] scannedID = (typeName = typeName.trim()).toCharArray();
            if (scannedID == null) {
                return new Status(4, "org.eclipse.cdt.core", -1, Util.bind("convention.illegalIdentifier", typeName), null);
            }
            IStatus status = workspace.validateName(new String(scannedID), 2);
            if (!status.isOK()) {
                return status;
            }
            if (firstToken && scannedID.length > 0 && Character.isLowerCase(scannedID[0])) {
                return new Status(2, "org.eclipse.cdt.core", -1, Util.bind("convention.scope.lowercaseName"), null);
            }
            firstToken = false;
        }
        return CModelStatus.VERIFIED_OK;
    }
}

