/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.parser.ITranslationOptions;

public class TranslationOptions
implements ITranslationOptions {
    private char[][] taskTags = null;
    private char[][] taskPriorities = null;

    public TranslationOptions(Map settings) {
        this.initialize(settings);
    }

    public void initialize(Map settings) {
        if (settings == null) {
            return;
        }
        Iterator entries = settings.entrySet().iterator();
        while (entries.hasNext()) {
            String token;
            int i;
            StringTokenizer tokenizer;
            Map.Entry entry = entries.next();
            Object oKey = entry.getKey();
            Object oValue = entry.getValue();
            if (!(oKey instanceof String) || !(oValue instanceof String)) continue;
            String optionID = (String)oKey;
            String optionValue = (String)oValue;
            if (optionID.equals("org.eclipse.cdt.core.translation.taskTags")) {
                if (optionValue.length() == 0) {
                    this.taskTags = null;
                    continue;
                }
                tokenizer = new StringTokenizer(optionValue, ",");
                this.taskTags = new char[tokenizer.countTokens()][];
                i = 0;
                while (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken().trim();
                    this.taskTags[i] = token.toCharArray();
                    ++i;
                }
                continue;
            }
            if (!optionID.equals("org.eclipse.cdt.core.translation.taskPriorities")) continue;
            if (optionValue.length() == 0) {
                this.taskPriorities = null;
                continue;
            }
            tokenizer = new StringTokenizer(optionValue, ",");
            this.taskPriorities = new char[tokenizer.countTokens()][];
            i = 0;
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken().trim();
                this.taskPriorities[i] = token.toCharArray();
                ++i;
            }
        }
    }

    public void setTaskTags(char[][] taskTags) {
        this.taskTags = taskTags;
    }

    public char[][] getTaskTags() {
        return this.taskTags;
    }

    public void setTaskPriorities(char[][] taskPriorities) {
        this.taskPriorities = taskPriorities;
    }

    public char[][] getTaskPriorities() {
        return this.taskPriorities;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer("TranslationOptions:");
        String result = "";
        if (this.taskTags != null) {
            i = 0;
            while (i < this.taskTags.length) {
                result = String.valueOf(result) + this.taskTags.toString();
                if (i < this.taskTags.length - 1) {
                    result = String.valueOf(result) + ",";
                }
                ++i;
            }
        }
        buf.append("\n-task tags: " + result);
        result = "";
        if (this.taskPriorities != null) {
            i = 0;
            while (i < this.taskPriorities.length) {
                result = String.valueOf(result) + this.taskPriorities.toString();
                if (i < this.taskPriorities.length - 1) {
                    result = String.valueOf(result) + ",";
                }
                ++i;
            }
        }
        buf.append("\n-task priorities : " + result);
        return buf.toString();
    }
}

