/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTBaseSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.NamedOffsets;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTBaseSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;

public class ASTClassSpecifier
extends ASTScope
implements IASTClassSpecifier {
    private NamedOffsets offsets = new NamedOffsets();
    private final IASTClassSpecifier.ClassNameType classNameType;
    private final ASTClassKind classKind;
    private ASTAccessVisibility currentVisibility;
    private final ASTQualifiedNamedElement qualifiedName;
    private final ASTReferenceStore references;

    public ASTClassSpecifier(ISymbol symbol, ASTClassKind kind, IASTClassSpecifier.ClassNameType type, ASTAccessVisibility access, int startingOffset, int nameOffset, int nameEndOffset, List references) {
        super(symbol);
        this.classKind = kind;
        this.classNameType = type;
        this.currentVisibility = access;
        this.setStartingOffset(startingOffset);
        this.setNameOffset(nameOffset);
        this.setNameEndOffset(nameEndOffset);
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), symbol.getName());
        this.references = new ASTReferenceStore(references);
    }

    public IASTClassSpecifier.ClassNameType getClassNameType() {
        return this.classNameType;
    }

    public ASTClassKind getClassKind() {
        return this.classKind;
    }

    public Iterator getBaseClauses() {
        return new BaseIterator((IDerivableContainerSymbol)this.getSymbol());
    }

    public ASTAccessVisibility getCurrentVisibilityMode() {
        return this.currentVisibility;
    }

    public void setCurrentVisibility(ASTAccessVisibility visibility) {
        this.currentVisibility = visibility;
    }

    public String getName() {
        return this.symbol.getName();
    }

    public int getNameOffset() {
        return this.offsets.getNameOffset();
    }

    public void setNameOffset(int o) {
        this.offsets.setNameOffset(o);
    }

    public void acceptElement(ISourceElementRequestor requestor) {
    }

    public void enterScope(ISourceElementRequestor requestor) {
        this.references.processReferences(requestor);
        try {
            requestor.enterClassSpecifier(this);
        }
        catch (Exception exception) {}
        Iterator i = this.getBaseClauses();
        while (i.hasNext()) {
            IASTBaseSpecifier baseSpec = (IASTBaseSpecifier)i.next();
            baseSpec.acceptElement(requestor);
        }
    }

    public void exitScope(ISourceElementRequestor requestor) {
        try {
            requestor.exitClassSpecifier(this);
        }
        catch (Exception exception) {}
    }

    public void setStartingOffset(int o) {
        this.offsets.setStartingOffset(o);
    }

    public void setEndingOffset(int o) {
        this.offsets.setEndingOffset(o);
    }

    public int getStartingOffset() {
        return this.offsets.getStartingOffset();
    }

    public int getEndingOffset() {
        return this.offsets.getEndingOffset();
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public IASTScope getOwnerScope() {
        return (IASTScope)((Object)this.symbol.getContainingSymbol().getASTExtension().getPrimaryDeclaration());
    }

    public int getNameEndOffset() {
        return this.offsets.getNameEndOffset();
    }

    public void setNameEndOffset(int o) {
        this.offsets.setNameEndOffset(o);
    }

    public class BaseIterator
    implements Iterator {
        private final Iterator parents;

        public BaseIterator(IDerivableContainerSymbol symbol) {
            this.parents = symbol.getParents() != null ? symbol.getParents().iterator() : null;
        }

        public boolean hasNext() {
            if (this.parents == null) {
                return false;
            }
            return this.parents.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ParserSymbolTable.Declaration.ParentWrapper pw = (ParserSymbolTable.Declaration.ParentWrapper)this.parents.next();
            return new ASTBaseSpecifier(pw.getParent(), pw.isVirtual(), pw.getAccess(), pw.getOffset(), pw.getReferences());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

