/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ExpressionEvaluationException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReferenceStore;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypeId;

public class ASTExpression
implements IASTExpression {
    private final IASTExpression.Kind kind;
    private final IASTExpression lhs;
    private final IASTExpression rhs;
    private final IASTExpression thirdExpression;
    private final String literal;
    private final String idExpression;
    private ITokenDuple idExpressionDuple;
    private final IASTTypeId typeId;
    private final IASTExpression.IASTNewExpressionDescriptor newDescriptor;
    private final List references;
    private List resultType;

    public ASTExpression(IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, IASTExpression thirdExpression, IASTTypeId typeId, ITokenDuple idExpression, String literal, IASTExpression.IASTNewExpressionDescriptor newDescriptor, List references) {
        this.kind = kind;
        this.lhs = lhs;
        this.rhs = rhs;
        this.thirdExpression = thirdExpression;
        this.literal = literal;
        this.typeId = typeId;
        this.newDescriptor = newDescriptor;
        this.references = references;
        this.resultType = new ArrayList();
        this.idExpressionDuple = idExpression;
        this.idExpression = this.idExpressionDuple == null ? "" : this.idExpressionDuple.toString();
    }

    public IASTExpression.Kind getExpressionKind() {
        return this.kind;
    }

    public IASTExpression getLHSExpression() {
        return this.lhs;
    }

    public IASTExpression getRHSExpression() {
        return this.rhs;
    }

    public IASTExpression getThirdExpression() {
        return this.thirdExpression;
    }

    public String getLiteralString() {
        return this.literal;
    }

    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    public ITokenDuple getTypeIdTokenDuple() {
        if (this.typeId == null) {
            return null;
        }
        return ((ASTTypeId)this.typeId).getTokenDuple();
    }

    public IASTExpression.IASTNewExpressionDescriptor getNewExpressionDescriptor() {
        return this.newDescriptor;
    }

    public int evaluateExpression() throws ExpressionEvaluationException {
        throw new ExpressionEvaluationException();
    }

    public List getReferences() {
        return this.references;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            this.reconcileReferences();
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
        if (!this.references.isEmpty()) {
            new ASTReferenceStore(this.references).processReferences(requestor);
        }
        if (this.typeId != null) {
            this.typeId.acceptElement(requestor);
        }
        if (this.lhs != null) {
            this.lhs.acceptElement(requestor);
        }
        if (this.rhs != null) {
            this.rhs.acceptElement(requestor);
        }
        if (this.thirdExpression != null) {
            this.thirdExpression.acceptElement(requestor);
        }
        if (this.newDescriptor != null) {
            this.newDescriptor.acceptElement(requestor);
        }
        try {
            this.purgeReferences();
        }
        catch (ASTNotImplementedException aSTNotImplementedException) {}
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public List getResultType() {
        return this.resultType;
    }

    public void setResultType(List i) {
        this.resultType = i;
    }

    public String getIdExpression() {
        return this.idExpression;
    }

    public ITokenDuple getIdExpressionTokenDuple() {
        return this.idExpressionDuple;
    }

    public void reconcileReferences() throws ASTNotImplementedException {
        if (this.lhs != null) {
            this.lhs.reconcileReferences();
        }
        if (this.rhs != null) {
            this.rhs.reconcileReferences();
        }
        if (this.thirdExpression != null) {
            this.thirdExpression.reconcileReferences();
        }
        this.reconcileSubExpression((ASTExpression)this.lhs);
        this.reconcileSubExpression((ASTExpression)this.rhs);
        this.reconcileSubExpression((ASTExpression)this.thirdExpression);
    }

    protected void reconcileSubExpression(ASTExpression subExpression) {
        if (subExpression != null && subExpression.getReferences() != null) {
            Iterator subExp = subExpression.getReferences().iterator();
            while (subExp.hasNext()) {
                IASTReference aReference = (IASTReference)subExp.next();
                if (aReference == null || !this.references.contains(aReference)) continue;
                subExp.remove();
            }
        }
    }

    public void purgeReferences() throws ASTNotImplementedException {
        if (this.lhs != null) {
            this.lhs.purgeReferences();
        }
        if (this.rhs != null) {
            this.rhs.purgeReferences();
        }
        if (this.thirdExpression != null) {
            this.thirdExpression.purgeReferences();
        }
        this.purgeSubExpression((ASTExpression)this.lhs);
        this.purgeSubExpression((ASTExpression)this.rhs);
        this.purgeSubExpression((ASTExpression)this.thirdExpression);
    }

    protected void purgeSubExpression(ASTExpression subExpression) {
        if (subExpression != null && subExpression.getReferences() != null) {
            subExpression.getReferences().clear();
        }
    }
}

