/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.ASTSemanticException;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTConstructorMemberInitializer;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTInitializerClause;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceAlias;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.internal.core.parser.ast.BaseASTFactory;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTASMDefinition;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTAnonymousDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTClassReference;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTClassSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTCodeScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTCompilationUnit;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTConstructorMemberInitializer;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTElaboratedTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTEnumerationReference;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTEnumerationSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTEnumerator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTEnumeratorReference;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExceptionSpecification;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTExpression;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTField;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTFieldReference;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTFunction;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTFunctionReference;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTLinkageSpecification;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTMethod;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTMethodReference;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNamespaceAlias;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNamespaceDefinition;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNamespaceReference;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTNewDescriptor;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTParameterDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTParameterReference;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTReference;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTScope;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSimpleTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateInstantiation;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTemplateSpecialization;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypeId;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypedef;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTTypedefReference;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTUsingDeclaration;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTUsingDirective;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTVariable;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTVariableReference;
import org.eclipse.cdt.internal.core.parser.pst.ForewardDeclaredSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.IContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IDerivableContainerSymbol;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolASTExtension;
import org.eclipse.cdt.internal.core.parser.pst.ISymbolOwner;
import org.eclipse.cdt.internal.core.parser.pst.NamespaceSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTable;
import org.eclipse.cdt.internal.core.parser.pst.ParserSymbolTableException;
import org.eclipse.cdt.internal.core.parser.pst.StandardSymbolExtension;
import org.eclipse.cdt.internal.core.parser.pst.TypeInfo;

public class CompleteParseASTFactory
extends BaseASTFactory
implements IASTFactory {
    protected ParserSymbolTable pst;

    public CompleteParseASTFactory(ParserLanguage language) {
        this.pst = new ParserSymbolTable(language);
    }

    protected void addReference(List references, IASTReference reference) {
        if (references == null) {
            return;
        }
        Iterator i = references.iterator();
        while (i.hasNext()) {
            IASTReference ref = (IASTReference)i.next();
            if (ref == null || !ref.getName().equals(reference.getName()) || ref.getOffset() != reference.getOffset()) continue;
            i.remove();
            break;
        }
        references.add(reference);
    }

    protected boolean validParameterList(List parameters) {
        Iterator i = parameters.iterator();
        while (i.hasNext()) {
            TypeInfo info = (TypeInfo)i.next();
            if (info != null) {
                if (info.getType() != TypeInfo.t_type || info.getTypeSymbol() != null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private ISymbol lookupElement(IContainerSymbol startingScope, String name, TypeInfo.eType type, List parameters) throws ParserSymbolTableException {
        ISymbol result;
        block8: {
            result = null;
            try {
                if (type == TypeInfo.t_function || type == TypeInfo.t_constructor) {
                    if (this.validParameterList(parameters)) {
                        if (type == TypeInfo.t_constructor) {
                            IDerivableContainerSymbol startingDerivableScope = (IDerivableContainerSymbol)startingScope;
                            result = startingDerivableScope.lookupConstructor(new LinkedList(parameters));
                        } else {
                            result = startingScope.qualifiedFunctionLookup(name, new LinkedList(parameters));
                        }
                    } else {
                        result = null;
                    }
                } else {
                    result = startingScope.qualifiedLookup(name, type);
                }
            }
            catch (ParserSymbolTableException e) {
                if (e.reason == 7) break block8;
                throw e;
            }
        }
        return result;
    }

    protected ISymbol lookupQualifiedName(IContainerSymbol startingScope, String name, List references, boolean throwOnError) throws ASTSemanticException {
        return this.lookupQualifiedName(startingScope, name, TypeInfo.t_any, null, 0, references, throwOnError);
    }

    protected ISymbol lookupQualifiedName(IContainerSymbol startingScope, String name, TypeInfo.eType type, List parameters, int offset, List references, boolean throwOnError) throws ASTSemanticException {
        ISymbol result = null;
        try {
            if (name == null) {
                throw new ASTSemanticException();
            }
            try {
                result = this.lookupElement(startingScope, name, type, parameters);
                if (result == null) {
                    throw new ASTSemanticException();
                }
                this.addReference(references, this.createReference(result, name, offset));
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                throw new ASTSemanticException();
            }
        }
        catch (ASTSemanticException se) {
            if (throwOnError) {
                throw se;
            }
            return null;
        }
        return result;
    }

    protected ISymbol lookupQualifiedName(IContainerSymbol startingScope, ITokenDuple name, List references, boolean throwOnError) throws ASTSemanticException {
        return this.lookupQualifiedName(startingScope, name, TypeInfo.t_any, null, references, throwOnError);
    }

    protected ISymbol lookupQualifiedName(IContainerSymbol startingScope, ITokenDuple name, TypeInfo.eType type, List parameters, List references, boolean throwOnError) throws ASTSemanticException {
        ISymbol result;
        block17: {
            result = null;
            IToken firstSymbol = null;
            try {
                if (name == null) {
                    throw new ASTSemanticException();
                }
                switch (name.length()) {
                    case 0: {
                        if (throwOnError) {
                            throw new ASTSemanticException();
                        }
                    }
                    case 1: {
                        firstSymbol = name.getFirstToken();
                        try {
                            result = this.lookupElement(startingScope, firstSymbol.getImage(), type, parameters);
                            if (result == null) {
                                throw new ASTSemanticException();
                            }
                            this.addReference(references, this.createReference(result, firstSymbol.getImage(), firstSymbol.getOffset()));
                            break;
                        }
                        catch (ParserSymbolTableException parserSymbolTableException) {
                            throw new ASTSemanticException();
                        }
                    }
                    default: {
                        Iterator iter = name.iterator();
                        firstSymbol = name.getFirstToken();
                        result = startingScope;
                        if (firstSymbol.getType() == 3) {
                            result = this.pst.getCompilationUnit();
                        }
                        while (iter.hasNext()) {
                            IToken t = (IToken)iter.next();
                            if (t.getType() == 3) continue;
                            if (!t.isPointer()) {
                                try {
                                    result = t == name.getLastToken() ? this.lookupElement((IContainerSymbol)result, t.getImage(), type, parameters) : result.lookupNestedNameSpecifier(t.getImage());
                                    this.addReference(references, this.createReference(result, t.getImage(), t.getOffset()));
                                    continue;
                                }
                                catch (ParserSymbolTableException parserSymbolTableException) {
                                    throw new ASTSemanticException();
                                }
                            }
                            break block17;
                        }
                    }
                }
            }
            catch (ASTSemanticException se) {
                if (throwOnError) {
                    throw se;
                }
                return null;
            }
        }
        return result;
    }

    public IASTUsingDirective createUsingDirective(IASTScope scope, ITokenDuple duple, int startingOffset, int endingOffset) throws ASTSemanticException {
        ArrayList references = new ArrayList();
        ISymbol symbol = this.lookupQualifiedName(this.scopeToSymbol(scope), duple, references, true);
        try {
            ((ASTScope)scope).getContainerSymbol().addUsingDirective((IContainerSymbol)symbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        ASTUsingDirective astUD = new ASTUsingDirective(this.scopeToSymbol(scope), (IASTNamespaceDefinition)((Object)symbol.getASTExtension().getPrimaryDeclaration()), startingOffset, endingOffset, references);
        return astUD;
    }

    protected IContainerSymbol getScopeToSearchUpon(IASTScope currentScope, IToken firstToken, Iterator iterator) throws ASTSemanticException {
        if (firstToken.getType() == 3) {
            iterator.next();
            return this.pst.getCompilationUnit();
        }
        return this.scopeToSymbol(currentScope);
    }

    protected IContainerSymbol scopeToSymbol(IASTScope currentScope) {
        if (currentScope instanceof ASTScope) {
            return ((ASTScope)currentScope).getContainerSymbol();
        }
        return this.scopeToSymbol(((ASTAnonymousDeclaration)((Object)currentScope)).getOwnerScope());
    }

    public IASTUsingDeclaration createUsingDeclaration(IASTScope scope, boolean isTypeName, ITokenDuple name, int startingOffset, int endingOffset) throws ASTSemanticException {
        ArrayList references = new ArrayList();
        ISymbol symbol = this.lookupQualifiedName(this.scopeToSymbol(scope), name, references, true);
        try {
            this.scopeToSymbol(scope).addUsingDeclaration(name.getLastToken().getImage(), symbol.getContainingSymbol());
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        return new ASTUsingDeclaration(scope, symbol.getASTExtension().getPrimaryDeclaration(), isTypeName, startingOffset, endingOffset, references);
    }

    public IASTASMDefinition createASMDefinition(IASTScope scope, String assembly, int first, int last) {
        return new ASTASMDefinition(this.scopeToSymbol(scope), assembly, first, last);
    }

    public IASTNamespaceDefinition createNamespaceDefinition(IASTScope scope, String identifier, int startingOffset, int nameOffset, int nameEndOffset) throws ASTSemanticException {
        IContainerSymbol pstScope = this.scopeToSymbol(scope);
        ISymbol namespaceSymbol = null;
        if (!identifier.equals("")) {
            try {
                namespaceSymbol = pstScope.qualifiedLookup(identifier);
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                throw new ASTSemanticException();
            }
        }
        if (namespaceSymbol != null) {
            if (namespaceSymbol.getType() != TypeInfo.t_namespace) {
                throw new ASTSemanticException();
            }
        } else {
            namespaceSymbol = this.pst.newContainerSymbol(identifier, TypeInfo.t_namespace);
            if (identifier.equals("")) {
                namespaceSymbol.setContainingSymbol(pstScope);
            } else {
                try {
                    pstScope.addSymbol(namespaceSymbol);
                }
                catch (ParserSymbolTableException parserSymbolTableException) {}
            }
        }
        ASTNamespaceDefinition namespaceDef = new ASTNamespaceDefinition(namespaceSymbol, startingOffset, nameOffset, nameEndOffset);
        try {
            this.attachSymbolExtension(namespaceSymbol, namespaceDef);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {}
        return namespaceDef;
    }

    public IASTCompilationUnit createCompilationUnit() {
        IContainerSymbol symbol = this.pst.getCompilationUnit();
        ASTCompilationUnit compilationUnit = new ASTCompilationUnit(symbol);
        try {
            this.attachSymbolExtension(symbol, compilationUnit);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {}
        return compilationUnit;
    }

    protected void attachSymbolExtension(ISymbol symbol, ASTSymbol astSymbol) throws ISymbolASTExtension.ExtensionException {
        ISymbolASTExtension extension = symbol.getASTExtension();
        if (extension == null) {
            extension = astSymbol instanceof IASTNamespaceDefinition || astSymbol instanceof IASTEnumerationSpecifier || astSymbol instanceof IASTClassSpecifier || astSymbol instanceof IASTElaboratedTypeSpecifier ? new NamespaceSymbolExtension(symbol, astSymbol) : (astSymbol instanceof IASTFunction || astSymbol instanceof IASTMethod ? new ForewardDeclaredSymbolExtension(symbol, astSymbol) : new StandardSymbolExtension(symbol, astSymbol));
            symbol.setASTExtension(extension);
        } else {
            extension.addDefinition(astSymbol);
        }
    }

    public IASTLinkageSpecification createLinkageSpecification(IASTScope scope, String spec, int startingOffset) {
        return new ASTLinkageSpecification(this.scopeToSymbol(scope), spec, startingOffset);
    }

    public IASTClassSpecifier createClassSpecifier(IASTScope scope, ITokenDuple name, ASTClassKind kind, IASTClassSpecifier.ClassNameType type, ASTAccessVisibility access, int startingOffset, int nameOffset, int nameEndOffset) throws ASTSemanticException {
        IContainerSymbol currentScopeSymbol = this.scopeToSymbol(scope);
        TypeInfo.eType pstType = this.classKindToTypeInfo(kind);
        ArrayList references = new ArrayList();
        String newSymbolName = "";
        if (name != null) {
            ITokenDuple containerSymbolName;
            IToken lastToken = name.getLastToken();
            if (name.length() != 1 && (currentScopeSymbol = (IContainerSymbol)this.lookupQualifiedName(currentScopeSymbol, containerSymbolName = name.getSubrange(0, name.length() - 3), references, true)) == null) {
                throw new ASTSemanticException();
            }
            newSymbolName = lastToken.getImage();
        }
        ISymbol classSymbol = null;
        if (!newSymbolName.equals("")) {
            try {
                classSymbol = currentScopeSymbol.lookupMemberForDefinition(newSymbolName);
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                throw new ASTSemanticException();
            }
            if (classSymbol != null && !classSymbol.isForwardDeclaration()) {
                throw new ASTSemanticException();
            }
            if (classSymbol != null && classSymbol.getType() != pstType) {
                throw new ASTSemanticException();
            }
        }
        IDerivableContainerSymbol newSymbol = this.pst.newDerivableContainerSymbol(newSymbolName, pstType);
        if (classSymbol != null) {
            classSymbol.setTypeSymbol(newSymbol);
        }
        try {
            currentScopeSymbol.addSymbol(newSymbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        ASTClassSpecifier classSpecifier = new ASTClassSpecifier(newSymbol, kind, type, access, startingOffset, nameOffset, nameEndOffset, references);
        try {
            this.attachSymbolExtension(newSymbol, classSpecifier);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {
            throw new ASTSemanticException();
        }
        return classSpecifier;
    }

    protected TypeInfo.eType classKindToTypeInfo(ASTClassKind kind) throws ASTSemanticException {
        TypeInfo.eType pstType = null;
        if (kind == ASTClassKind.CLASS) {
            pstType = TypeInfo.t_class;
        } else if (kind == ASTClassKind.STRUCT) {
            pstType = TypeInfo.t_struct;
        } else if (kind == ASTClassKind.UNION) {
            pstType = TypeInfo.t_union;
        } else {
            throw new ASTSemanticException();
        }
        return pstType;
    }

    public void addBaseSpecifier(IASTClassSpecifier astClassSpec, boolean isVirtual, ASTAccessVisibility visibility, ITokenDuple parentClassName) throws ASTSemanticException {
        IDerivableContainerSymbol classSymbol = (IDerivableContainerSymbol)this.scopeToSymbol(astClassSpec);
        Iterator iterator = parentClassName.iterator();
        ArrayList references = new ArrayList();
        if (!iterator.hasNext()) {
            throw new ASTSemanticException();
        }
        IContainerSymbol symbol = null;
        symbol = this.getScopeToSearchUpon(astClassSpec, parentClassName.getFirstToken(), iterator);
        while (iterator.hasNext()) {
            IToken t = (IToken)iterator.next();
            if (t.getType() == 3) continue;
            try {
                symbol = t == parentClassName.getLastToken() ? (IContainerSymbol)symbol.lookup(t.getImage()) : symbol.lookupNestedNameSpecifier(t.getImage());
                if (symbol != null) {
                    this.addReference(references, this.createReference(symbol, t.getImage(), t.getOffset()));
                    continue;
                }
                throw new ASTSemanticException();
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                throw new ASTSemanticException();
            }
        }
        classSymbol.addParent(symbol, isVirtual, visibility, parentClassName.getFirstToken().getOffset(), references);
    }

    protected IASTReference createReference(ISymbol symbol, String string, int offset) throws ASTSemanticException {
        if (symbol == null) {
            throw new ASTSemanticException();
        }
        if (symbol.getType() == TypeInfo.t_namespace) {
            return new ASTNamespaceReference(offset, string, (IASTNamespaceDefinition)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
        }
        if (symbol.getType() == TypeInfo.t_class || symbol.getType() == TypeInfo.t_struct || symbol.getType() == TypeInfo.t_union) {
            return new ASTClassReference(offset, string, (IASTTypeSpecifier)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
        }
        if (symbol.getTypeInfo().checkBit(8192)) {
            return new ASTTypedefReference(offset, string, (IASTTypedefDeclaration)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
        }
        if (symbol.getType() == TypeInfo.t_enumeration) {
            return new ASTEnumerationReference(offset, string, (IASTEnumerationSpecifier)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
        }
        if (symbol.getType() == TypeInfo.t_enumerator) {
            return new ASTEnumeratorReference(offset, string, (IASTEnumerator)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
        }
        if (symbol.getType() == TypeInfo.t_function || symbol.getType() == TypeInfo.t_constructor) {
            if (symbol.getContainingSymbol().getTypeInfo().isType(TypeInfo.t_class, TypeInfo.t_union)) {
                return new ASTMethodReference(offset, string, (IASTMethod)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
            }
            return new ASTFunctionReference(offset, string, (IASTFunction)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
        }
        if (symbol.getType() == TypeInfo.t_type || symbol.getType() == TypeInfo.t_bool || symbol.getType() == TypeInfo.t_char || symbol.getType() == TypeInfo.t_wchar_t || symbol.getType() == TypeInfo.t_int || symbol.getType() == TypeInfo.t_float || symbol.getType() == TypeInfo.t_double || symbol.getType() == TypeInfo.t_void) {
            if (symbol.getContainingSymbol().getType() == TypeInfo.t_class || symbol.getContainingSymbol().getType() == TypeInfo.t_struct || symbol.getContainingSymbol().getType() == TypeInfo.t_union) {
                return new ASTFieldReference(offset, string, (IASTField)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
            }
            if (symbol.getContainingSymbol().getType() == TypeInfo.t_function && symbol.getContainingSymbol() instanceof IParameterizedSymbol && ((IParameterizedSymbol)symbol.getContainingSymbol()).getParameterList() != null && ((IParameterizedSymbol)symbol.getContainingSymbol()).getParameterList().contains(symbol)) {
                return new ASTParameterReference(offset, string, (IASTParameterDeclaration)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
            }
            return new ASTVariableReference(offset, string, (IASTVariable)((Object)symbol.getASTExtension().getPrimaryDeclaration()));
        }
        throw new ASTSemanticException();
    }

    public IASTEnumerationSpecifier createEnumerationSpecifier(IASTScope scope, String name, int startingOffset, int nameOffset, int nameEndOffset) throws ASTSemanticException {
        IContainerSymbol containerSymbol = this.scopeToSymbol(scope);
        TypeInfo.eType pstType = TypeInfo.t_enumeration;
        IDerivableContainerSymbol classSymbol = this.pst.newDerivableContainerSymbol(name, pstType);
        try {
            containerSymbol.addSymbol(classSymbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        ASTEnumerationSpecifier enumSpecifier = new ASTEnumerationSpecifier(classSymbol, startingOffset, nameOffset, nameEndOffset);
        try {
            this.attachSymbolExtension(classSymbol, enumSpecifier);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {
            throw new ASTSemanticException();
        }
        return enumSpecifier;
    }

    public void addEnumerator(IASTEnumerationSpecifier enumeration, String string, int startingOffset, int nameOffset, int nameEndOffset, int endingOffset, IASTExpression initialValue) throws ASTSemanticException {
        IContainerSymbol enumerationSymbol = (IContainerSymbol)((ISymbolOwner)((Object)enumeration)).getSymbol();
        ISymbol enumeratorSymbol = this.pst.newSymbol(string, TypeInfo.t_enumerator);
        try {
            enumerationSymbol.addSymbol(enumeratorSymbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        ASTEnumerator enumerator = new ASTEnumerator(enumeratorSymbol, enumeration, startingOffset, nameOffset, nameEndOffset, endingOffset, initialValue);
        ((ASTEnumerationSpecifier)enumeration).addEnumerator(enumerator);
        try {
            this.attachSymbolExtension(enumeratorSymbol, enumerator);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {
            throw new ASTSemanticException();
        }
    }

    public IASTExpression createExpression(IASTScope scope, IASTExpression.Kind kind, IASTExpression lhs, IASTExpression rhs, IASTExpression thirdExpression, IASTTypeId typeId, ITokenDuple idExpression, String literal, IASTExpression.IASTNewExpressionDescriptor newDescriptor) throws ASTSemanticException {
        ISymbol containingScope;
        ISymbol firstContainingScope;
        TypeInfo lhsInfo;
        ArrayList references = new ArrayList();
        IContainerSymbol startingScope = this.scopeToSymbol(scope);
        ISymbol symbol = null;
        if (idExpression != null) {
            symbol = this.lookupQualifiedName(startingScope, idExpression, references, false);
        }
        if ((kind == IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION || kind == IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS || kind == IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP || kind == IASTExpression.Kind.PM_DOTSTAR || kind == IASTExpression.Kind.PM_ARROWSTAR) && (lhsInfo = (TypeInfo)((ASTExpression)lhs).getResultType().iterator().next()) != null && (firstContainingScope = lhsInfo.getTypeSymbol()) != null && (containingScope = firstContainingScope.getTypeSymbol()) != null) {
            symbol = this.lookupQualifiedName((IContainerSymbol)containingScope, ((ASTExpression)rhs).getIdExpressionTokenDuple(), references, false);
        }
        if (kind == IASTExpression.Kind.PRIMARY_THIS) {
            ASTScope parentScope = (ASTScope)scope;
            while (!(parentScope instanceof IASTClassSpecifier)) {
                parentScope = (ASTScope)parentScope.getOwnerScope();
            }
            if (parentScope instanceof IASTClassSpecifier) {
                symbol = parentScope.getSymbol();
            }
        }
        if (kind == IASTExpression.Kind.POSTFIX_FUNCTIONCALL) {
            ITokenDuple functionId = ((ASTExpression)lhs).getIdExpressionTokenDuple();
            List parameters = ((ASTExpression)rhs).getResultType();
            symbol = this.lookupQualifiedName(startingScope, functionId, TypeInfo.t_function, parameters, references, false);
        }
        ASTExpression expression = new ASTExpression(kind, lhs, rhs, thirdExpression, typeId, idExpression, literal, newDescriptor, references);
        expression.setResultType(this.getExpressionResultType(expression, symbol));
        return expression;
    }

    protected TypeInfo conditionalExpressionConversions(TypeInfo second, TypeInfo third) {
        TypeInfo info = new TypeInfo();
        if (second.equals(third)) {
            info = second;
            return info;
        }
        if (second.getType() == TypeInfo.t_void && third.getType() != TypeInfo.t_void) {
            info = third;
            return info;
        }
        if (second.getType() != TypeInfo.t_void && third.getType() == TypeInfo.t_void) {
            info = second;
            return info;
        }
        if (second.getType() == TypeInfo.t_void && third.getType() == TypeInfo.t_void) {
            info = second;
            return info;
        }
        try {
            info = ParserSymbolTable.getConditionalOperand(second, third);
            return info;
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            return info;
        }
    }

    protected TypeInfo usualArithmeticConversions(TypeInfo lhs, TypeInfo rhs) throws ASTSemanticException {
        while (lhs.getType() == TypeInfo.t_type && lhs.getTypeSymbol() != null) {
            lhs = lhs.getTypeSymbol().getTypeInfo();
        }
        while (rhs.getType() == TypeInfo.t_type && rhs.getTypeSymbol() != null) {
            rhs = rhs.getTypeSymbol().getTypeInfo();
        }
        if (lhs.isType(TypeInfo.t_class, TypeInfo.t_enumeration) || rhs.isType(TypeInfo.t_class, TypeInfo.t_enumeration)) {
            throw new ASTSemanticException();
        }
        TypeInfo info = new TypeInfo();
        if (lhs.checkBit(524288) && lhs.getType() == TypeInfo.t_double || rhs.checkBit(524288) && rhs.getType() == TypeInfo.t_double) {
            info.setType(TypeInfo.t_double);
            info.setBit(true, 524288);
            return info;
        }
        if (lhs.getType() == TypeInfo.t_double || rhs.getType() == TypeInfo.t_double) {
            info.setType(TypeInfo.t_double);
            return info;
        }
        if (lhs.getType() == TypeInfo.t_float || rhs.getType() == TypeInfo.t_float) {
            info.setType(TypeInfo.t_float);
            return info;
        }
        info.setType(TypeInfo.t_int);
        if (lhs.checkBit(131072) && lhs.checkBit(524288) || rhs.checkBit(131072) && rhs.checkBit(524288)) {
            info.setBit(true, 131072);
            info.setBit(true, 524288);
            return info;
        }
        if (lhs.checkBit(131072) && rhs.checkBit(524288) || rhs.checkBit(131072) && lhs.checkBit(524288)) {
            info.setBit(true, 131072);
            info.setBit(true, 524288);
            return info;
        }
        if (lhs.checkBit(524288) || rhs.checkBit(524288)) {
            info.setBit(true, 524288);
            return info;
        }
        if (lhs.checkBit(131072) || rhs.checkBit(131072)) {
            info.setBit(true, 131072);
            return info;
        }
        return info;
    }

    protected List getExpressionResultType(IASTExpression expression, ISymbol symbol) throws ASTSemanticException {
        ArrayList<TypeInfo> result = new ArrayList<TypeInfo>();
        TypeInfo info = new TypeInfo();
        try {
            if (expression.getExpressionKind() == IASTExpression.Kind.PRIMARY_EMPTY || expression.getExpressionKind() == IASTExpression.Kind.THROWEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_DOT_DESTRUCTOR || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_ARROW_DESTRUCTOR || expression.getExpressionKind() == IASTExpression.Kind.DELETE_CASTEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.DELETE_VECTORCASTEXPRESSION) {
                info.setType(TypeInfo.t_void);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.PRIMARY_INTEGER_LITERAL || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SIMPLETYPE_INT) {
                info.setType(TypeInfo.t_int);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.UNARY_SIZEOF_TYPEID || expression.getExpressionKind() == IASTExpression.Kind.UNARY_SIZEOF_UNARYEXPRESSION) {
                info.setType(TypeInfo.t_int);
                info.setBit(true, 131072);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.PRIMARY_CHAR_LITERAL || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SIMPLETYPE_CHAR) {
                info.setType(TypeInfo.t_char);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.PRIMARY_FLOAT_LITERAL || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SIMPLETYPE_FLOAT) {
                info.setType(TypeInfo.t_float);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.PRIMARY_STRING_LITERAL) {
                info.setType(TypeInfo.t_char);
                info.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SIMPLETYPE_DOUBLE) {
                info.setType(TypeInfo.t_double);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SIMPLETYPE_WCHART) {
                info.setType(TypeInfo.t_wchar_t);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.PRIMARY_BOOLEAN_LITERAL || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SIMPLETYPE_BOOL || expression.getExpressionKind() == IASTExpression.Kind.RELATIONAL_GREATERTHAN || expression.getExpressionKind() == IASTExpression.Kind.RELATIONAL_GREATERTHANEQUALTO || expression.getExpressionKind() == IASTExpression.Kind.RELATIONAL_LESSTHAN || expression.getExpressionKind() == IASTExpression.Kind.RELATIONAL_LESSTHANEQUALTO || expression.getExpressionKind() == IASTExpression.Kind.EQUALITY_EQUALS || expression.getExpressionKind() == IASTExpression.Kind.EQUALITY_NOTEQUALS || expression.getExpressionKind() == IASTExpression.Kind.LOGICALANDEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.LOGICALOREXPRESSION) {
                info.setType(TypeInfo.t_bool);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SIMPLETYPE_SHORT) {
                info = (TypeInfo)((ASTExpression)expression.getLHSExpression()).getResultType().iterator().next();
                info.setBit(true, 262144);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SIMPLETYPE_LONG) {
                info = (TypeInfo)((ASTExpression)expression.getLHSExpression()).getResultType().iterator().next();
                info.setBit(true, 524288);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SIMPLETYPE_SIGNED) {
                info = (TypeInfo)((ASTExpression)expression.getLHSExpression()).getResultType().iterator().next();
                info.setBit(false, 131072);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SIMPLETYPE_UNSIGNED) {
                info = (TypeInfo)((ASTExpression)expression.getLHSExpression()).getResultType().iterator().next();
                info.setBit(true, 131072);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.ID_EXPRESSION) {
                info.setType(TypeInfo.t_type);
                info.setTypeSymbol(symbol);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.UNARY_AMPSND_CASTEXPRESSION) {
                List lhsResult = ((ASTExpression)expression.getLHSExpression()).getResultType();
                if (lhsResult.iterator().hasNext()) {
                    info = (TypeInfo)lhsResult.iterator().next();
                }
                if (info != null && info.getTypeSymbol() != null) {
                    info.addOperatorExpression(TypeInfo.OperatorExpression.addressof);
                }
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.UNARY_STAR_CASTEXPRESSION) {
                List lhsResult = ((ASTExpression)expression.getLHSExpression()).getResultType();
                if (lhsResult.iterator().hasNext()) {
                    info = (TypeInfo)lhsResult.iterator().next();
                }
                if (info != null && info.getTypeSymbol() != null) {
                    info.addOperatorExpression(TypeInfo.OperatorExpression.indirection);
                }
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_SUBSCRIPT) {
                List lhsResult = ((ASTExpression)expression.getLHSExpression()).getResultType();
                if (lhsResult.iterator().hasNext()) {
                    info = (TypeInfo)lhsResult.iterator().next();
                }
                if (info != null && info.getTypeSymbol() != null) {
                    info.addOperatorExpression(TypeInfo.OperatorExpression.subscript);
                }
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_DOT_IDEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_ARROW_IDEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_DOT_TEMPL_IDEXPRESS || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_ARROW_TEMPL_IDEXP) {
                if (symbol != null) {
                    info = new TypeInfo(symbol.getTypeInfo());
                }
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.PM_DOTSTAR || expression.getExpressionKind() == IASTExpression.Kind.PM_ARROWSTAR) {
                List rhsResult = ((ASTExpression)expression.getRHSExpression()).getResultType();
                if (rhsResult.iterator().hasNext()) {
                    info = (TypeInfo)rhsResult.iterator().next();
                }
                if (info != null) {
                    info.addOperatorExpression(TypeInfo.OperatorExpression.indirection);
                }
                if (symbol != null) {
                    info.setTypeSymbol(symbol);
                }
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.PRIMARY_THIS) {
                if (symbol != null) {
                    info.setType(TypeInfo.t_type);
                    info.setTypeSymbol(symbol);
                    info.addOperatorExpression(TypeInfo.OperatorExpression.addressof);
                }
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.CONDITIONALEXPRESSION) {
                ASTExpression right = (ASTExpression)expression.getRHSExpression();
                ASTExpression third = (ASTExpression)expression.getThirdExpression();
                if (right != null && third != null) {
                    TypeInfo rightType = (TypeInfo)right.getResultType().iterator().next();
                    TypeInfo thirdType = (TypeInfo)third.getResultType().iterator().next();
                    info = this.conditionalExpressionConversions(rightType, thirdType);
                }
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.NEW_TYPEID || expression.getExpressionKind() == IASTExpression.Kind.NEW_NEWTYPEID) {
                try {
                    info = expression.getTypeId().getTypeSymbol().getTypeInfo();
                    info.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
                }
                catch (ASTNotImplementedException aSTNotImplementedException) {}
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.MULTIPLICATIVE_MULTIPLY || expression.getExpressionKind() == IASTExpression.Kind.MULTIPLICATIVE_DIVIDE || expression.getExpressionKind() == IASTExpression.Kind.MULTIPLICATIVE_MODULUS || expression.getExpressionKind() == IASTExpression.Kind.ADDITIVE_PLUS || expression.getExpressionKind() == IASTExpression.Kind.ADDITIVE_MINUS || expression.getExpressionKind() == IASTExpression.Kind.ANDEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.EXCLUSIVEOREXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.INCLUSIVEOREXPRESSION) {
                ASTExpression left = (ASTExpression)expression.getLHSExpression();
                ASTExpression right = (ASTExpression)expression.getRHSExpression();
                if (left == null || right == null) {
                    throw new ASTSemanticException();
                }
                TypeInfo leftType = (TypeInfo)left.getResultType().iterator().next();
                TypeInfo rightType = (TypeInfo)right.getResultType().iterator().next();
                info = this.usualArithmeticConversions(leftType, rightType);
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.PRIMARY_BRACKETED_EXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_INCREMENT || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_DECREMENT || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_TYPEID_EXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.UNARY_INCREMENT || expression.getExpressionKind() == IASTExpression.Kind.UNARY_DECREMENT || expression.getExpressionKind() == IASTExpression.Kind.UNARY_PLUS_CASTEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.UNARY_MINUS_CASTEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.UNARY_NOT_CASTEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.UNARY_TILDE_CASTEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.SHIFT_LEFT || expression.getExpressionKind() == IASTExpression.Kind.SHIFT_RIGHT || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_NORMAL || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_PLUS || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MINUS || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MULT || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_DIV || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_MOD || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_LSHIFT || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_RSHIFT || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_AND || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_OR || expression.getExpressionKind() == IASTExpression.Kind.ASSIGNMENTEXPRESSION_XOR) {
                ASTExpression left = (ASTExpression)expression.getLHSExpression();
                if (left != null) {
                    info = (TypeInfo)left.getResultType().iterator().next();
                }
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.CASTEXPRESSION || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_DYNAMIC_CAST || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_STATIC_CAST || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_REINTERPRET_CAST || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_CONST_CAST) {
                try {
                    info = new TypeInfo(expression.getTypeId().getTypeSymbol().getTypeInfo());
                }
                catch (Exception exception) {}
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.EXPRESSIONLIST) {
                Iterator i;
                if (expression.getLHSExpression() != null) {
                    i = ((ASTExpression)expression.getLHSExpression()).getResultType().iterator();
                    while (i.hasNext()) {
                        result.add((TypeInfo)i.next());
                    }
                }
                if (expression.getRHSExpression() != null) {
                    i = ((ASTExpression)expression.getRHSExpression()).getResultType().iterator();
                    while (i.hasNext()) {
                        result.add((TypeInfo)i.next());
                    }
                }
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_FUNCTIONCALL) {
                if (symbol != null) {
                    IParameterizedSymbol psymbol = (IParameterizedSymbol)symbol;
                    ISymbol returnTypeSymbol = psymbol.getReturnType();
                    info.setType(returnTypeSymbol.getType());
                    info.setTypeSymbol(returnTypeSymbol);
                }
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_TYPEID_TYPEID) {
                IASTTypeId typeId = expression.getTypeId();
                try {
                    info = typeId.getTypeSymbol().getTypeInfo();
                }
                catch (ASTNotImplementedException aSTNotImplementedException) {}
                result.add(info);
                return result;
            }
            if (expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_TYPENAME_IDENTIFIER || expression.getExpressionKind() == IASTExpression.Kind.POSTFIX_TYPENAME_TEMPLATEID) {
                if (symbol != null) {
                    info.setType(TypeInfo.t_type);
                    info.setTypeSymbol(symbol);
                }
                result.add(info);
                return result;
            }
        }
        catch (Exception exception) {
            throw new ASTSemanticException();
        }
        return result;
    }

    protected void getExpressionReferences(IASTExpression expression, List references) {
        if (expression != null) {
            references.addAll(((ASTExpression)expression).getReferences());
        }
    }

    public IASTExpression.IASTNewExpressionDescriptor createNewDescriptor(List newPlacementExpressions, List newTypeIdExpressions, List newInitializerExpressions) {
        return new ASTNewDescriptor(newPlacementExpressions, newTypeIdExpressions, newInitializerExpressions);
    }

    public IASTExceptionSpecification createExceptionSpecification(IASTScope scope, List typeIds) throws ASTSemanticException {
        ArrayList references = new ArrayList();
        ArrayList<String> newTypeIds = new ArrayList<String>();
        if (typeIds != null) {
            Iterator iter = typeIds.iterator();
            while (iter.hasNext()) {
                IASTTypeId duple = (IASTTypeId)iter.next();
                if (duple == null) continue;
                this.lookupQualifiedName(this.scopeToSymbol(scope), ((ASTTypeId)duple).getTokenDuple(), references, false);
                newTypeIds.add(duple.toString());
            }
        }
        return new ASTExceptionSpecification(newTypeIds, references);
    }

    public IASTConstructorMemberInitializer createConstructorMemberInitializer(IASTScope scope, ITokenDuple duple, IASTExpression expressionList) throws ASTSemanticException {
        ArrayList references = new ArrayList();
        IContainerSymbol scopeSymbol = this.scopeToSymbol(scope);
        if (duple != null) {
            this.lookupQualifiedName(scopeSymbol, duple, references, false);
        }
        this.getExpressionReferences(expressionList, references);
        return new ASTConstructorMemberInitializer(expressionList, duple == null ? "" : duple.toString(), references);
    }

    public IASTSimpleTypeSpecifier createSimpleTypeSpecifier(IASTScope scope, IASTSimpleTypeSpecifier.Type kind, ITokenDuple typeName, boolean isShort, boolean isLong, boolean isSigned, boolean isUnsigned, boolean isTypename) throws ASTSemanticException {
        TypeInfo.eType type = null;
        if (kind == IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) {
            type = TypeInfo.t_type;
        } else if (kind == IASTSimpleTypeSpecifier.Type.BOOL) {
            type = TypeInfo.t_bool;
        } else if (kind == IASTSimpleTypeSpecifier.Type.CHAR) {
            type = TypeInfo.t_char;
        } else if (kind == IASTSimpleTypeSpecifier.Type.DOUBLE) {
            type = TypeInfo.t_double;
        } else if (kind == IASTSimpleTypeSpecifier.Type.FLOAT) {
            type = TypeInfo.t_double;
        } else if (kind == IASTSimpleTypeSpecifier.Type.INT) {
            type = TypeInfo.t_int;
        } else if (kind == IASTSimpleTypeSpecifier.Type.VOID) {
            type = TypeInfo.t_void;
        } else if (kind == IASTSimpleTypeSpecifier.Type.WCHAR_T) {
            type = TypeInfo.t_wchar_t;
        }
        ArrayList references = new ArrayList();
        ISymbol s = this.pst.newSymbol("", type);
        if (kind == IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) {
            Iterator i = typeName.iterator();
            IToken first = typeName.getFirstToken();
            ISymbol typeSymbol = this.getScopeToSearchUpon(scope, first, i);
            while (i.hasNext()) {
                IToken current = (IToken)i.next();
                if (current.getType() == 3) continue;
                try {
                    typeSymbol = current != typeName.getLastToken() ? typeSymbol.lookupNestedNameSpecifier(current.getImage()) : typeSymbol.lookup(current.getImage());
                    if (typeSymbol != null) {
                        this.addReference(references, this.createReference(typeSymbol, current.getImage(), current.getOffset()));
                        continue;
                    }
                    throw new ASTSemanticException();
                }
                catch (ParserSymbolTableException parserSymbolTableException) {
                    throw new ASTSemanticException();
                }
            }
            s.setTypeSymbol(typeSymbol);
        }
        s.getTypeInfo().setBit(isLong, 524288);
        s.getTypeInfo().setBit(isShort, 262144);
        s.getTypeInfo().setBit(isUnsigned, 131072);
        return new ASTSimpleTypeSpecifier(s, false, typeName.toString(), references);
    }

    public IASTFunction createFunction(IASTScope scope, ITokenDuple name, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, boolean isInline, boolean isFriend, boolean isStatic, int startOffset, int nameOffset, int nameEndOffset, IASTTemplate ownerTemplate, boolean isConst, boolean isVolatile, boolean isVirtual, boolean isExplicit, boolean isPureVirtual, List constructorChain, boolean isFunctionDefinition) throws ASTSemanticException {
        IContainerSymbol parentScope;
        ArrayList references = new ArrayList();
        IContainerSymbol ownerScope = this.scopeToSymbol(scope);
        name.iterator();
        if (name.length() > 1 && (parentScope = (IContainerSymbol)this.lookupQualifiedName(ownerScope, name.getSubrange(0, name.findLastTokenType(3) - 1), references, false)) != null && (parentScope.getType() == TypeInfo.t_class || parentScope.getType() == TypeInfo.t_struct || parentScope.getType() == TypeInfo.t_union)) {
            IASTScope methodParentScope = (IASTScope)((Object)parentScope.getASTExtension().getPrimaryDeclaration());
            ITokenDuple newName = name.getSubrange(name.findLastTokenType(3) + 1, name.length() - 1);
            return this.createMethod(methodParentScope, newName.toString(), parameters, returnType, exception, isInline, isFriend, isStatic, startOffset, newName.getFirstToken().getOffset(), nameEndOffset, ownerTemplate, isConst, isVolatile, isVirtual, isExplicit, isPureVirtual, ASTAccessVisibility.PRIVATE, constructorChain, references, isFunctionDefinition);
        }
        IParameterizedSymbol symbol = this.pst.newParameterizedSymbol(name.getLastToken().getImage(), TypeInfo.t_function);
        this.setFunctionTypeInfoBits(isInline, isFriend, isStatic, symbol);
        this.setParameter(symbol, returnType, false, references);
        this.setParameters(symbol, references, parameters.iterator());
        symbol.setIsForwardDeclaration(!isFunctionDefinition);
        boolean previouslyDeclared = false;
        if (isFunctionDefinition) {
            LinkedList<TypeInfo> functionParameters = new LinkedList<TypeInfo>();
            Iterator p = parameters.iterator();
            while (p.hasNext()) {
                ASTParameterDeclaration param = (ASTParameterDeclaration)p.next();
                functionParameters.add(param.getSymbol().getTypeInfo());
            }
            IParameterizedSymbol functionDeclaration = null;
            functionDeclaration = (IParameterizedSymbol)this.lookupQualifiedName(ownerScope, name.getLastToken().getImage(), TypeInfo.t_function, functionParameters, 0, new ArrayList(), false);
            if (functionDeclaration != null) {
                functionDeclaration.setTypeSymbol(symbol);
                previouslyDeclared = true;
            }
        }
        try {
            ownerScope.addSymbol(symbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        ASTFunction function = new ASTFunction(symbol, nameEndOffset, parameters, returnType, exception, startOffset, nameOffset, ownerTemplate, references, previouslyDeclared);
        try {
            this.attachSymbolExtension(symbol, function);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {
            throw new ASTSemanticException();
        }
        return function;
    }

    protected void setFunctionTypeInfoBits(boolean isInline, boolean isFriend, boolean isStatic, IParameterizedSymbol symbol) {
        symbol.getTypeInfo().setBit(isInline, 1024);
        symbol.getTypeInfo().setBit(isFriend, 16384);
        symbol.getTypeInfo().setBit(isStatic, 128);
    }

    protected void setParameters(IParameterizedSymbol symbol, List references, Iterator iterator) throws ASTSemanticException {
        while (iterator.hasNext()) {
            this.setParameter(symbol, (IASTParameterDeclaration)iterator.next(), true, references);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TypeInfo getParameterTypeInfo(IASTAbstractDeclaration absDecl) throws ASTSemanticException {
        TypeInfo type = new TypeInfo();
        if (absDecl.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier.Type kind = ((IASTSimpleTypeSpecifier)absDecl.getTypeSpecifier()).getType();
            if (kind == IASTSimpleTypeSpecifier.Type.BOOL) {
                type.setType(TypeInfo.t_bool);
                return type;
            } else if (kind == IASTSimpleTypeSpecifier.Type.CHAR) {
                type.setType(TypeInfo.t_char);
                return type;
            } else if (kind == IASTSimpleTypeSpecifier.Type.DOUBLE) {
                type.setType(TypeInfo.t_double);
                return type;
            } else if (kind == IASTSimpleTypeSpecifier.Type.FLOAT) {
                type.setType(TypeInfo.t_float);
                return type;
            } else if (kind == IASTSimpleTypeSpecifier.Type.INT) {
                type.setType(TypeInfo.t_int);
                return type;
            } else if (kind == IASTSimpleTypeSpecifier.Type.VOID) {
                type.setType(TypeInfo.t_void);
                return type;
            } else if (kind == IASTSimpleTypeSpecifier.Type.WCHAR_T) {
                type.setType(TypeInfo.t_wchar_t);
                return type;
            } else {
                if (kind != IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) throw new ASTSemanticException();
                type.setType(TypeInfo.t_type);
            }
            return type;
        } else if (absDecl.getTypeSpecifier() instanceof IASTClassSpecifier) {
            ASTClassKind kind = ((IASTClassSpecifier)absDecl.getTypeSpecifier()).getClassKind();
            if (kind == ASTClassKind.CLASS) {
                type.setType(TypeInfo.t_class);
                return type;
            } else if (kind == ASTClassKind.STRUCT) {
                type.setType(TypeInfo.t_struct);
                return type;
            } else {
                if (kind != ASTClassKind.UNION) throw new ASTSemanticException();
                type.setType(TypeInfo.t_union);
            }
            return type;
        } else if (absDecl.getTypeSpecifier() instanceof IASTEnumerationSpecifier) {
            type.setType(TypeInfo.t_enumeration);
            return type;
        } else {
            if (!(absDecl.getTypeSpecifier() instanceof IASTElaboratedTypeSpecifier)) throw new ASTSemanticException();
            ASTClassKind kind = ((IASTElaboratedTypeSpecifier)absDecl.getTypeSpecifier()).getClassKind();
            if (kind == ASTClassKind.CLASS) {
                type.setType(TypeInfo.t_class);
                return type;
            } else if (kind == ASTClassKind.STRUCT) {
                type.setType(TypeInfo.t_struct);
                return type;
            } else if (kind == ASTClassKind.UNION) {
                type.setType(TypeInfo.t_union);
                return type;
            } else {
                if (kind != ASTClassKind.ENUM) throw new ASTSemanticException();
                type.setType(TypeInfo.t_enumeration);
            }
        }
        return type;
    }

    protected void setParameter(IParameterizedSymbol symbol, IASTAbstractDeclaration absDecl, boolean isParameter, List references) throws ASTSemanticException {
        if (absDecl.getTypeSpecifier() == null) {
            return;
        }
        TypeInfo.eType type = this.getParameterTypeInfo(absDecl).getType();
        ISymbol xrefSymbol = null;
        List<IASTReference> newReferences = null;
        if (absDecl.getTypeSpecifier() instanceof IASTSimpleTypeSpecifier) {
            if (((IASTSimpleTypeSpecifier)absDecl.getTypeSpecifier()).getType() == IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) {
                xrefSymbol = ((ASTSimpleTypeSpecifier)absDecl.getTypeSpecifier()).getSymbol();
                newReferences = ((ASTSimpleTypeSpecifier)absDecl.getTypeSpecifier()).getReferences();
            }
        } else if (absDecl.getTypeSpecifier() instanceof ASTElaboratedTypeSpecifier) {
            ASTElaboratedTypeSpecifier elab = (ASTElaboratedTypeSpecifier)absDecl.getTypeSpecifier();
            xrefSymbol = elab.getSymbol();
            newReferences = new ArrayList();
            newReferences.addAll(elab.getReferences());
            newReferences.add(this.createReference(xrefSymbol, elab.getName(), elab.getNameOffset()));
        }
        String paramName = "";
        if (absDecl instanceof IASTParameterDeclaration) {
            paramName = ((IASTParameterDeclaration)absDecl).getName();
        }
        ISymbol paramSymbol = this.pst.newSymbol(paramName, type);
        if (xrefSymbol != null) {
            paramSymbol.setTypeSymbol(xrefSymbol.getTypeSymbol());
        }
        this.setPointerOperators(paramSymbol, absDecl.getPointerOperators(), absDecl.getArrayModifiers());
        if (isParameter) {
            symbol.addParameter(paramSymbol);
        } else {
            symbol.setReturnType(paramSymbol);
        }
        if (newReferences != null) {
            references.addAll(newReferences);
        }
        if (absDecl instanceof ASTParameterDeclaration) {
            ASTParameterDeclaration parm = (ASTParameterDeclaration)absDecl;
            parm.setSymbol(paramSymbol);
            try {
                this.attachSymbolExtension(paramSymbol, parm);
            }
            catch (ISymbolASTExtension.ExtensionException extensionException) {
                throw new ASTSemanticException();
            }
        }
    }

    protected void setPointerOperators(ISymbol symbol, Iterator pointerOpsIterator, Iterator arrayModsIterator) throws ASTSemanticException {
        while (pointerOpsIterator.hasNext()) {
            ASTPointerOperator pointerOperator = (ASTPointerOperator)pointerOpsIterator.next();
            if (pointerOperator == ASTPointerOperator.REFERENCE) {
                symbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_reference));
                continue;
            }
            if (pointerOperator == ASTPointerOperator.POINTER) {
                symbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer));
                continue;
            }
            if (pointerOperator == ASTPointerOperator.CONST_POINTER) {
                symbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, true, false));
                continue;
            }
            if (pointerOperator == ASTPointerOperator.VOLATILE_POINTER) {
                symbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_pointer, false, true));
                continue;
            }
            throw new ASTSemanticException();
        }
        while (arrayModsIterator.hasNext()) {
            arrayModsIterator.next();
            symbol.addPtrOperator(new TypeInfo.PtrOp(TypeInfo.PtrOp.t_array));
        }
    }

    public IASTMethod createMethod(IASTScope scope, String name, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, boolean isInline, boolean isFriend, boolean isStatic, int startOffset, int nameOffset, int nameEndOffset, IASTTemplate ownerTemplate, boolean isConst, boolean isVolatile, boolean isVirtual, boolean isExplicit, boolean isPureVirtual, ASTAccessVisibility visibility, List constructorChain, boolean isFunctionDefinition) throws ASTSemanticException {
        return this.createMethod(scope, name, parameters, returnType, exception, isInline, isFriend, isStatic, startOffset, nameOffset, nameEndOffset, ownerTemplate, isConst, isVolatile, isVirtual, isExplicit, isPureVirtual, visibility, constructorChain, null, isFunctionDefinition);
    }

    public IASTMethod createMethod(IASTScope scope, String name, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, boolean isInline, boolean isFriend, boolean isStatic, int startOffset, int nameOffset, int nameEndOffset, IASTTemplate ownerTemplate, boolean isConst, boolean isVolatile, boolean isVirtual, boolean isExplicit, boolean isPureVirtual, ASTAccessVisibility visibility, List constructorChain, List references, boolean isFunctionDefinition) throws ASTSemanticException {
        boolean isConstructor = false;
        boolean isDestructor = false;
        IContainerSymbol ownerScope = this.scopeToSymbol(scope);
        IParameterizedSymbol symbol = this.pst.newParameterizedSymbol(name, TypeInfo.t_function);
        this.setFunctionTypeInfoBits(isInline, isFriend, isStatic, symbol);
        this.setMethodTypeInfoBits(symbol, isConst, isVolatile, isVirtual, isExplicit);
        if (references == null) {
            references = new ArrayList();
        }
        if (returnType.getTypeSpecifier() != null) {
            this.setParameter(symbol, returnType, false, references);
        }
        this.setParameters(symbol, references, parameters.iterator());
        String parentName = ((IASTClassSpecifier)scope).getName();
        if (returnType.getTypeSpecifier() == null) {
            if (parentName.indexOf("::") != -1) {
                parentName = parentName.substring(parentName.lastIndexOf("::") + "::".length());
            }
            if (parentName.equals(name)) {
                isConstructor = true;
            } else if (name.startsWith("~") && parentName.equals(name.substring(1))) {
                isDestructor = true;
            }
        }
        symbol.setIsForwardDeclaration(!isFunctionDefinition);
        boolean previouslyDeclared = false;
        if (isFunctionDefinition) {
            ArrayList functionReferences;
            LinkedList<TypeInfo> functionParameters = new LinkedList<TypeInfo>();
            Iterator p = parameters.iterator();
            while (p.hasNext()) {
                ASTParameterDeclaration param = (ASTParameterDeclaration)p.next();
                functionParameters.add(param.getSymbol().getTypeInfo());
            }
            IParameterizedSymbol functionDeclaration = null;
            functionDeclaration = (IParameterizedSymbol)this.lookupQualifiedName(ownerScope, name, isConstructor ? TypeInfo.t_constructor : TypeInfo.t_function, functionParameters, 0, functionReferences = new ArrayList(), false);
            if (functionDeclaration != null) {
                previouslyDeclared = true;
                functionDeclaration.setTypeSymbol(symbol);
                ASTMethodReference reference = (ASTMethodReference)functionReferences.iterator().next();
                visibility = ((IASTMethod)reference.getReferencedElement()).getVisiblity();
            }
        }
        try {
            if (!isConstructor) {
                ownerScope.addSymbol(symbol);
            } else {
                symbol.setType(TypeInfo.t_constructor);
                ((IDerivableContainerSymbol)ownerScope).addConstructor(symbol);
            }
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        ASTMethod method = new ASTMethod(symbol, nameEndOffset, parameters, returnType, exception, startOffset, nameOffset, ownerTemplate, references, previouslyDeclared, isConstructor, isDestructor, isPureVirtual, visibility, constructorChain);
        try {
            this.attachSymbolExtension(symbol, method);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {
            throw new ASTSemanticException();
        }
        return method;
    }

    protected void setMethodTypeInfoBits(IParameterizedSymbol symbol, boolean isConst, boolean isVolatile, boolean isVirtual, boolean isExplicit) {
        symbol.getTypeInfo().setBit(isConst, 32768);
        symbol.getTypeInfo().setBit(isVolatile, 32768);
        symbol.getTypeInfo().setBit(isVirtual, 2048);
        symbol.getTypeInfo().setBit(isExplicit, 4096);
    }

    public IASTVariable createVariable(IASTScope scope, String name, boolean isAuto, IASTInitializerClause initializerClause, IASTExpression bitfieldExpression, IASTAbstractDeclaration abstractDeclaration, boolean isMutable, boolean isExtern, boolean isRegister, boolean isStatic, int startingOffset, int nameOffset, int nameEndOffset, IASTExpression constructorExpression) throws ASTSemanticException {
        ISymbol variableDeclaration;
        ArrayList references = new ArrayList();
        IContainerSymbol ownerScope = this.scopeToSymbol(scope);
        StringTokenizer tokenizer = new StringTokenizer(name, "::");
        int tokencount = tokenizer.countTokens();
        if (tokencount > 1) {
            ArrayList<String> tokens = new ArrayList<String>();
            String oneToken = "";
            while (tokenizer.hasMoreTokens()) {
                oneToken = tokenizer.nextToken();
                tokens.add(oneToken);
            }
            String fieldName = oneToken;
            name.substring(0, name.lastIndexOf("::"));
            int numOfTokens = 1;
            int offset = nameOffset;
            IContainerSymbol parentScope = ownerScope;
            Iterator i = tokens.iterator();
            while (i.hasNext() && numOfTokens++ < tokens.size()) {
                String token = (String)i.next();
                IContainerSymbol parentSymbol = (IContainerSymbol)this.lookupQualifiedName(parentScope, token, TypeInfo.t_class, null, offset, references, false);
                if (parentSymbol == null) {
                    parentSymbol = (IContainerSymbol)this.lookupQualifiedName(parentScope, token, TypeInfo.t_namespace, null, offset, references, false);
                }
                if (parentSymbol == null) {
                    parentSymbol = (IContainerSymbol)this.lookupQualifiedName(parentScope, token, TypeInfo.t_struct, null, offset, references, false);
                }
                if (parentSymbol == null) {
                    parentSymbol = (IContainerSymbol)this.lookupQualifiedName(parentScope, token, TypeInfo.t_union, null, offset, references, false);
                }
                if (parentSymbol == null) break;
                parentScope = parentSymbol;
                offset += token.length() + "::".length();
            }
            if (parentScope != null && (parentScope.getType() == TypeInfo.t_class || parentScope.getType() == TypeInfo.t_struct || parentScope.getType() == TypeInfo.t_union)) {
                IASTScope fieldParentScope = (IASTScope)((Object)parentScope.getASTExtension().getPrimaryDeclaration());
                return this.createField(fieldParentScope, fieldName, isAuto, initializerClause, bitfieldExpression, abstractDeclaration, isMutable, isExtern, isRegister, isStatic, startingOffset, offset, nameEndOffset, constructorExpression, ASTAccessVisibility.PRIVATE, references);
            }
        }
        ISymbol newSymbol = this.cloneSimpleTypeSymbol(name, abstractDeclaration, references);
        this.setVariableTypeInfoBits(isAuto, abstractDeclaration, isMutable, isExtern, isRegister, isStatic, newSymbol);
        this.setPointerOperators(newSymbol, abstractDeclaration.getPointerOperators(), abstractDeclaration.getArrayModifiers());
        newSymbol.setIsForwardDeclaration(isStatic);
        boolean previouslyDeclared = false;
        if (!isStatic && (variableDeclaration = this.lookupQualifiedName(ownerScope, name, new ArrayList(), false)) != null) {
            variableDeclaration.setTypeSymbol(newSymbol);
            previouslyDeclared = true;
        }
        try {
            ownerScope.addSymbol(newSymbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
        ASTVariable variable = new ASTVariable(newSymbol, abstractDeclaration, initializerClause, bitfieldExpression, startingOffset, nameOffset, nameEndOffset, references, constructorExpression, previouslyDeclared);
        try {
            this.attachSymbolExtension(newSymbol, variable);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {
            throw new ASTSemanticException();
        }
        return variable;
    }

    protected void setVariableTypeInfoBits(boolean isAuto, IASTAbstractDeclaration abstractDeclaration, boolean isMutable, boolean isExtern, boolean isRegister, boolean isStatic, ISymbol newSymbol) {
        newSymbol.getTypeInfo().setBit(isMutable, 512);
        newSymbol.getTypeInfo().setBit(isAuto, 32);
        newSymbol.getTypeInfo().setBit(isExtern, 256);
        newSymbol.getTypeInfo().setBit(isRegister, 64);
        newSymbol.getTypeInfo().setBit(isStatic, 128);
        newSymbol.getTypeInfo().setBit(abstractDeclaration.isConst(), 32768);
    }

    protected ISymbol cloneSimpleTypeSymbol(String name, IASTAbstractDeclaration abstractDeclaration, List references) throws ASTSemanticException {
        if (abstractDeclaration.getTypeSpecifier() == null) {
            throw new ASTSemanticException();
        }
        ISymbol newSymbol = null;
        ISymbol symbolToBeCloned = null;
        if (abstractDeclaration.getTypeSpecifier() instanceof ASTSimpleTypeSpecifier) {
            symbolToBeCloned = ((ASTSimpleTypeSpecifier)abstractDeclaration.getTypeSpecifier()).getSymbol();
            references.addAll(((ASTSimpleTypeSpecifier)abstractDeclaration.getTypeSpecifier()).getReferences());
        } else if (abstractDeclaration.getTypeSpecifier() instanceof ASTClassSpecifier) {
            symbolToBeCloned = this.pst.newSymbol(name, TypeInfo.t_type);
            symbolToBeCloned.setTypeSymbol(((ASTClassSpecifier)abstractDeclaration.getTypeSpecifier()).getSymbol());
        } else if (abstractDeclaration.getTypeSpecifier() instanceof ASTElaboratedTypeSpecifier) {
            symbolToBeCloned = this.pst.newSymbol(name, TypeInfo.t_type);
            symbolToBeCloned.setTypeSymbol(((ASTElaboratedTypeSpecifier)abstractDeclaration.getTypeSpecifier()).getSymbol());
        }
        newSymbol = (ISymbol)symbolToBeCloned.clone();
        newSymbol.setName(name);
        return newSymbol;
    }

    public IASTField createField(IASTScope scope, String name, boolean isAuto, IASTInitializerClause initializerClause, IASTExpression bitfieldExpression, IASTAbstractDeclaration abstractDeclaration, boolean isMutable, boolean isExtern, boolean isRegister, boolean isStatic, int startingOffset, int nameOffset, int nameEndOffset, IASTExpression constructorExpression, ASTAccessVisibility visibility) throws ASTSemanticException {
        return this.createField(scope, name, isAuto, initializerClause, bitfieldExpression, abstractDeclaration, isMutable, isExtern, isRegister, isStatic, startingOffset, nameOffset, nameEndOffset, constructorExpression, visibility, null);
    }

    public IASTField createField(IASTScope scope, String name, boolean isAuto, IASTInitializerClause initializerClause, IASTExpression bitfieldExpression, IASTAbstractDeclaration abstractDeclaration, boolean isMutable, boolean isExtern, boolean isRegister, boolean isStatic, int startingOffset, int nameOffset, int nameEndOffset, IASTExpression constructorExpression, ASTAccessVisibility visibility, List references) throws ASTSemanticException {
        ArrayList fieldReferences;
        ISymbol fieldDeclaration;
        IContainerSymbol ownerScope = this.scopeToSymbol(scope);
        if (references == null) {
            references = new ArrayList();
        }
        ISymbol newSymbol = this.cloneSimpleTypeSymbol(name, abstractDeclaration, references);
        this.setVariableTypeInfoBits(isAuto, abstractDeclaration, isMutable, isExtern, isRegister, isStatic, newSymbol);
        this.setPointerOperators(newSymbol, abstractDeclaration.getPointerOperators(), abstractDeclaration.getArrayModifiers());
        newSymbol.setIsForwardDeclaration(isStatic);
        boolean previouslyDeclared = false;
        if (!isStatic && (fieldDeclaration = this.lookupQualifiedName(ownerScope, name, fieldReferences = new ArrayList(), false)) != null) {
            previouslyDeclared = true;
            fieldDeclaration.setTypeSymbol(newSymbol);
            ASTReference reference = (ASTReference)fieldReferences.iterator().next();
            visibility = ((IASTField)reference.getReferencedElement()).getVisiblity();
        }
        try {
            ownerScope.addSymbol(newSymbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        ASTField field = new ASTField(newSymbol, abstractDeclaration, initializerClause, bitfieldExpression, startingOffset, nameOffset, nameEndOffset, references, previouslyDeclared, constructorExpression, visibility);
        try {
            this.attachSymbolExtension(newSymbol, field);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {
            throw new ASTSemanticException();
        }
        return field;
    }

    public IASTTemplateDeclaration createTemplateDeclaration(IASTScope scope, List templateParameters, boolean exported, int startingOffset) {
        return new ASTTemplateDeclaration();
    }

    public IASTTemplateParameter createTemplateParameter(IASTTemplateParameter.ParamKind kind, String identifier, String defaultValue, IASTParameterDeclaration parameter, List parms) {
        return null;
    }

    public IASTTemplateInstantiation createTemplateInstantiation(IASTScope scope, int startingOffset) {
        return new ASTTemplateInstantiation();
    }

    public IASTTemplateSpecialization createTemplateSpecialization(IASTScope scope, int startingOffset) {
        return new ASTTemplateSpecialization();
    }

    public IASTTypedefDeclaration createTypedef(IASTScope scope, String name, IASTAbstractDeclaration mapping, int startingOffset, int nameOffset, int nameEndOffset) throws ASTSemanticException {
        IContainerSymbol containerSymbol = this.scopeToSymbol(scope);
        ISymbol newSymbol = this.pst.newSymbol(name, TypeInfo.t_type);
        newSymbol.getTypeInfo().setBit(true, 8192);
        ArrayList references = new ArrayList();
        if (mapping.getTypeSpecifier() instanceof ASTSimpleTypeSpecifier) {
            references.addAll(((ASTSimpleTypeSpecifier)mapping.getTypeSpecifier()).getReferences());
        }
        try {
            containerSymbol.addSymbol(newSymbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        ASTTypedef d = new ASTTypedef(newSymbol, mapping, startingOffset, nameOffset, nameEndOffset, references);
        try {
            this.attachSymbolExtension(newSymbol, d);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {
            throw new ASTSemanticException();
        }
        return d;
    }

    public IASTAbstractTypeSpecifierDeclaration createTypeSpecDeclaration(IASTScope scope, IASTTypeSpecifier typeSpecifier, IASTTemplate template, int startingOffset, int endingOffset) {
        return new ASTAbstractTypeSpecifierDeclaration(this.scopeToSymbol(scope), typeSpecifier, template, startingOffset, endingOffset);
    }

    public IASTElaboratedTypeSpecifier createElaboratedTypeSpecifier(IASTScope scope, ASTClassKind kind, ITokenDuple name, int startingOffset, int endOffset, boolean isForewardDecl) throws ASTSemanticException {
        ASTElaboratedTypeSpecifier elab;
        ITokenDuple containerSymbolName;
        IContainerSymbol currentScopeSymbol = this.scopeToSymbol(scope);
        TypeInfo.eType pstType = this.classKindToTypeInfo(kind);
        ArrayList references = new ArrayList();
        IToken lastToken = name.getLastToken();
        if (name.length() != 1 && (currentScopeSymbol = (IContainerSymbol)this.lookupQualifiedName(currentScopeSymbol, containerSymbolName = name.getSubrange(0, name.length() - 3), references, true)) == null) {
            throw new ASTSemanticException();
        }
        ISymbol checkSymbol = null;
        try {
            checkSymbol = currentScopeSymbol.qualifiedLookup(lastToken.getImage());
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        if (isForewardDecl && checkSymbol == null) {
            checkSymbol = this.pst.newDerivableContainerSymbol(lastToken.getImage(), pstType);
            checkSymbol.setIsForwardDeclaration(true);
            try {
                currentScopeSymbol.addSymbol(checkSymbol);
            }
            catch (ParserSymbolTableException parserSymbolTableException) {
                throw new ASTSemanticException();
            }
            elab = new ASTElaboratedTypeSpecifier(checkSymbol, kind, startingOffset, name.getFirstToken().getOffset(), name.getLastToken().getEndOffset(), endOffset, references, isForewardDecl);
            try {
                this.attachSymbolExtension(checkSymbol, elab);
            }
            catch (ISymbolASTExtension.ExtensionException extensionException) {
                throw new ASTSemanticException();
            }
        }
        if (checkSymbol.getASTExtension().getPrimaryDeclaration() instanceof IASTClassSpecifier || checkSymbol.getASTExtension().getPrimaryDeclaration() instanceof IASTEnumerationSpecifier) {
            elab = new ASTElaboratedTypeSpecifier(checkSymbol, kind, startingOffset, name.getFirstToken().getOffset(), name.getLastToken().getEndOffset(), endOffset, references, isForewardDecl);
            try {
                this.attachSymbolExtension(checkSymbol, elab);
            }
            catch (ISymbolASTExtension.ExtensionException extensionException) {
                throw new ASTSemanticException();
            }
            return elab;
        }
        if (checkSymbol.getASTExtension().getPrimaryDeclaration() instanceof IASTElaboratedTypeSpecifier) {
            return (IASTElaboratedTypeSpecifier)((Object)checkSymbol.getASTExtension().getPrimaryDeclaration());
        }
        throw new ASTSemanticException();
    }

    public IASTNamespaceAlias createNamespaceAlias(IASTScope scope, String identifier, ITokenDuple alias, int startingOffset, int nameOffset, int nameEndOffset, int endOffset) throws ASTSemanticException {
        ArrayList references;
        IContainerSymbol startingSymbol = this.scopeToSymbol(scope);
        ISymbol namespaceSymbol = this.lookupQualifiedName(startingSymbol, alias, references = new ArrayList(), true);
        if (namespaceSymbol.getType() != TypeInfo.t_namespace) {
            throw new ASTSemanticException();
        }
        IContainerSymbol newSymbol = this.pst.newContainerSymbol(identifier, TypeInfo.t_namespace);
        newSymbol.setTypeSymbol(namespaceSymbol);
        try {
            startingSymbol.addSymbol(newSymbol);
        }
        catch (ParserSymbolTableException parserSymbolTableException) {
            throw new ASTSemanticException();
        }
        ASTNamespaceAlias astAlias = new ASTNamespaceAlias(newSymbol, alias.toString(), (IASTNamespaceDefinition)((Object)namespaceSymbol.getASTExtension().getPrimaryDeclaration()), startingOffset, nameOffset, nameEndOffset, endOffset, references);
        try {
            this.attachSymbolExtension(newSymbol, astAlias);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {
            throw new ASTSemanticException();
        }
        return astAlias;
    }

    public IASTCodeScope createNewCodeBlock(IASTScope scope) {
        IContainerSymbol symbol = this.scopeToSymbol(scope);
        IContainerSymbol newScope = this.pst.newContainerSymbol("");
        newScope.setContainingSymbol(symbol);
        ASTCodeScope codeScope = new ASTCodeScope(newScope);
        try {
            this.attachSymbolExtension(newScope, codeScope);
        }
        catch (ISymbolASTExtension.ExtensionException extensionException) {}
        return codeScope;
    }

    public boolean queryIsTypeName(IASTScope scope, ITokenDuple nameInQuestion) {
        ISymbol lookupSymbol = null;
        try {
            lookupSymbol = this.lookupQualifiedName(this.scopeToSymbol(scope), nameInQuestion, new ArrayList(), false);
        }
        catch (ASTSemanticException aSTSemanticException) {}
        if (lookupSymbol == null) {
            return false;
        }
        return lookupSymbol.isType(TypeInfo.t_type, TypeInfo.t_enumeration);
    }

    public IASTParameterDeclaration createParameterDeclaration(boolean isConst, boolean isVolatile, IASTTypeSpecifier typeSpecifier, List pointerOperators, List arrayModifiers, List parameters, ASTPointerOperator pointerOp, String parameterName, IASTInitializerClause initializerClause, int startingOffset, int nameOffset, int nameEndOffset, int endingOffset) {
        return new ASTParameterDeclaration(null, isConst, isVolatile, typeSpecifier, pointerOperators, arrayModifiers, parameters, pointerOp, parameterName, initializerClause, startingOffset, endingOffset, nameOffset, nameEndOffset);
    }

    public IASTTypeId createTypeId(IASTScope scope, IASTSimpleTypeSpecifier.Type kind, boolean isConst, boolean isVolatile, boolean isShort, boolean isLong, boolean isSigned, boolean isUnsigned, boolean isTypename, ITokenDuple name, List pointerOps, List arrayMods) throws ASTSemanticException {
        ASTTypeId result = new ASTTypeId(kind, name, pointerOps, arrayMods, "", isConst, isVolatile, isUnsigned, isSigned, isShort, isLong, isTypename);
        result.setTypeSymbol(this.createSymbolForTypeId(scope, result));
        return result;
    }

    public static TypeInfo.eType getTypeKind(IASTTypeId id) {
        IASTSimpleTypeSpecifier.Type type = id.getKind();
        if (type == IASTSimpleTypeSpecifier.Type.BOOL) {
            return TypeInfo.t_bool;
        }
        if (type == IASTSimpleTypeSpecifier.Type.CHAR) {
            return TypeInfo.t_char;
        }
        if (type == IASTSimpleTypeSpecifier.Type.DOUBLE) {
            return TypeInfo.t_double;
        }
        if (type == IASTSimpleTypeSpecifier.Type.FLOAT) {
            return TypeInfo.t_float;
        }
        if (type == IASTSimpleTypeSpecifier.Type.INT) {
            return TypeInfo.t_int;
        }
        if (type == IASTSimpleTypeSpecifier.Type.VOID) {
            return TypeInfo.t_void;
        }
        if (id.isShort() || id.isLong() || id.isUnsigned() || id.isSigned()) {
            return TypeInfo.t_int;
        }
        return TypeInfo.t_type;
    }

    protected ISymbol createSymbolForTypeId(IASTScope scope, IASTTypeId id) throws ASTSemanticException {
        if (id == null) {
            return null;
        }
        ASTTypeId typeId = (ASTTypeId)id;
        ISymbol result = this.pst.newSymbol("", CompleteParseASTFactory.getTypeKind(id));
        result.getTypeInfo().setBit(id.isConst(), 32768);
        result.getTypeInfo().setBit(id.isVolatile(), 65536);
        result.getTypeInfo().setBit(id.isShort(), 262144);
        result.getTypeInfo().setBit(id.isLong(), 524288);
        result.getTypeInfo().setBit(id.isUnsigned(), 131072);
        ArrayList refs = new ArrayList();
        if (result.getType() == TypeInfo.t_type) {
            ISymbol typeSymbol = this.lookupQualifiedName(this.scopeToSymbol(scope), typeId.getTokenDuple(), refs, true);
            if (typeSymbol.getType() == TypeInfo.t_type) {
                throw new ASTSemanticException();
            }
            result.setTypeSymbol(typeSymbol);
            typeId.addReferences(refs);
        }
        this.setPointerOperators(result, id.getPointerOperators(), id.getArrayModifiers());
        return result;
    }

    public void signalEndOfClassSpecifier(IASTClassSpecifier astClassSpecifier) {
        if (astClassSpecifier == null) {
            return;
        }
        try {
            ((IDerivableContainerSymbol)((ASTClassSpecifier)astClassSpecifier).getSymbol()).addCopyConstructor();
        }
        catch (ParserSymbolTableException parserSymbolTableException) {}
    }
}

