/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.quick;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cdt.core.parser.ITokenDuple;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;

public class ASTSimpleTypeSpecifier
implements IASTSimpleTypeSpecifier {
    private final boolean isTypename;
    private final IASTSimpleTypeSpecifier.Type kind;
    private final String typeName;
    private final boolean isLong;
    private final boolean isShort;
    private final boolean isSigned;
    private final boolean isUnsigned;
    private static final Map nameMap = new Hashtable();

    static {
        nameMap.put(IASTSimpleTypeSpecifier.Type.BOOL, "bool");
        nameMap.put(IASTSimpleTypeSpecifier.Type.CHAR, "char");
        nameMap.put(IASTSimpleTypeSpecifier.Type.DOUBLE, "double");
        nameMap.put(IASTSimpleTypeSpecifier.Type.FLOAT, "float");
        nameMap.put(IASTSimpleTypeSpecifier.Type.INT, "int");
        nameMap.put(IASTSimpleTypeSpecifier.Type.VOID, "void");
        nameMap.put(IASTSimpleTypeSpecifier.Type.WCHAR_T, "wchar_t");
    }

    public ASTSimpleTypeSpecifier(IASTSimpleTypeSpecifier.Type kind, ITokenDuple typeName, boolean isShort, boolean isLong, boolean isSigned, boolean isUnsigned, boolean isTypename) {
        this.kind = kind;
        this.isLong = isLong;
        this.isShort = isShort;
        this.isSigned = isSigned;
        this.isUnsigned = isUnsigned;
        this.isTypename = isTypename;
        StringBuffer type = new StringBuffer();
        if (this.kind == IASTSimpleTypeSpecifier.Type.CHAR || this.kind == IASTSimpleTypeSpecifier.Type.WCHAR_T) {
            if (this.isUnsigned()) {
                type.append("unsigned ");
            }
            type.append((String)nameMap.get(this.kind));
        } else if (this.kind == IASTSimpleTypeSpecifier.Type.BOOL || this.kind == IASTSimpleTypeSpecifier.Type.FLOAT || this.kind == IASTSimpleTypeSpecifier.Type.VOID) {
            type.append((String)nameMap.get(this.kind));
        } else if (this.kind == IASTSimpleTypeSpecifier.Type.INT) {
            if (this.isUnsigned()) {
                type.append("unsigned ");
            }
            if (this.isShort()) {
                type.append("short ");
            }
            if (this.isLong()) {
                type.append("long ");
            }
            type.append((String)nameMap.get(this.kind));
        } else if (this.kind == IASTSimpleTypeSpecifier.Type.DOUBLE) {
            if (this.isLong()) {
                type.append("long ");
            }
            type.append((String)nameMap.get(this.kind));
        } else if (this.kind == IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME || this.kind == IASTSimpleTypeSpecifier.Type.TEMPLATE) {
            if (this.isTypename()) {
                type.append("typename ");
            }
            type.append(typeName.toString());
        } else if (this.kind == IASTSimpleTypeSpecifier.Type.UNSPECIFIED) {
            if (this.isUnsigned()) {
                type.append("unsigned ");
            }
            if (this.isShort()) {
                type.append("short ");
            }
            if (this.isLong()) {
                type.append("long ");
            }
            if (this.isSigned()) {
                type.append("signed ");
            }
        }
        this.typeName = type.toString();
    }

    public IASTSimpleTypeSpecifier.Type getType() {
        return this.kind;
    }

    public String getTypename() {
        return this.typeName;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isTypename() {
        return this.isTypename;
    }

    public IASTTypeSpecifier getTypeSpecifier() throws ASTNotImplementedException {
        throw new ASTNotImplementedException();
    }
}

