/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.ASTPointerOperator;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameter;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.internal.core.parser.ast.ASTArrayModifier;

public class ASTUtil {
    public static String[] getTemplateParameters(IASTTemplateDeclaration templateDeclaration) {
        Iterator i = templateDeclaration.getTemplateParameters();
        return ASTUtil.getTemplateParameters(i);
    }

    public static String[] getTemplateParameters(Iterator templateParams) {
        ArrayList<String> paramList = new ArrayList<String>();
        while (templateParams.hasNext()) {
            StringBuffer paramType = new StringBuffer();
            IASTTemplateParameter parameter = (IASTTemplateParameter)templateParams.next();
            if (parameter.getIdentifier() != null && parameter.getIdentifier().length() != 0) {
                paramList.add(parameter.getIdentifier().toString());
                continue;
            }
            IASTTemplateParameter.ParamKind kind = parameter.getTemplateParameterKind();
            if (kind == IASTTemplateParameter.ParamKind.CLASS) {
                paramType.append("class");
            }
            if (kind == IASTTemplateParameter.ParamKind.TYPENAME) {
                paramType.append("typename");
            }
            if (kind == IASTTemplateParameter.ParamKind.TEMPLATE_LIST) {
                paramType.append("template<");
                String[] subParams = ASTUtil.getTemplateParameters(parameter.getTemplateParameters());
                int p = 0;
                if (subParams.length > 0) {
                    paramType.append(subParams[p++]);
                }
                while (p < subParams.length) {
                    paramType.append(", ");
                    paramType.append(subParams[p++]);
                }
                paramType.append(">");
            }
            if (kind == IASTTemplateParameter.ParamKind.PARAMETER) {
                paramType.append(ASTUtil.getType(parameter.getParameterDeclaration()));
            }
            paramList.add(paramType.toString());
        }
        String[] parameterTypes = new String[paramList.size()];
        int j = 0;
        while (j < paramList.size()) {
            parameterTypes[j] = (String)paramList.get(j);
            ++j;
        }
        return parameterTypes;
    }

    public static String getType(IASTAbstractDeclaration declaration) {
        StringBuffer type = new StringBuffer();
        type.append(ASTUtil.getDeclarationType(declaration));
        type.append(ASTUtil.getPointerOperation(declaration));
        type.append(ASTUtil.getArrayQualifiers(declaration));
        type.append(ASTUtil.getPointerToFunctionType(declaration));
        return type.toString();
    }

    public static String getPointerToFunctionType(IASTAbstractDeclaration declaration) {
        StringBuffer type = new StringBuffer();
        ASTPointerOperator po = declaration.getPointerToFunctionOperator();
        if (po != null) {
            type.append("(");
            type.append(ASTUtil.getPointerOperator(po));
            type.append(")");
            String[] parameters = ASTUtil.getParameterTypes(declaration.getParameters());
            type.append(ASTUtil.getParametersString(parameters));
        }
        return type.toString();
    }

    public static String getDeclarationType(IASTAbstractDeclaration declaration) {
        IASTTypeSpecifier typeSpecifier;
        StringBuffer type = new StringBuffer();
        if (declaration.isConst()) {
            type.append("const ");
        }
        if ((typeSpecifier = declaration.getTypeSpecifier()) instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elab = (IASTElaboratedTypeSpecifier)typeSpecifier;
            type.append(ASTUtil.getElaboratedTypeSignature(elab));
        } else if (typeSpecifier instanceof IASTSimpleTypeSpecifier) {
            IASTSimpleTypeSpecifier simpleSpecifier = (IASTSimpleTypeSpecifier)typeSpecifier;
            type.append(simpleSpecifier.getTypename());
        }
        return type.toString();
    }

    public static String getElaboratedTypeSignature(IASTElaboratedTypeSpecifier elab) {
        StringBuffer type = new StringBuffer();
        ASTClassKind t = elab.getClassKind();
        if (t == ASTClassKind.CLASS) {
            type.append("class");
        } else if (t == ASTClassKind.STRUCT) {
            type.append("struct");
        } else if (t == ASTClassKind.UNION) {
            type.append("union");
        } else if (t == ASTClassKind.STRUCT) {
            type.append("enum");
        }
        type.append(" ");
        type.append(elab.getName().toString());
        return type.toString();
    }

    public static String getPointerOperation(IASTAbstractDeclaration declaration) {
        StringBuffer pointerString = new StringBuffer();
        Iterator i = declaration.getPointerOperators();
        while (i.hasNext()) {
            ASTPointerOperator po = (ASTPointerOperator)i.next();
            pointerString.append(ASTUtil.getPointerOperator(po));
        }
        return pointerString.toString();
    }

    public static String getPointerOperator(ASTPointerOperator po) {
        String pointerString = "";
        if (po == ASTPointerOperator.POINTER) {
            pointerString = "*";
        }
        if (po == ASTPointerOperator.REFERENCE) {
            pointerString = "&";
        }
        if (po == ASTPointerOperator.CONST_POINTER) {
            pointerString = "* const";
        }
        if (po == ASTPointerOperator.VOLATILE_POINTER) {
            pointerString = "* volatile";
        }
        return pointerString;
    }

    public static String getArrayQualifiers(IASTAbstractDeclaration declaration) {
        StringBuffer arrayString = new StringBuffer();
        Iterator i = declaration.getArrayModifiers();
        while (i.hasNext()) {
            ASTArrayModifier cfr_ignored_0 = (ASTArrayModifier)i.next();
            arrayString.append("[]");
        }
        return arrayString.toString();
    }

    public static String[] getFunctionParameterTypes(IASTFunction functionDeclaration) {
        Iterator parameters = functionDeclaration.getParameters();
        return ASTUtil.getParameterTypes(parameters);
    }

    public static String[] getParameterTypes(Iterator parameters) {
        ArrayList<String> paramList = new ArrayList<String>();
        while (parameters.hasNext()) {
            IASTParameterDeclaration param = (IASTParameterDeclaration)parameters.next();
            paramList.add(ASTUtil.getType(param));
        }
        String[] parameterTypes = new String[paramList.size()];
        int i = 0;
        while (i < paramList.size()) {
            parameterTypes[i] = (String)paramList.get(i);
            ++i;
        }
        return parameterTypes;
    }

    public static String getParametersString(String[] parameterTypes) {
        StringBuffer parameters = new StringBuffer("");
        if (parameterTypes != null && parameterTypes.length > 0) {
            parameters.append("(");
            int i = 0;
            parameters.append(parameterTypes[i++]);
            while (i < parameterTypes.length) {
                parameters.append(", ");
                parameters.append(parameterTypes[i++]);
            }
            parameters.append(")");
        } else if (parameterTypes != null) {
            parameters.append("()");
        }
        return parameters.toString();
    }
}

