/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;

public class MethodDeclarationPattern
extends CSearchPattern {
    private ICSearchConstants.SearchFor searchFor;
    private char[][] parameterNames;
    private char[] simpleName;
    private char[][] qualifications;
    private char[] decodedSimpleName;
    private char[][] decodedQualifications;

    public MethodDeclarationPattern(char[] name, char[][] qual, char[][] params, int matchMode, ICSearchConstants.SearchFor search, ICSearchConstants.LimitTo limitTo, boolean caseSensitive) {
        super(matchMode, caseSensitive, limitTo);
        this.qualifications = qual;
        this.simpleName = name;
        this.parameterNames = params;
        this.searchFor = search;
    }

    public char[] getSimpleName() {
        return this.simpleName;
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        if (node instanceof IASTMethod) {
            if (this.searchFor != ICSearchConstants.METHOD || !this.canAccept(limit)) {
                return 0;
            }
        } else if (node instanceof IASTFunction) {
            if (this.searchFor != ICSearchConstants.FUNCTION || !this.canAccept(limit)) {
                return 0;
            }
        } else {
            return 0;
        }
        IASTFunction function = (IASTFunction)node;
        String nodeName = function.getName();
        if (this.simpleName != null && !this.matchesName(this.simpleName, nodeName.toCharArray())) {
            return 0;
        }
        if (node instanceof IASTQualifiedNameElement) {
            String[] fullName = ((IASTQualifiedNameElement)((Object)node)).getFullyQualifiedName();
            char[][] qualName = new char[fullName.length - 1][];
            int i = 0;
            while (i < fullName.length - 1) {
                qualName[i] = fullName[i].toCharArray();
                ++i;
            }
            if (!this.matchQualifications(this.qualifications, qualName)) {
                return 0;
            }
        }
        if (this.parameterNames != null && this.parameterNames.length > 0 && this.parameterNames[0].length > 0) {
            Iterator params = function.getParameters();
            int i = 0;
            while (i < this.parameterNames.length) {
                if (!params.hasNext() || this.parameterNames[i] == null) {
                    return 0;
                }
                IASTParameterDeclaration parameter = (IASTParameterDeclaration)params.next();
                char[] param = CSearchPattern.getParamString(parameter);
                if (!CharOperation.equals(this.parameterNames[i], param, this._caseSensitive)) {
                    return 0;
                }
                ++i;
            }
            if (params.hasNext()) {
                return 0;
            }
        }
        return 2;
    }

    public char[] indexEntryPrefix() {
        if (this.searchFor == ICSearchConstants.FUNCTION) {
            return AbstractIndexer.bestFunctionPrefix(this._limitTo, this.simpleName, this._matchMode, this._caseSensitive);
        }
        if (this.searchFor == ICSearchConstants.METHOD) {
            return AbstractIndexer.bestMethodPrefix(this._limitTo, this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
        }
        return null;
    }

    protected void resetIndexInfo() {
        this.decodedSimpleName = null;
        this.decodedQualifications = null;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int firstSlash = CharOperation.indexOf('/', word, 0);
        int slash = CharOperation.indexOf('/', word, firstSlash + 1);
        this.decodedSimpleName = CharOperation.subarray(word, firstSlash + 1, slash);
        if (slash != -1 && slash + 1 < size) {
            char[][] temp = CharOperation.splitOn('/', CharOperation.subarray(word, slash + 1, size));
            this.decodedQualifications = new char[temp.length][];
            int i = 0;
            while (i < temp.length) {
                this.decodedQualifications[i] = temp[temp.length - i - 1];
                ++i;
            }
        }
    }

    protected boolean matchIndexEntry() {
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedQualifications);
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, ICSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = file.getPath())) {
                if (this.searchFor == ICSearchConstants.METHOD) {
                    requestor.acceptMethodDeclaration(path, this.decodedSimpleName, this.parameterNames.length, this.decodedQualifications);
                } else if (this.searchFor == ICSearchConstants.FUNCTION) {
                    requestor.acceptFunctionDeclaration(path, this.decodedSimpleName, this.parameterNames.length);
                }
            }
            ++i;
        }
    }
}

