/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.sourcedependency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.cdt.internal.core.index.impl.IFileDocument;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexInput;
import org.eclipse.cdt.internal.core.index.impl.IndexedFile;
import org.eclipse.cdt.internal.core.search.IndexSelector;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.cdt.internal.core.search.processing.JobManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class DependencyQueryJob
implements IJob {
    IProject project;
    IFile file;
    ArrayList includeFiles;
    IndexManager indexManager;
    protected IndexSelector indexSelector;
    protected long executionTime = 0L;

    public DependencyQueryJob(IProject project, IFile file, IndexManager inMan, List includeFiles) {
        this.project = project;
        this.file = file;
        this.indexManager = inMan;
        this.includeFiles = (ArrayList)includeFiles;
    }

    public boolean belongsTo(String jobFamily) {
        return true;
    }

    public void cancel() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        boolean bl;
        if (this.project == null || this.file == null) {
            return false;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        boolean isComplete = true;
        this.executionTime = 0L;
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(SearchEngine.createWorkspaceScope(), null, false, this.indexManager);
        }
        IIndex[] searchIndexes = this.indexSelector.getIndexes();
        try {
            int max = searchIndexes.length;
            if (progressMonitor != null) {
                progressMonitor.beginTask("", max);
            }
            int i = 0;
            while (i < max) {
                isComplete &= this.getFileDeps(searchIndexes[i], progressMonitor);
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    progressMonitor.worked(1);
                }
                ++i;
            }
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> execution time: " + this.executionTime + "ms - " + this);
            }
            bl = isComplete;
            Object var6_7 = null;
            if (progressMonitor == null) return bl;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (progressMonitor == null) throw throwable;
            progressMonitor.done();
            throw throwable;
        }
        progressMonitor.done();
        return bl;
    }

    public boolean getFileDeps(IIndex index, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.indexManager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                if (index.hasChanged()) {
                    try {
                        try {
                            monitor.exitRead();
                            monitor.enterWrite();
                            this.indexManager.saveIndex(index);
                        }
                        catch (IOException iOException) {
                            Object var4_4 = null;
                            monitor.exitWriteEnterRead();
                            Object var9_8 = null;
                            monitor.exitRead();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        monitor.exitWriteEnterRead();
                        throw throwable;
                    }
                    Object var4_6 = null;
                    monitor.exitWriteEnterRead();
                }
                long start = System.currentTimeMillis();
                BlocksIndexInput input = new BlocksIndexInput(index.getIndexFile());
                try {
                    ((IndexInput)input).open();
                    this.findDep(input);
                }
                catch (Throwable throwable) {
                    Object var7_15 = null;
                    ((IndexInput)input).close();
                    throw throwable;
                }
                Object var7_16 = null;
                ((IndexInput)input).close();
                this.executionTime += System.currentTimeMillis() - start;
                Object var9_9 = null;
                monitor.exitRead();
                return true;
            }
            catch (IOException iOException) {
                Object var9_10 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            monitor.exitRead();
            throw throwable;
        }
    }

    private void findDep(IndexInput input) throws IOException {
        IFileDocument temp = new IFileDocument(this.file);
        IndexedFile dude = input.getIndexedFile(temp);
        if (dude == null) {
            return;
        }
        int fileNum = dude.getFileNumber();
        IncludeEntry[] tempEntries = input.queryIncludeEntries(fileNum);
        if (tempEntries != null) {
            int r = 0;
            while (r < tempEntries.length) {
                char[] tempFile = tempEntries[r].getFile();
                StringBuffer tempString = new StringBuffer();
                tempString.append(tempFile);
                this.includeFiles.add(tempString.toString());
                ++r;
            }
        }
    }

    public String toString() {
        return "searching for the dependencies of" + this.file.getName();
    }

    public boolean isReadyToRun() {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(SearchEngine.createWorkspaceScope(), null, false, this.indexManager);
            this.indexSelector.getIndexes();
        }
        return true;
    }
}

