/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.utils.elf.AR;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.ElfHelper;
import org.eclipse.cdt.utils.elf.parser.BinaryObject;
import org.eclipse.cdt.utils.elf.parser.Symbol;
import org.eclipse.core.runtime.IPath;

public class ARMember
extends BinaryObject {
    AR.ARHeader header;

    public ARMember(IPath p, AR.ARHeader h) throws IOException {
        super(p);
        this.header = h;
    }

    public InputStream getContents() {
        InputStream stream = null;
        if (this.path != null && this.header != null) {
            try {
                stream = new ByteArrayInputStream(this.header.getObjectData());
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    public String getName() {
        if (this.header != null) {
            return this.header.getObjectName();
        }
        return "";
    }

    protected ElfHelper getElfHelper() throws IOException {
        if (this.header != null) {
            return new ElfHelper(this.header.getElf());
        }
        throw new IOException("No file assiocated with Binary");
    }

    protected void addSymbols(Elf.Symbol[] array, int type) {
        int i = 0;
        while (i < array.length) {
            Symbol sym = new Symbol();
            sym.type = type;
            sym.name = array[i].toString();
            sym.addr = array[i].st_value;
            this.addSymbol(sym);
            ++i;
        }
    }
}

