/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.ElfHelper;
import org.eclipse.cdt.utils.elf.parser.BinaryFile;
import org.eclipse.cdt.utils.elf.parser.Symbol;
import org.eclipse.core.runtime.IPath;

public class BinaryObject
extends BinaryFile
implements IBinaryParser.IBinaryObject {
    protected String soname;
    protected String[] needed;
    protected int type = 1;
    private long timestamp;
    private ElfHelper.Sizes sizes;
    private Elf.Attribute attribute;
    private ArrayList symbols;

    public BinaryObject(IPath path) throws IOException {
        super(path);
        this.loadInformation();
        this.hasChanged();
    }

    public long getBSS() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.bss;
        }
        return 0L;
    }

    public String getCPU() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.getCPU();
        }
        return "";
    }

    public long getData() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.data;
        }
        return 0L;
    }

    public long getText() {
        ElfHelper.Sizes sz = this.getSizes();
        if (sz != null) {
            return this.sizes.text;
        }
        return 0L;
    }

    public boolean hasDebug() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.hasDebug();
        }
        return false;
    }

    public boolean isLittleEndian() {
        Elf.Attribute attr = this.getAttribute();
        if (attr != null) {
            return this.attribute.isLittleEndian();
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        this.type = t;
    }

    public IBinaryParser.ISymbol[] getSymbols() {
        if (this.hasChanged() || this.symbols == null) {
            if (this.symbols == null) {
                this.symbols = new ArrayList(5);
            }
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
        }
        return this.symbols.toArray(new IBinaryParser.ISymbol[0]);
    }

    public InputStream getContents() {
        InputStream stream = null;
        if (this.path != null) {
            try {
                stream = new FileInputStream(this.path.toFile());
            }
            catch (IOException iOException) {}
        }
        if (stream == null) {
            stream = super.getContents();
        }
        return stream;
    }

    public String getName() {
        if (this.path != null) {
            return this.path.lastSegment().toString();
        }
        return "";
    }

    public String toString() {
        return this.getName();
    }

    protected Elf.Attribute getAttribute() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
        }
        return this.attribute;
    }

    protected ElfHelper.Sizes getSizes() {
        if (this.hasChanged()) {
            try {
                this.loadInformation();
            }
            catch (IOException iOException) {}
        }
        return this.sizes;
    }

    boolean hasChanged() {
        long modification = this.path.toFile().lastModified();
        boolean changed = modification != this.timestamp;
        this.timestamp = modification;
        return changed;
    }

    protected ElfHelper getElfHelper() throws IOException {
        if (this.path != null) {
            return new ElfHelper(this.path.toOSString());
        }
        throw new IOException("No file assiocated with Binary");
    }

    protected void loadInformation() throws IOException {
        block3: {
            ElfHelper helper = null;
            try {
                helper = this.getElfHelper();
                this.loadInformation(helper);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (helper != null) {
                    helper.dispose();
                }
                throw throwable;
            }
            Object var2_4 = null;
            if (helper == null) break block3;
            helper.dispose();
        }
    }

    private void loadInformation(ElfHelper helper) throws IOException {
        this.loadAttributes(helper);
        if (this.symbols != null) {
            this.symbols.clear();
            this.loadSymbols(helper);
            this.symbols.trimToSize();
        }
    }

    private void loadAttributes(ElfHelper helper) throws IOException {
        Elf.Dynamic[] sharedlibs = helper.getNeeded();
        this.needed = new String[sharedlibs.length];
        int i = 0;
        while (i < sharedlibs.length) {
            this.needed[i] = sharedlibs[i].toString();
            ++i;
        }
        this.sizes = helper.getSizes();
        this.soname = helper.getSoname();
        this.attribute = helper.getElf().getAttributes();
    }

    private void loadSymbols(ElfHelper helper) throws IOException {
        Elf.Dynamic[] sharedlibs = helper.getNeeded();
        this.needed = new String[sharedlibs.length];
        int i = 0;
        while (i < sharedlibs.length) {
            this.needed[i] = sharedlibs[i].toString();
            ++i;
        }
        this.sizes = helper.getSizes();
        this.soname = helper.getSoname();
        this.attribute = helper.getElf().getAttributes();
        this.addSymbols(helper.getExternalFunctions(), 1);
        this.addSymbols(helper.getLocalFunctions(), 1);
        this.addSymbols(helper.getExternalObjects(), 2);
        this.addSymbols(helper.getLocalObjects(), 2);
        this.symbols.trimToSize();
    }

    protected void addSymbols(Elf.Symbol[] array, int type) {
        int i = 0;
        while (i < array.length) {
            Symbol sym = new Symbol();
            sym.type = type;
            sym.name = array[i].toString();
            sym.addr = array[i].st_value;
            try {
                sym.filename = array[i].getFilename();
                sym.endLine = sym.startLine = array[i].getFuncLineNumber();
            }
            catch (IOException iOException) {}
            this.addSymbol(sym);
            ++i;
        }
    }

    protected void addSymbol(Symbol sym) {
        this.symbols.add(sym);
    }
}

