/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.make.internal.ui.editor.IMakefileDocumentProvider;
import org.eclipse.cdt.make.internal.ui.editor.MakefileDocumentProvider;
import org.eclipse.cdt.make.internal.ui.editor.WorkingCopyManager;
import org.eclipse.cdt.make.ui.IWorkingCopyManager;
import org.eclipse.cdt.make.ui.actions.UpdateMakeProjectAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MakeUIPlugin
extends AbstractUIPlugin
implements IStartup {
    private static MakeUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private IWorkingCopyManager fWorkingCopyManager;
    private IMakefileDocumentProvider fMakefileDocumentProvider;

    public MakeUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.make.internal.ui.MakeResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static MakeUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = MakeUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return MakeUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = MakeUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MakeUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getUniqueIdentifier() {
        if (MakeUIPlugin.getDefault() == null) {
            return "org.eclipse.cdt.make.ui";
        }
        return MakeUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        MakeUIPlugin.log((IStatus)new Status(4, MakeUIPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void logException(Throwable e, final String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, MakeUIPlugin.getUniqueIdentifier(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        final IStatus fstatus = status;
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)title, null, (IStatus)fstatus);
            }
        });
    }

    public static void logException(Throwable e) {
        MakeUIPlugin.logException(e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, MakeUIPlugin.getUniqueIdentifier(), 0, e.getMessage(), e);
        MakeUIPlugin.log(status);
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        MakeUIPlugin.log(s);
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        MakeUIPlugin.log(t);
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, MakeUIPlugin.getUniqueIdentifier(), -1, "Internal Error: ", t);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public void earlyStartup() {
        final IProject[] oldProject = UpdateMakeProjectAction.getOldProjects();
        if (oldProject.length > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (MessageDialog.openQuestion((Shell)MakeUIPlugin.this.getShell(), (String)"Update make projects", (String)"Older 'make' projects have been detected in your workspace. \nThese projects are no longer supported, would you like to convert these now?")) {
                        ProgressMonitorDialog pd = new ProgressMonitorDialog(MakeUIPlugin.this.getShell());
                        UpdateMakeProjectAction.run(false, (IRunnableContext)pd, oldProject);
                    }
                }
            });
        }
    }

    protected Shell getShell() {
        if (MakeUIPlugin.getActiveWorkbenchShell() != null) {
            return MakeUIPlugin.getActiveWorkbenchShell();
        }
        IWorkbenchWindow[] windows = MakeUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return windows[0].getShell();
    }

    public synchronized IMakefileDocumentProvider getMakefileDocumentProvider() {
        if (this.fMakefileDocumentProvider == null) {
            this.fMakefileDocumentProvider = new MakefileDocumentProvider();
        }
        return this.fMakefileDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            IMakefileDocumentProvider provider = this.getMakefileDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        if (this.fWorkingCopyManager != null) {
            this.fWorkingCopyManager.shutdown();
            this.fWorkingCopyManager = null;
        }
    }
}

