/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import java.util.ResourceBundle;
import org.eclipse.cdt.make.core.makefile.IDirective;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.editor.MakefileContentOutlinePage;
import org.eclipse.cdt.make.internal.ui.editor.MakefileSourceConfiguration;
import org.eclipse.cdt.make.internal.ui.text.MakefileColorManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

public class MakefileEditor
extends TextEditor
implements ISelectionChangedListener {
    protected MakefileContentOutlinePage page;
    private IMakefile makefile;
    static /* synthetic */ Class class$0;

    private MakefileContentOutlinePage getOutlinePage() {
        if (this.page == null) {
            this.page = new MakefileContentOutlinePage(this);
            this.page.addSelectionChangedListener(this);
            this.page.setInput(this.getEditorInput());
        }
        return this.page;
    }

    public MakefileEditor() {
        this.initializeEditor();
    }

    protected void initializeEditor() {
        this.setSourceViewerConfiguration(new MakefileSourceConfiguration(new MakefileColorManager(), this));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId("#MakefileEditorContext");
        this.setRulerContextMenuId("#MakefileRulerContext");
        this.setDocumentProvider(MakeUIPlugin.getDefault().getMakefileDocumentProvider());
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.getOutlinePage();
        }
        return super.getAdapter(key);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        this.makefile = null;
        if (this.page != null) {
            this.page.update();
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = MakeUIPlugin.getDefault().getResourceBundle();
        TextOperationAction a = new TextOperationAction(bundle, "ContentAssistProposal.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        a = new TextOperationAction(bundle, "ContentAssistTip.", (ITextEditor)this, 14);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistTip", (IAction)a);
        a = new TextOperationAction(bundle, "Comment.", (ITextEditor)this, 11);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.uncomment");
        this.setAction("Comment", (IAction)a);
        this.markAsStateDependentAction("Comment", true);
        a = new TextOperationAction(bundle, "Uncomment.", (ITextEditor)this, 12);
        a.setActionDefinitionId("org.eclipse.cdt.make.ui.edit.text.makefile.comment");
        this.setAction("Uncomment", (IAction)a);
        this.markAsStateDependentAction("Uncomment", true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.resetHighlightRange();
        } else if (selection instanceof IStructuredSelection) {
            Object element;
            if (!this.isActivePart() && MakeUIPlugin.getActivePage() != null) {
                MakeUIPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
            }
            if ((element = ((IStructuredSelection)selection).getFirstElement()) instanceof IDirective) {
                IDirective statement = (IDirective)element;
                this.setSelection(statement, !this.isActivePart());
            }
        }
    }

    private boolean isActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part != null && part.equals((Object)this);
    }

    private void setSelection(IDirective directive, boolean moveCursor) {
        int startLine = directive.getStartLine() - 1;
        int endLine = directive.getEndLine() - 1;
        try {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
            int start = doc.getLineOffset(startLine);
            int len = doc.getLineLength(endLine) - 1;
            int length = doc.getLineOffset(endLine) + len - start;
            this.setHighlightRange(start, length, true);
            if (moveCursor) {
                String var = directive.toString().trim();
                len = 0;
                while (len < var.length()) {
                    char c = var.charAt(len);
                    if (!Character.isLetterOrDigit(c) && c != '.' && c != '_') break;
                    ++len;
                }
                if (len > 0) {
                    var = var.substring(0, len);
                }
                len = doc.search(start, var, true, true, true);
                length = var.length();
                if (len > -1 && length > 0) {
                    this.getSourceViewer().revealRange(len, length);
                    this.getSourceViewer().setSelectedRange(len, length);
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.resetHighlightRange();
        }
        catch (BadLocationException badLocationException) {
            this.resetHighlightRange();
        }
    }
}

