/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;

public class MakeBuilder
extends ACBuilder {
    private static final String BUILD_ERROR = "MakeBuilder.buildError";
    public static final String BUILDER_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        boolean isClean;
        boolean bPerformBuild = true;
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(args, BUILDER_ID);
        if (!this.shouldBuild(kind, info)) {
            this.forgetLastBuiltState();
            return new IProject[0];
        }
        if (kind == 9) {
            MyResourceDeltaVisitor vis = new MyResourceDeltaVisitor();
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)vis);
                bPerformBuild = vis.shouldBuild();
            } else {
                bPerformBuild = false;
            }
        }
        if (bPerformBuild && (isClean = this.invokeMake(kind, info, monitor))) {
            this.forgetLastBuiltState();
        }
        this.checkCancel(monitor);
        return this.getProject().getReferencedProjects();
    }

    private boolean invokeMake(int kind, IMakeBuilderInfo info, IProgressMonitor monitor) {
        boolean isClean;
        block23: {
            isClean = false;
            IProject currProject = this.getProject();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask(String.valueOf(MakeCorePlugin.getResourceString("MakeBuilder.Invoking_Make_Builder")) + currProject.getName(), -1);
            try {
                try {
                    Process p;
                    String[] targets;
                    IResource res;
                    IPath buildCommand = info.getBuildCommand();
                    if (buildCommand == null) break block23;
                    IConsole console = CCorePlugin.getDefault().getConsole();
                    console.start(currProject);
                    ConsoleOutputStream cos = console.getOutputStream();
                    this.removeAllMarkers(currProject);
                    IPath workingDirectory = null;
                    if (!info.getBuildLocation().isEmpty() && (res = currProject.getParent().findMember(info.getBuildLocation())) instanceof IContainer && res.exists()) {
                        workingDirectory = res.getLocation();
                    }
                    if (workingDirectory == null) {
                        workingDirectory = currProject.getLocation();
                    }
                    if ((targets = this.getTargets(kind, info)).length != 0 && targets[targets.length - 1].equals("clean")) {
                        isClean = true;
                    }
                    monitor.subTask(String.valueOf(MakeCorePlugin.getResourceString("MakeBuilder.Invoking_Command")) + buildCommand.toString());
                    String errMsg = null;
                    CommandLauncher launcher = new CommandLauncher();
                    launcher.showCommand(true);
                    Properties props = launcher.getEnvironment();
                    ((Hashtable)props).put("CWD", workingDirectory.toOSString());
                    ((Hashtable)props).put("PWD", workingDirectory.toOSString());
                    String[] env = null;
                    ArrayList<String> envList = new ArrayList<String>();
                    Enumeration<?> names = props.propertyNames();
                    if (names != null) {
                        while (names.hasMoreElements()) {
                            String key = (String)names.nextElement();
                            envList.add(String.valueOf(key) + "=" + props.getProperty(key));
                        }
                        env = envList.toArray(new String[envList.size()]);
                    }
                    ErrorParserManager epm = new ErrorParserManager(this.getProject(), (IMarkerGenerator)this, info.getErrorParsers());
                    epm.setOutputStream((OutputStream)cos);
                    OutputStream stdout = epm.getOutputStream();
                    OutputStream stderr = epm.getOutputStream();
                    String[] buildArguments = targets;
                    if (info.isDefaultBuildCmd()) {
                        if (!info.isStopOnError()) {
                            buildArguments = new String[targets.length + 1];
                            buildArguments[0] = "-k";
                            System.arraycopy(targets, 0, buildArguments, 1, targets.length);
                        }
                    } else {
                        String args = info.getBuildArguments();
                        if (args != null && !args.equals("")) {
                            String[] newArgs = this.makeArray(args);
                            buildArguments = new String[targets.length + newArgs.length];
                            System.arraycopy(newArgs, 0, buildArguments, 0, newArgs.length);
                            System.arraycopy(targets, 0, buildArguments, newArgs.length, targets.length);
                        }
                    }
                    if ((p = launcher.execute(buildCommand, buildArguments, env, workingDirectory)) != null) {
                        try {
                            p.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                        if (launcher.waitAndRead(stdout, stderr, (IProgressMonitor)new SubProgressMonitor(monitor, -1)) != 0) {
                            errMsg = launcher.getErrorMessage();
                        }
                        monitor.subTask(MakeCorePlugin.getResourceString("MakeBuilder.Updating_project"));
                        try {
                            currProject.refreshLocal(2, null);
                        }
                        catch (CoreException coreException) {}
                    } else {
                        errMsg = launcher.getErrorMessage();
                    }
                    if (errMsg != null) {
                        StringBuffer buf = new StringBuffer(String.valueOf(buildCommand.toString()) + " ");
                        int i = 0;
                        while (i < buildArguments.length) {
                            buf.append(buildArguments[i]);
                            buf.append(' ');
                            ++i;
                        }
                        String errorDesc = MakeCorePlugin.getFormattedString(BUILD_ERROR, buf.toString());
                        buf = new StringBuffer(errorDesc);
                        buf.append(System.getProperty("line.separator", "\n"));
                        buf.append("(").append(errMsg).append(")");
                        cos.write(buf.toString().getBytes());
                        cos.flush();
                    }
                    stdout.close();
                    stderr.close();
                    monitor.subTask(MakeCorePlugin.getResourceString("MakeBuilder.Creating_Markers"));
                    epm.reportProblems();
                }
                catch (Exception e) {
                    CCorePlugin.log((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var24_27 = null;
                monitor.done();
                throw throwable;
            }
        }
        Object var24_28 = null;
        monitor.done();
        return isClean;
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected boolean shouldBuild(int kind, IMakeBuilderInfo info) {
        switch (kind) {
            case 9: {
                return info.isAutoBuildEnable();
            }
            case 10: {
                return info.isIncrementalBuildEnabled();
            }
            case 6: {
                return info.isFullBuildEnabled();
            }
        }
        return true;
    }

    protected String[] getTargets(int kind, IMakeBuilderInfo info) {
        String targets = "";
        switch (kind) {
            case 9: {
                targets = info.getAutoBuildTarget();
                break;
            }
            case 10: {
                targets = info.getIncrementalBuildTarget();
                break;
            }
            case 6: {
                targets = info.getFullBuildTarget();
            }
        }
        return this.makeArray(targets);
    }

    String[] makeArray(String string) {
        string.trim();
        char[] array = string.toCharArray();
        ArrayList<String> aList = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        boolean inComment = false;
        int i = 0;
        while (i < array.length) {
            char c = array[i];
            if (array[i] == '\"' || array[i] == '\'') {
                if (i > 0 && array[i - 1] == '\\') {
                    inComment = false;
                } else {
                    boolean bl = inComment = !inComment;
                }
            }
            if (c == ' ' && !inComment) {
                aList.add(buffer.toString());
                buffer = new StringBuffer();
            } else {
                buffer.append(c);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            aList.add(buffer.toString());
        }
        return aList.toArray(new String[aList.size()]);
    }

    private void removeAllMarkers(IProject currProject) throws CoreException {
        IWorkspace workspace = currProject.getWorkspace();
        IMarker[] markers = currProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers != null) {
            workspace.deleteMarkers(markers);
        }
    }

    public class MyResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        boolean bContinue;

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource != null && resource.getProject() == MakeBuilder.this.getProject()) {
                this.bContinue = true;
                return false;
            }
            return true;
        }

        public boolean shouldBuild() {
            return this.bContinue;
        }
    }
}

