/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.managedbuilder.ui.properties.BuildToolsSettingsStore;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class BuildOptionListFieldEditor
extends FieldEditor {
    private static final String TITLE = "BuildPropertyCommon.label.title";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String UP = "BuildPropertyCommon.label.up";
    private static final String DOWN = "BuildPropertyCommon.label.down";
    private static final int VERTICAL_DIALOG_UNITS_PER_CHAR = 8;
    private static final int HORIZONTAL_DIALOG_UNITS_PER_CHAR = 4;
    private static final int LIST_HEIGHT_IN_CHARS = 10;
    private static final int LIST_HEIGHT_IN_DLUS = 80;
    private Composite top;
    private List list;
    private Group controlGroup;
    private String fieldName;
    private SelectionListener selectionListener;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;

    public BuildOptionListFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
        this.fieldName = labelText;
    }

    protected void addPressed() {
        this.setPresentsDefaultValue(false);
        String input = this.getNewInputObject();
        if (input != null) {
            int index = this.list.getSelectionIndex();
            if (index >= 0) {
                this.list.add(input, index + 1);
                this.list.setSelection(index + 1);
            } else {
                this.list.add(input, 0);
                this.list.setSelection(0);
            }
            this.selectionChanged();
        }
    }

    protected void adjustForNumColumns(int numColumns) {
        ((GridData)this.top.getLayoutData()).horizontalSpan = numColumns;
    }

    private void createButtons(Composite container) {
        this.addButton = this.createPushButton(container, CUIPlugin.getResourceString((String)NEW));
        this.removeButton = this.createPushButton(container, CUIPlugin.getResourceString((String)REMOVE));
        this.upButton = this.createPushButton(container, CUIPlugin.getResourceString((String)UP));
        this.downButton = this.createPushButton(container, CUIPlugin.getResourceString((String)DOWN));
    }

    protected String createList(String[] items) {
        return BuildToolsSettingsStore.createList(items);
    }

    private Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        data.heightHint = this.convertVerticalDLUsToPixels((Control)button, 14);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.top = parent;
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        this.top.setLayoutData((Object)gd);
        this.controlGroup = ControlFactory.createGroup((Composite)this.top, (String)this.getLabelText(), (int)2);
        GridData groupData = new GridData(768);
        groupData.horizontalSpan = numColumns;
        this.controlGroup.setLayoutData((Object)groupData);
        this.list = new List((Composite)this.controlGroup, 2048);
        GridData listData = new GridData(768);
        listData.heightHint = this.convertVerticalDLUsToPixels((Control)this.list, 80);
        listData.horizontalSpan = 1;
        this.list.setLayoutData((Object)listData);
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildOptionListFieldEditor.this.selectionChanged();
            }
        });
        this.list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BuildOptionListFieldEditor.this.list = null;
            }
        });
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                BuildOptionListFieldEditor.this.editSelection();
            }
        });
        Composite buttonGroup = new Composite((Composite)this.controlGroup, 0);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 1;
        buttonData.verticalAlignment = 1;
        buttonGroup.setLayoutData((Object)buttonData);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonGroup.setLayout((Layout)buttonLayout);
        buttonGroup.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BuildOptionListFieldEditor.this.addButton = null;
                BuildOptionListFieldEditor.this.removeButton = null;
                BuildOptionListFieldEditor.this.upButton = null;
                BuildOptionListFieldEditor.this.downButton = null;
            }
        });
        this.createButtons(buttonGroup);
        this.selectionChanged();
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == BuildOptionListFieldEditor.this.addButton) {
                    BuildOptionListFieldEditor.this.addPressed();
                } else if (widget == BuildOptionListFieldEditor.this.removeButton) {
                    BuildOptionListFieldEditor.this.removePressed();
                } else if (widget == BuildOptionListFieldEditor.this.upButton) {
                    BuildOptionListFieldEditor.this.upPressed();
                } else if (widget == BuildOptionListFieldEditor.this.downButton) {
                    BuildOptionListFieldEditor.this.downPressed();
                } else if (widget == BuildOptionListFieldEditor.this.list) {
                    BuildOptionListFieldEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void downPressed() {
        this.swap(false);
    }

    protected void editSelection() {
        String selItem;
        int index = this.list.getSelectionIndex();
        if (index != -1 && (selItem = this.list.getItem(index)) != null) {
            InputDialog dialog = new InputDialog(this.getShell(), CUIPlugin.getResourceString((String)TITLE), this.fieldName, selItem, null);
            String newItem = null;
            if (dialog.open() == 0 && (newItem = dialog.getValue()) != null && !newItem.equals(selItem)) {
                this.list.setItem(index, newItem);
                this.selectionChanged();
            }
        }
    }

    protected void doLoad() {
        if (this.list != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            String[] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                this.list.add(array[i]);
                ++i;
            }
            this.list.setSelection(0);
        }
    }

    protected void doLoadDefault() {
        if (this.list != null) {
            this.list.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                this.list.add(array[i]);
                ++i;
            }
        }
    }

    protected void doStore() {
        String s = this.createList(this.list.getItems());
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    protected String getNewInputObject() {
        InputDialog dialog = new InputDialog(this.getShell(), CUIPlugin.getResourceString((String)TITLE), this.fieldName, new String(), null);
        String input = null;
        if (dialog.open() == 0) {
            input = dialog.getValue();
        }
        return input.length() == 0 ? null : input;
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    protected String[] parseString(String stringList) {
        return BuildToolsSettingsStore.parseString(stringList);
    }

    protected void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        if (index >= 0) {
            this.list.remove(index);
            this.list.setSelection(index - 1);
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
        int index = this.list.getSelectionIndex();
        int size = this.list.getItemCount();
        this.removeButton.setEnabled(size > 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    private void swap(boolean moveUp) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.list.getSelectionIndex();
        int n = target = moveUp ? index - 1 : index + 1;
        if (index >= 0) {
            String[] selection = this.list.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            this.list.remove(index);
            this.list.add(selection[0], target);
            this.list.setSelection(target);
        }
        this.selectionChanged();
    }

    protected void upPressed() {
        this.swap(true);
    }
}

