/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableObject;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CModificationVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IValue;

public class CExpression
extends CModificationVariable
implements IExpression {
    public CExpression(CDebugTarget target, ICDIExpression cdiExpression) {
        super(target, cdiExpression);
        this.fFormat = CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT);
    }

    public CExpression(CDebugTarget target, ICDIVariableObject cdiVariableObject) {
        super(target, cdiVariableObject);
        this.fFormat = CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_EXPRESSION_FORMAT);
    }

    public String getExpressionText() {
        try {
            return this.getName();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public IValue getValue() {
        try {
            return super.getValue();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected ICDIExpression getCDIExpression() throws CDIException {
        return (ICDIExpression)this.getCDIVariable();
    }

    public void handleDebugEvent(ICDIEvent event) {
        if (event instanceof ICDIResumedEvent && event.getSource() instanceof ICDITarget && this.getCDITarget().equals(event.getSource())) {
            try {
                this.setChanged(false);
            }
            catch (DebugException e) {
                CDebugCorePlugin.log(e);
            }
        }
        super.handleDebugEvent(event);
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean canEnableDisable() {
        return false;
    }
}

