/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.GDBDebugger;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.CygwinCommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIGDBSet;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CygwinGDBDebugger
extends GDBDebugger {
    static final CygwinCommandFactory commandFactory = new CygwinCommandFactory();

    protected void initializeLibraries(ILaunchConfiguration config, Session session) throws CDIException {
        try {
            List p;
            ICDISharedLibraryManager mgr = session.getSharedLibraryManager();
            if (mgr instanceof SharedLibraryManager) {
                boolean stopOnSolibEvents = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
                try {
                    ((SharedLibraryManager)mgr).setStopOnSolibEvents(stopOnSolibEvents);
                }
                catch (CDIException cDIException) {}
            }
            if ((p = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST)).size() > 0) {
                String[] oldPaths = mgr.getSharedLibraryPaths();
                String[] paths = new String[oldPaths.length + p.size()];
                System.arraycopy(p.toArray(new String[p.size()]), 0, paths, 0, p.size());
                System.arraycopy(oldPaths, 0, paths, p.size(), oldPaths.length);
                mgr.setSharedLibraryPaths(paths);
            }
        }
        catch (CoreException e) {
            throw new CDIException("Error initializing shared library options: " + e.getMessage());
        }
    }

    public ICDISession createLaunchSession(ILaunchConfiguration config, IFile exe) throws CDIException {
        Session session = (Session)super.createLaunchSession(config, exe);
        session.getMISession().setCommandFactory(commandFactory);
        MISession mi = session.getMISession();
        try {
            CommandFactory factory = mi.getCommandFactory();
            MIGDBSet set = factory.createMIGDBSet(new String[]{"new-console"});
            mi.postCommand(set);
            MIInfo info = set.getMIInfo();
            if (info == null) {
                throw new MIException("No answer");
            }
        }
        catch (MIException mIException) {}
        return session;
    }

    public ICDISession createAttachSession(ILaunchConfiguration config, IFile exe, int pid) throws CDIException {
        Session session = (Session)super.createAttachSession(config, exe, pid);
        session.getMISession().setCommandFactory(commandFactory);
        return session;
    }

    public ICDISession createCoreSession(ILaunchConfiguration config, IFile exe, IPath corefile) throws CDIException {
        Session session = (Session)super.createCoreSession(config, exe, corefile);
        session.getMISession().setCommandFactory(commandFactory);
        return session;
    }
}

