/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICSignalManager;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIManager;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.core.CUpdateManager;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CSignal;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class CSignalManager
extends CUpdateManager
implements ICSignalManager {
    private ICSignal[] fSignals = null;
    private boolean fIsDisposed = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CSignalManager(CDebugTarget target) {
        super(target);
    }

    public ICSignal[] getSignals() throws DebugException {
        if (!this.isDisposed() && this.fSignals == null) {
            try {
                ICDISignal[] cdiSignals = this.getDebugTarget().getCDISession().getSignalManager().getSignals();
                ArrayList<CSignal> list = new ArrayList<CSignal>(cdiSignals.length);
                int i = 0;
                while (i < cdiSignals.length) {
                    list.add(new CSignal(this.getDebugTarget(), cdiSignals[i]));
                    ++i;
                }
                this.fSignals = list.toArray(new ICSignal[list.size()]);
            }
            catch (CDIException e) {
                this.throwDebugException(e.getMessage(), 5010, e);
            }
        }
        return this.fSignals != null ? this.fSignals : new ICSignal[]{};
    }

    public void dispose() {
        if (this.fSignals != null) {
            int i = 0;
            while (i < this.fSignals.length) {
                this.fSignals[i].dispose();
                ++i;
            }
        }
        this.fSignals = null;
        this.fIsDisposed = true;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.ICSignalManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.internal.core.CSignalManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz2)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public void signalChanged(ICDISignal cdiSignal) {
        CSignal signal = this.find(cdiSignal);
        if (signal != null) {
            signal.fireChangeEvent(256);
        }
    }

    private CSignal find(ICDISignal cdiSignal) {
        try {
            ICSignal[] signals = this.getSignals();
            int i = 0;
            while (i < signals.length) {
                if (signals[i].getName().equals(cdiSignal.getName())) {
                    return (CSignal)signals[i];
                }
                ++i;
            }
        }
        catch (DebugException debugException) {}
        return null;
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    protected ICDIManager getCDIManager() {
        if (this.getDebugTarget() != null) {
            return this.getDebugTarget().getCDISession().getSignalManager();
        }
        return null;
    }

    protected void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), code, message, exception));
    }
}

