/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class RegistersViewPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Button fAutoRefreshField = null;

    public RegistersViewPreferencePage() {
        super(1);
        this.setDescription("Registers View Settings.");
        this.setPreferenceStore(CDebugUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)parent, (String)ICDebugHelpContextIds.REGISTERS_PREFERENCE_PAGE);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new ColorFieldEditor("Changed.Register.RGB", "&Changed register value color:", this.getFieldEditorParent()));
        this.createSpacer(this.getFieldEditorParent(), 2);
        this.fAutoRefreshField = ControlFactory.createCheckBox((Composite)this.getFieldEditorParent(), (String)"Auto-Refresh by default");
        this.fAutoRefreshField.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getBoolean(ICDebugConstants.PREF_REGISTERS_AUTO_REFRESH));
    }

    public void init(IWorkbench workbench) {
    }

    public static void initDefaults(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"Changed.Register.RGB", (RGB)new RGB(255, 0, 0));
        CDebugCorePlugin.getDefault().getPluginPreferences().setDefault(ICDebugConstants.PREF_REGISTERS_AUTO_REFRESH, true);
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        this.storeValues();
        CDebugUIPlugin.getDefault().savePluginPreferences();
        CDebugCorePlugin.getDefault().savePluginPreferences();
        return ok;
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fAutoRefreshField.setSelection(CDebugCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean(ICDebugConstants.PREF_REGISTERS_AUTO_REFRESH));
    }

    private void storeValues() {
        CDebugCorePlugin.getDefault().getPluginPreferences().setValue(ICDebugConstants.PREF_REGISTERS_AUTO_REFRESH, this.fAutoRefreshField.getSelection());
    }
}

