/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.PathCollector;
import org.eclipse.cdt.internal.core.search.PatternSearchJob;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.cdt.internal.core.search.processing.IJob;
import org.eclipse.cdt.internal.core.sourcedependency.DependencyQueryJob;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public class MakefileGenerator {
    private static final String MESSAGE = "ManagedMakeBuilder.message";
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String COMMENT = "ManagedMakeBuilder.comment";
    private static final String MOD_LIST = "ManagedMakeBuilder.comment.module.list";
    private static final String SRC_LISTS = "ManagedMakeBuilder.comment.source.list";
    private static final String MOD_RULES = "ManagedMakeBuilder.comment.build.rule";
    private static final String MOD_INCL = "ManagedMakeBuilder.comment.module.make.includes";
    private static final String DEP_INCL = "ManagedMakeBuilder.comment.module.dep.includes";
    private static final String AUTO_DEP = "ManagedMakeBuilder.comment.autodeps";
    protected static final String COLON = ":";
    protected static final String DEPFILE_NAME = "subdir.dep";
    protected static final String DOT = ".";
    protected static final String MAKEFILE_NAME = "makefile";
    protected static final String MODFILE_NAME = "subdir.mk";
    protected static final String LINEBREAK = "\\";
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static final String LOGICAL_AND = "&&";
    protected static final String SEPARATOR = "/";
    protected static final String TAB = "\t";
    protected static final String WHITESPACE = " ";
    protected static final String WILDCARD = "%";
    protected IManagedBuildInfo info;
    protected List modifiedList;
    protected IProgressMonitor monitor;
    protected List subdirList;
    protected IProject project;
    protected List ruleList;
    protected IPath topBuildDir;
    private String target;
    private String extension;

    public MakefileGenerator(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.project = project;
        this.monitor = monitor;
        this.info = info;
        this.target = info.getBuildArtifactName();
        this.extension = new Path(this.target).getFileExtension();
        if (this.extension == null) {
            this.extension = new String();
        }
    }

    protected StringBuffer addSourceDependencies(IContainer module) throws CoreException {
        IPath moduleRelativePath = module.getProjectRelativePath();
        String relativePath = moduleRelativePath.toString();
        relativePath = String.valueOf(relativePath) + (relativePath.length() == 0 ? "" : SEPARATOR);
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(ManagedBuilderCorePlugin.getResourceString(AUTO_DEP)) + NEWLINE);
        IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
        IResource[] resources = module.members();
        int i = 0;
        while (i < resources.length) {
            block7: {
                String fileName;
                String inputExt;
                IResource resource = resources[i];
                if (resource.getType() == 1 && this.info.buildsFileType(inputExt = resource.getFileExtension()) && (fileName = resource.getFullPath().removeFileExtension().lastSegment()) != null) {
                    String outputExt = this.info.getOutputExtension(inputExt);
                    if (outputExt != null) {
                        fileName = String.valueOf(fileName) + DOT + outputExt;
                    }
                    ArrayList dependencies = new ArrayList();
                    try {
                        indexManager.performConcurrentJob((IJob)new DependencyQueryJob(this.project, (IFile)resource, indexManager, dependencies), 3, null);
                    }
                    catch (Exception exception) {
                        break block7;
                    }
                    if (dependencies.size() != 0) {
                        buffer.append(String.valueOf(relativePath) + fileName + COLON + WHITESPACE);
                        ListIterator iter = ((AbstractList)dependencies).listIterator();
                        while (iter.hasNext()) {
                            buffer.append(LINEBREAK + NEWLINE);
                            String path = (String)iter.next();
                            buffer.append(String.valueOf(path) + WHITESPACE);
                        }
                        buffer.append(NEWLINE);
                    }
                }
            }
            ++i;
        }
        return buffer;
    }

    protected StringBuffer addMacros() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ROOT := .." + NEWLINE);
        buffer.append("RM := ");
        buffer.append(String.valueOf(this.info.getCleanCommand()) + NEWLINE + NEWLINE);
        buffer.append(String.valueOf(ManagedBuilderCorePlugin.getResourceString(SRC_LISTS)) + NEWLINE);
        buffer.append("C_SRCS := " + NEWLINE);
        buffer.append("CC_SRCS := " + NEWLINE);
        buffer.append("CXX_SRCS := " + NEWLINE);
        buffer.append("CAPC_SRCS := " + NEWLINE);
        buffer.append("CPP_SRCS := " + NEWLINE + NEWLINE);
        buffer.append("LIBS := ");
        String[] libs = this.info.getLibsForTarget(this.extension);
        int i = 0;
        while (i < libs.length) {
            String string = libs[i];
            buffer.append(LINEBREAK + NEWLINE + string);
            ++i;
        }
        buffer.append(String.valueOf(NEWLINE) + NEWLINE);
        buffer.append("USER_OBJS := ");
        String[] userObjs = this.info.getUserObjectsForTarget(this.extension);
        int j = 0;
        while (j < userObjs.length) {
            String string = userObjs[j];
            buffer.append(LINEBREAK + NEWLINE + string);
            ++j;
        }
        buffer.append(String.valueOf(NEWLINE) + NEWLINE);
        buffer.append("OBJS = $(C_SRCS:$(ROOT)/%.c=%.o) $(CC_SRCS:$(ROOT)/%.cc=%.o) $(CXX_SRCS:$(ROOT)/%.cxx=%.o) $(CAPC_SRCS:$(ROOT)/%.C=%.o) $(CPP_SRCS:$(ROOT)/%.cpp=%.o)" + NEWLINE);
        return buffer.append(NEWLINE);
    }

    protected StringBuffer addSubdirectories() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(String.valueOf(ManagedBuilderCorePlugin.getResourceString(MOD_LIST)) + NEWLINE);
        buffer.append("SUBDIRS := \\" + NEWLINE);
        ListIterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer container = (IContainer)iter.next();
            if (container.getFullPath() == this.project.getFullPath()) {
                buffer.append(". \\" + NEWLINE);
                continue;
            }
            IPath path = container.getProjectRelativePath();
            buffer.append(String.valueOf(path.toString()) + WHITESPACE + LINEBREAK + NEWLINE);
        }
        buffer.append(NEWLINE);
        buffer.append(String.valueOf(ManagedBuilderCorePlugin.getResourceString(MOD_INCL)) + NEWLINE);
        buffer.append("-include ${patsubst %, %/subdir.mk, $(SUBDIRS)}" + NEWLINE);
        buffer.append(String.valueOf(NEWLINE) + NEWLINE);
        return buffer;
    }

    protected StringBuffer addSources(IContainer module) throws CoreException {
        IPath moduleRelativePath = module.getProjectRelativePath();
        String relativePath = moduleRelativePath.toString();
        relativePath = String.valueOf(relativePath) + (relativePath.length() == 0 ? "" : SEPARATOR);
        StringBuffer buffer = new StringBuffer();
        StringBuffer cBuffer = new StringBuffer("C_SRCS += \\" + NEWLINE);
        cBuffer.append("${addprefix $(ROOT)/" + relativePath + "," + LINEBREAK + NEWLINE);
        StringBuffer ccBuffer = new StringBuffer("CC_SRCS += \\" + NEWLINE);
        ccBuffer.append("${addprefix $(ROOT)/" + relativePath + "," + LINEBREAK + NEWLINE);
        StringBuffer cxxBuffer = new StringBuffer("CXX_SRCS += \\" + NEWLINE);
        cxxBuffer.append("${addprefix $(ROOT)/" + relativePath + "," + LINEBREAK + NEWLINE);
        StringBuffer capcBuffer = new StringBuffer("CAPC_SRCS += \\" + NEWLINE);
        capcBuffer.append("${addprefix $(ROOT)/" + relativePath + "," + LINEBREAK + NEWLINE);
        StringBuffer cppBuffer = new StringBuffer("CPP_SRCS += \\" + NEWLINE);
        cppBuffer.append("${addprefix $(ROOT)/" + relativePath + "," + LINEBREAK + NEWLINE);
        StringBuffer ruleBuffer = new StringBuffer(String.valueOf(ManagedBuilderCorePlugin.getResourceString(MOD_RULES)) + NEWLINE);
        buffer.append(String.valueOf(ManagedBuilderCorePlugin.getResourceString(SRC_LISTS)) + NEWLINE);
        IResource[] resources = module.members();
        int i = 0;
        while (i < resources.length) {
            String ext;
            IResource resource = resources[i];
            if (resource.getType() == 1 && this.info.buildsFileType(ext = resource.getFileExtension())) {
                if (new String("c").equals(ext)) {
                    cBuffer.append(String.valueOf(resource.getName()) + WHITESPACE + LINEBREAK + NEWLINE);
                } else if (new String("cc").equalsIgnoreCase(ext)) {
                    ccBuffer.append(String.valueOf(resource.getName()) + WHITESPACE + LINEBREAK + NEWLINE);
                } else if (new String("cxx").equalsIgnoreCase(ext)) {
                    cxxBuffer.append(String.valueOf(resource.getName()) + WHITESPACE + LINEBREAK + NEWLINE);
                } else if (new String("C").equals(ext)) {
                    capcBuffer.append(String.valueOf(resource.getName()) + WHITESPACE + LINEBREAK + NEWLINE);
                } else {
                    cppBuffer.append(String.valueOf(resource.getName()) + WHITESPACE + LINEBREAK + NEWLINE);
                }
                this.addRule(relativePath, ruleBuffer, resource);
            }
            ++i;
        }
        buffer.append((Object)cBuffer.append("}" + NEWLINE + NEWLINE));
        buffer.append((Object)ccBuffer.append("}" + NEWLINE + NEWLINE));
        buffer.append((Object)cxxBuffer.append("}" + NEWLINE + NEWLINE));
        buffer.append((Object)capcBuffer.append("}" + NEWLINE + NEWLINE));
        buffer.append((Object)cppBuffer.append("}" + NEWLINE + NEWLINE));
        return buffer.append(ruleBuffer + NEWLINE);
    }

    protected StringBuffer addTargets(boolean rebuild) {
        StringBuffer buffer = new StringBuffer();
        String cmd = this.info.getToolForTarget(this.extension);
        String flags = this.info.getFlagsForTarget(this.extension);
        String outflag = this.info.getOutputFlag(this.extension);
        String outputPrefix = this.info.getOutputPrefix(this.extension);
        String targets = rebuild ? "clean all" : "all";
        IProject[] deps = null;
        try {
            deps = this.project.getReferencedProjects();
        }
        catch (CoreException coreException) {}
        String defaultTarget = "all:";
        if (deps.length > 0) {
            defaultTarget = String.valueOf(defaultTarget) + " deps";
        }
        buffer.append(String.valueOf(defaultTarget) + WHITESPACE + outputPrefix + this.target + NEWLINE);
        buffer.append(NEWLINE);
        ArrayList<String> managedProjectOutputs = new ArrayList<String>();
        if (deps.length > 0) {
            buffer.append("deps:" + NEWLINE);
            if (deps != null) {
                int i = 0;
                while (i < deps.length) {
                    IProject dep = deps[i];
                    String buildDir = dep.getLocation().toString();
                    String depTargets = targets;
                    if (ManagedBuildManager.manages((IResource)dep)) {
                        IManagedBuildInfo depInfo = ManagedBuildManager.getBuildInfo((IResource)dep);
                        buildDir = String.valueOf(buildDir) + SEPARATOR + depInfo.getConfigurationName();
                        String depTarget = depInfo.getBuildArtifactName();
                        String depExt = new Path(depTarget).getFileExtension();
                        String depPrefix = depInfo.getOutputPrefix(depExt);
                        if (depInfo.isDirty()) {
                            depTargets = "clean all";
                        }
                        managedProjectOutputs.add(String.valueOf(buildDir) + SEPARATOR + depPrefix + depTarget);
                    }
                    buffer.append("\t-cd " + buildDir + WHITESPACE + LOGICAL_AND + WHITESPACE + "$(MAKE) " + depTargets + NEWLINE);
                    ++i;
                }
            }
            buffer.append(NEWLINE);
        }
        buffer.append(String.valueOf(outputPrefix) + this.target + COLON + WHITESPACE + "$(OBJS)");
        ListIterator iter = managedProjectOutputs.listIterator();
        while (iter.hasNext()) {
            buffer.append(WHITESPACE + (String)iter.next());
        }
        buffer.append(NEWLINE);
        buffer.append(TAB + cmd + WHITESPACE + flags + WHITESPACE + outflag + WHITESPACE + "$@" + WHITESPACE + "$(OBJS) $(USER_OBJS) $(LIBS)");
        buffer.append(String.valueOf(NEWLINE) + NEWLINE);
        buffer.append("clean:" + NEWLINE);
        buffer.append("\t-$(RM) $(OBJS) " + outputPrefix + this.target + NEWLINE + NEWLINE);
        buffer.append(".PHONY: all clean deps" + NEWLINE + NEWLINE);
        buffer.append(String.valueOf(ManagedBuilderCorePlugin.getResourceString(DEP_INCL)) + NEWLINE);
        buffer.append("-include ${patsubst %, %/subdir.dep, $(SUBDIRS)}" + NEWLINE);
        return buffer;
    }

    protected void addRule(String relativePath, StringBuffer buffer, IResource resource) {
        String rule = null;
        String cmd = null;
        String buildFlags = null;
        String inputExtension = null;
        String outputExtension = null;
        String outflag = null;
        String outputPrefix = null;
        inputExtension = resource.getFileExtension();
        outputExtension = this.info.getOutputExtension(inputExtension);
        rule = String.valueOf(relativePath) + WILDCARD + DOT + outputExtension + COLON + WHITESPACE + "$(ROOT)" + SEPARATOR + relativePath + WILDCARD + DOT + inputExtension;
        if (!this.getRuleList().contains(rule)) {
            this.getRuleList().add(rule);
            buffer.append(String.valueOf(rule) + NEWLINE);
            cmd = this.info.getToolForSource(inputExtension);
            buildFlags = this.info.getFlagsForSource(inputExtension);
            outflag = this.info.getOutputFlag(outputExtension);
            outputPrefix = this.info.getOutputPrefix(outputExtension);
            buffer.append(TAB + cmd + WHITESPACE + buildFlags + WHITESPACE + outflag + WHITESPACE + outputPrefix + "$@" + WHITESPACE + "$<" + NEWLINE + NEWLINE);
        }
    }

    public void appendBuildSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (!this.getSubdirList().contains(container)) {
            this.getSubdirList().add(container);
        }
    }

    public void appendModifiedSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (!this.getModifiedList().contains(container)) {
            this.getModifiedList().add(container);
        }
    }

    public void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void generateMakefiles(IResourceDelta delta) throws CoreException {
        IFolder folder = this.project.getFolder(this.info.getConfigurationName());
        if (!folder.exists()) {
            this.regenerateMakefiles();
            return;
        }
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this, this.info);
        delta.accept((IResourceDeltaVisitor)visitor);
        this.checkCancel();
        ResourceProxyVisitor resourceVisitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)resourceVisitor, 0);
        this.checkCancel();
        ListIterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            IContainer subdirectory = (IContainer)iter.next();
            if (this.getModifiedList().contains(subdirectory)) continue;
            IFile makeFragment = this.project.getFile(subdirectory.getFullPath().addTrailingSeparator().append(MODFILE_NAME));
            IFile depFragment = this.project.getFile(subdirectory.getFullPath().addTrailingSeparator().append(DEPFILE_NAME));
            if (makeFragment.exists() && depFragment.exists()) continue;
            this.getModifiedList().add(subdirectory);
        }
        this.topBuildDir = this.createDirectory(this.info.getConfigurationName());
        IPath makefilePath = this.topBuildDir.addTrailingSeparator().append(MAKEFILE_NAME);
        IFile makefileHandle = this.createFile(makefilePath);
        this.populateTopMakefile(makefileHandle, false);
        this.checkCancel();
        iter = this.getModifiedList().listIterator();
        while (iter.hasNext()) {
            this.populateFragmentMakefile((IContainer)iter.next());
            this.checkCancel();
        }
    }

    private List getModifiedList() {
        if (this.modifiedList == null) {
            this.modifiedList = new ArrayList();
        }
        return this.modifiedList;
    }

    private List getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new ArrayList();
        }
        return this.ruleList;
    }

    private List getSubdirList() {
        if (this.subdirList == null) {
            this.subdirList = new ArrayList();
        }
        return this.subdirList;
    }

    private IPath createDirectory(String dirName) throws CoreException {
        IFolder folder = this.project.getFolder(dirName);
        if (!folder.exists()) {
            IFolder parent;
            IPath parentPath = new Path(dirName).removeLastSegments(1);
            if (!parentPath.isEmpty() && !(parent = this.project.getFolder(parentPath)).exists()) {
                this.createDirectory(parentPath.toString());
            }
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 374) {
                    folder.refreshLocal(0, null);
                }
                throw e;
            }
        }
        return folder.getFullPath();
    }

    private IFile createFile(IPath makefilePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(makefilePath);
        if (newFile == null) {
            newFile = root.getFile(makefilePath);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, this.monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    public IPath getTopBuildDir() {
        return this.topBuildDir;
    }

    public boolean isGeneratedResource(IResource resource) {
        IPath path = resource.getProjectRelativePath();
        String[] configNames = this.info.getConfigurationNames();
        int i = 0;
        while (i < configNames.length) {
            String name = configNames[i];
            Path root = new Path(name);
            if (root.isPrefixOf(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void populateTopMakefile(IFile fileHandle, boolean rebuild) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        buffer.append((Object)this.addMacros());
        buffer.append((Object)this.addSubdirectories());
        buffer.append((Object)this.addTargets(rebuild));
        Util.save((StringBuffer)buffer, (IFile)fileHandle);
    }

    protected void populateFragmentMakefile(IContainer module) throws CoreException {
        IPath moduleRelativePath = module.getProjectRelativePath();
        IPath buildRoot = this.getTopBuildDir().removeFirstSegments(1);
        if (buildRoot == null) {
            return;
        }
        IPath moduleOutputPath = buildRoot.append(moduleRelativePath);
        IPath moduleOutputDir = this.createDirectory(moduleOutputPath.toString());
        IFile modMakefile = this.createFile(moduleOutputDir.addTrailingSeparator().append(MODFILE_NAME));
        StringBuffer makeBuf = new StringBuffer();
        makeBuf.append((Object)this.addSources(module));
        IFile modDepfile = this.createFile(moduleOutputDir.addTrailingSeparator().append(DEPFILE_NAME));
        StringBuffer depBuf = new StringBuffer();
        depBuf.append((Object)this.addSourceDependencies(module));
        Util.save((StringBuffer)makeBuf, (IFile)modMakefile);
        Util.save((StringBuffer)depBuf, (IFile)modDepfile);
    }

    public void regenerateMakefiles() throws CoreException {
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(this, this.info);
        this.project.accept((IResourceProxyVisitor)visitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            return;
        }
        this.topBuildDir = this.createDirectory(this.info.getConfigurationName());
        IPath makefilePath = this.topBuildDir.addTrailingSeparator().append(MAKEFILE_NAME);
        IFile makefileHandle = this.createFile(makefilePath);
        this.populateTopMakefile(makefileHandle, true);
        this.checkCancel();
        ListIterator iter = this.getSubdirList().listIterator();
        while (iter.hasNext()) {
            this.populateFragmentMakefile((IContainer)iter.next());
            this.checkCancel();
        }
    }

    protected class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private MakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceProxyVisitor(MakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.info = info;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            if (proxy.getType() == 1) {
                IResource resource = proxy.requestResource();
                String ext = resource.getFileExtension();
                if (this.info.buildsFileType(ext) && !this.generator.isGeneratedResource(resource)) {
                    this.generator.appendBuildSubdirectory(resource);
                }
                return false;
            }
            return true;
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private MakefileGenerator generator;
        private IManagedBuildInfo info;

        public ResourceDeltaVisitor(MakefileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.info = info;
        }

        private IResource[] findDependencies(IResource resource) {
            PathCollector pathCollector = new PathCollector();
            ICSearchScope scope = SearchEngine.createWorkspaceScope();
            CSearchPattern pattern = CSearchPattern.createPattern((String)resource.getLocation().toOSString(), (ICSearchConstants.SearchFor)ICSearchConstants.INCLUDE, (ICSearchConstants.LimitTo)ICSearchConstants.REFERENCES, (int)0, (boolean)true);
            IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
            indexManager.performConcurrentJob((IJob)new PatternSearchJob(pattern, scope, (IIndexSearchRequestor)pathCollector, indexManager), 3, null);
            String[] deps = pathCollector.getPaths();
            ArrayList<IResource> depList = new ArrayList<IResource>();
            IResource res = null;
            IWorkspaceRoot root = null;
            if (this.generator.project != null) {
                root = this.generator.project.getWorkspace().getRoot();
            }
            int index = 0;
            while (index < deps.length) {
                res = root.findMember(deps[index]);
                if (res != null) {
                    depList.add(res);
                }
                ++index;
            }
            return depList.toArray(new IResource[depList.size()]);
        }

        private void handleHeaderDependency(IResource resource, boolean moved) {
            if (resource.getProject().equals((Object)this.generator.project)) {
                this.generator.appendModifiedSubdirectory(resource);
            } else if (moved) {
                try {
                    resource.touch((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean keepLooking = false;
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                String ext = resource.getFileExtension();
                boolean moved = false;
                switch (delta.getKind()) {
                    case 1: {
                        boolean bl = moved = delta.getFlags() == 8192;
                        if (this.generator.isGeneratedResource(resource)) break;
                        if (this.info.buildsFileType(ext)) {
                            this.generator.appendModifiedSubdirectory(resource);
                            break;
                        }
                        if (!this.info.isHeaderFile(ext)) break;
                        this.generator.appendModifiedSubdirectory(resource);
                        IResource[] deps = this.findDependencies(resource);
                        int i = 0;
                        while (i < deps.length) {
                            this.handleHeaderDependency(deps[i], moved);
                            ++i;
                        }
                        break;
                    }
                    case 2: {
                        boolean bl = moved = delta.getFlags() == 4096;
                        if (this.generator.isGeneratedResource(resource)) break;
                        if (this.info.buildsFileType(ext)) {
                            this.generator.appendModifiedSubdirectory(resource);
                            break;
                        }
                        if (!this.info.isHeaderFile(ext)) break;
                        this.generator.appendModifiedSubdirectory(resource);
                        IResource[] deps = this.findDependencies(resource);
                        int i = 0;
                        while (i < deps.length) {
                            this.handleHeaderDependency(deps[i], moved);
                            ++i;
                        }
                        break;
                    }
                    case 4: {
                        if (this.generator.isGeneratedResource(resource)) break;
                        if (this.info.buildsFileType(ext)) {
                            keepLooking = true;
                            break;
                        }
                        if (!this.info.isHeaderFile(ext)) break;
                        this.generator.appendModifiedSubdirectory(resource);
                        IResource[] deps = this.findDependencies(resource);
                        int i = 0;
                        while (i < deps.length) {
                            this.handleHeaderDependency(deps[i], moved);
                            ++i;
                        }
                        break;
                    }
                    default: {
                        keepLooking = true;
                    }
                }
            }
            if (resource.getType() == 4) {
                IResourceDelta[] children = delta.getAffectedChildren();
                if (children != null && children.length > 0) {
                    keepLooking = true;
                }
            } else if (!this.generator.isGeneratedResource(resource)) {
                keepLooking = true;
            }
            return keepLooking;
        }
    }
}

