/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.ui.dialogs;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeScannerInfo;
import org.eclipse.cdt.make.core.MakeScannerProvider;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuildPathInfoBlock
extends AbstractCOptionPage {
    private static final String PREF_SYMBOLS = "ScannerSymbols";
    private static final String PREF_INCLUDES = "ScannerIncludes";
    private static final String PREFIX = "BuildPathInfoBlock";
    private static final String LABEL = "BuildPathInfoBlock.label";
    private static final String PATHS = "BuildPathInfoBlock.paths";
    private static final String SYMBOLS = "BuildPathInfoBlock.symbols";
    private static final String BROWSE = "BuildPathInfoBlock.browse";
    private static final String PATH_TITLE = "BuildPathInfoBlock.browse.path";
    private static final String PATH_LABEL = "BuildPathInfoBlock.browse.path.label";
    private static final String SYMBOL_TITLE = "BuildPathInfoBlock.browse.symbol";
    private static final String SYMBOL_LABEL = "BuildPathInfoBlock.browse.symbol.label";
    private static final String NEW = "BuildPropertyCommon.label.new";
    private static final String REMOVE = "BuildPropertyCommon.label.remove";
    private static final String UP = "BuildPropertyCommon.label.up";
    private static final String DOWN = "BuildPropertyCommon.label.down";
    private List pathList;
    private List symbolList;
    private Composite pathButtonComp;
    private Button addPath;
    private Button removePath;
    private Button pathUp;
    private Button pathDown;
    private Composite symbolButtonComp;
    private Button addSymbol;
    private Button removeSymbol;
    private Button symbolUp;
    private Button symbolDown;
    private Shell shell;

    public BuildPathInfoBlock() {
        super(CUIPlugin.getResourceString((String)LABEL));
        this.setDescription("Set the include paths and preprocessor symbols for this project");
    }

    private void createPathListButtons(Composite parent) {
        this.pathButtonComp = ControlFactory.createComposite((Composite)parent, (int)1);
        this.pathButtonComp.setFont(parent.getFont());
        this.addPath = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)CUIPlugin.getResourceString((String)NEW));
        this.addPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handleAddPath();
            }
        });
        this.addPath.setEnabled(true);
        this.addPath.setFont(parent.getFont());
        this.addPath.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.addPath);
        this.removePath = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)CUIPlugin.getResourceString((String)REMOVE));
        this.removePath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handleRemovePath();
            }
        });
        this.removePath.setFont(parent.getFont());
        this.removePath.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.removePath);
        this.pathUp = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)CUIPlugin.getResourceString((String)UP));
        this.pathUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handlePathUp();
            }
        });
        this.pathUp.setFont(parent.getFont());
        this.pathUp.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.pathUp);
        this.pathDown = ControlFactory.createPushButton((Composite)this.pathButtonComp, (String)CUIPlugin.getResourceString((String)DOWN));
        this.pathDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handlePathDown();
            }
        });
        this.pathDown.setFont(parent.getFont());
        this.pathDown.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.pathDown);
    }

    private void createPathListControl(Composite parent, int numColumns) {
        this.pathList = new List(parent, 2820);
        this.pathList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.enablePathButtons();
            }
        });
        this.pathList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                BuildPathInfoBlock.this.editPathListItem();
            }
        });
        GridData gd = new GridData(1808);
        gd.horizontalSpan = numColumns - 1;
        this.pathList.setLayoutData((Object)gd);
        this.pathList.setFont(parent.getFont());
    }

    private void createSymbolListButtons(Composite parent) {
        this.symbolButtonComp = ControlFactory.createComposite((Composite)parent, (int)1);
        this.symbolButtonComp.setFont(parent.getFont());
        this.addSymbol = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)CUIPlugin.getResourceString((String)NEW));
        this.addSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handleAddSymbol();
            }
        });
        this.addSymbol.setEnabled(true);
        this.addSymbol.setFont(parent.getFont());
        this.addSymbol.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.addSymbol);
        this.removeSymbol = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)CUIPlugin.getResourceString((String)REMOVE));
        this.removeSymbol.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handleRemoveSymbol();
            }
        });
        this.removeSymbol.setFont(parent.getFont());
        this.removeSymbol.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.removeSymbol);
        this.symbolUp = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)CUIPlugin.getResourceString((String)UP));
        this.symbolUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handleSymbolUp();
            }
        });
        this.symbolUp.setFont(parent.getFont());
        this.symbolUp.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.symbolUp);
        this.symbolDown = ControlFactory.createPushButton((Composite)this.symbolButtonComp, (String)CUIPlugin.getResourceString((String)DOWN));
        this.symbolDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.handleSymbolDown();
            }
        });
        this.symbolDown.setFont(parent.getFont());
        this.symbolDown.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.symbolDown);
    }

    private void createSymbolListControl(Composite parent, int numColumns) {
        this.symbolList = new List(parent, 2820);
        this.symbolList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathInfoBlock.this.enableSymbolButtons();
            }
        });
        this.symbolList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                BuildPathInfoBlock.this.editSymbolListItem();
            }
        });
        GridData gd = new GridData(1808);
        gd.horizontalSpan = numColumns - 1;
        this.symbolList.setLayoutData((Object)gd);
        this.symbolList.setFont(parent.getFont());
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.getContainer().getProject() != null) {
            monitor.beginTask("Setting Scanner Info", 3);
            MakeScannerInfo info = MakeScannerProvider.getDefault().getMakeScannerInfo(this.getContainer().getProject(), false);
            info.setIncludePaths(this.getPathListContents());
            monitor.worked(1);
            info.setPreprocessorSymbols(this.getSymbolListContents());
            monitor.worked(1);
            info.update();
            monitor.done();
        } else {
            this.setIncludes(MakeCorePlugin.getDefault().getPluginPreferences());
            this.setSymbols(MakeCorePlugin.getDefault().getPluginPreferences());
        }
    }

    public void performDefaults() {
        this.pathList.removeAll();
        this.symbolList.removeAll();
        if (this.getContainer().getProject() != null) {
            this.pathList.setItems(this.getIncludes(MakeCorePlugin.getDefault().getPluginPreferences()));
            this.symbolList.setItems(this.getSymbols(MakeCorePlugin.getDefault().getPluginPreferences()));
        }
        this.getContainer().updateContainer();
    }

    private void setSymbols(Preferences prefs) {
        prefs.setValue(PREF_SYMBOLS, this.stringArrayToString(this.getSymbolListContents()));
    }

    private void setIncludes(Preferences prefs) {
        prefs.setValue(PREF_INCLUDES, this.stringArrayToString(this.getPathListContents()));
    }

    private String stringArrayToString(String[] strings) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            buf.append(strings[i]).append(';');
            ++i;
        }
        return buf.toString();
    }

    private String[] getSymbols(Preferences prefs) {
        String syms = prefs.getString(PREF_SYMBOLS);
        return this.parseStringToList(syms);
    }

    private String[] getIncludes(Preferences prefs) {
        String syms = prefs.getString(PREF_INCLUDES);
        return this.parseStringToList(syms);
    }

    private String[] parseStringToList(String syms) {
        if (syms != null && syms.length() > 0) {
            StringTokenizer tok = new StringTokenizer(syms, ";");
            ArrayList<String> list = new ArrayList<String>(tok.countTokens());
            while (tok.hasMoreElements()) {
                list.add(tok.nextToken());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[0];
    }

    protected void editPathListItem() {
        String selItem;
        int index = this.pathList.getSelectionIndex();
        if (index != -1 && (selItem = this.pathList.getItem(index)) != null) {
            InputDialog dialog = new InputDialog(this.shell, CUIPlugin.getResourceString((String)PATH_TITLE), CUIPlugin.getResourceString((String)PATH_LABEL), selItem, null);
            String newItem = null;
            if (dialog.open() == 0 && (newItem = dialog.getValue()) != null && !newItem.equals(selItem)) {
                this.pathList.setItem(index, newItem);
            }
        }
    }

    protected void editSymbolListItem() {
        String selItem;
        int index = this.symbolList.getSelectionIndex();
        if (index != -1 && (selItem = this.symbolList.getItem(index)) != null) {
            InputDialog dialog = new InputDialog(this.shell, CUIPlugin.getResourceString((String)SYMBOL_TITLE), CUIPlugin.getResourceString((String)SYMBOL_LABEL), selItem, null);
            String newItem = null;
            if (dialog.open() == 0 && (newItem = dialog.getValue()) != null && !newItem.equals(selItem)) {
                this.symbolList.setItem(index, newItem);
            }
        }
    }

    void enablePathButtons() {
        int items = this.pathList.getItemCount();
        if (items > 0) {
            this.removePath.setEnabled(true);
            int index = this.pathList.getSelectionIndex();
            this.pathUp.setEnabled(items > 1 && index > 0);
            this.pathDown.setEnabled(items > 1 && index < items - 1);
        } else {
            this.removePath.setEnabled(false);
            this.pathUp.setEnabled(false);
            this.pathDown.setEnabled(false);
        }
    }

    void enableSymbolButtons() {
        int items = this.symbolList.getItemCount();
        if (items > 0) {
            this.removeSymbol.setEnabled(true);
            int index = this.symbolList.getSelectionIndex();
            this.symbolUp.setEnabled(items > 1 && index > 0);
            this.symbolDown.setEnabled(items > 1 && index < items - 1);
        } else {
            this.removeSymbol.setEnabled(false);
            this.symbolUp.setEnabled(false);
            this.symbolDown.setEnabled(false);
        }
    }

    public void createControl(Composite parent) {
        int tabColumns = 3;
        Font font = parent.getFont();
        Composite composite = ControlFactory.createComposite((Composite)parent, (int)tabColumns);
        composite.setFont(font);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IMakeHelpContextIds.MAKE_PATH_SYMBOL_SETTINGS);
        Label paths = ControlFactory.createLabel((Composite)composite, (String)CUIPlugin.getResourceString((String)PATHS));
        GridData gd = new GridData(768);
        gd.horizontalSpan = tabColumns;
        paths.setLayoutData((Object)gd);
        paths.setFont(font);
        this.createPathListControl(composite, tabColumns);
        this.createPathListButtons(composite);
        this.enablePathButtons();
        Label symbols = ControlFactory.createLabel((Composite)composite, (String)CUIPlugin.getResourceString((String)SYMBOLS));
        gd = new GridData(768);
        gd.horizontalSpan = tabColumns;
        symbols.setLayoutData((Object)gd);
        symbols.setFont(font);
        this.createSymbolListControl(composite, tabColumns);
        this.createSymbolListButtons(composite);
        this.enableSymbolButtons();
        this.setListContents();
        this.pathList.select(0);
        this.enablePathButtons();
        this.symbolList.select(0);
        this.enableSymbolButtons();
    }

    private String[] getPathListContents() {
        return this.pathList.getItems();
    }

    private String[] getSymbolListContents() {
        return this.symbolList.getItems();
    }

    protected void handleAddPath() {
        InputDialog dialog = new InputDialog(this.shell, CUIPlugin.getResourceString((String)PATH_TITLE), CUIPlugin.getResourceString((String)PATH_LABEL), "", null);
        String path = null;
        if (dialog.open() == 0) {
            path = dialog.getValue();
        }
        if (path != null && path.length() > 0) {
            this.pathList.add(path);
            this.pathList.select(this.pathList.getItemCount() - 1);
            this.enablePathButtons();
        }
    }

    protected void handleAddSymbol() {
        InputDialog dialog = new InputDialog(this.shell, CUIPlugin.getResourceString((String)SYMBOL_TITLE), CUIPlugin.getResourceString((String)SYMBOL_LABEL), "", null);
        String symbol = null;
        if (dialog.open() == 0) {
            symbol = dialog.getValue();
        }
        if (symbol != null && symbol.length() > 0) {
            this.symbolList.add(symbol);
            this.symbolList.select(this.symbolList.getItemCount() - 1);
            this.enableSymbolButtons();
        }
    }

    protected void handlePathDown() {
        int index = this.pathList.getSelectionIndex();
        int items = this.pathList.getItemCount();
        if (index == -1 || index == items - 1) {
            return;
        }
        String selItem = this.pathList.getItem(index);
        this.pathList.remove(index);
        if (index + 1 == items) {
            this.pathList.add(selItem);
        } else {
            this.pathList.add(selItem, ++index);
        }
        this.pathList.select(index);
        this.enablePathButtons();
    }

    protected void handlePathUp() {
        int index = this.pathList.getSelectionIndex();
        if (index == -1 || index == 0) {
            return;
        }
        String selItem = this.pathList.getItem(index);
        this.pathList.remove(index);
        this.pathList.add(selItem, --index);
        this.pathList.select(index);
        this.enablePathButtons();
    }

    protected void handleRemovePath() {
        int index = this.pathList.getSelectionIndex();
        if (index == -1) {
            return;
        }
        this.pathList.remove(index);
        index = index - 1 < 0 ? 0 : index - 1;
        this.pathList.select(index);
        this.enablePathButtons();
    }

    protected void handleRemoveSymbol() {
        int index = this.symbolList.getSelectionIndex();
        if (index == -1) {
            return;
        }
        this.symbolList.remove(index);
        index = index - 1 < 0 ? 0 : index - 1;
        this.symbolList.select(index);
        this.enableSymbolButtons();
    }

    protected void handleSymbolDown() {
        int index = this.symbolList.getSelectionIndex();
        int items = this.symbolList.getItemCount();
        if (index == -1 || index == items - 1) {
            return;
        }
        String selItem = this.symbolList.getItem(index);
        this.symbolList.remove(index);
        if (index + 1 == items) {
            this.symbolList.add(selItem);
        } else {
            this.symbolList.add(selItem, ++index);
        }
        this.symbolList.select(index);
        this.enableSymbolButtons();
    }

    protected void handleSymbolUp() {
        int index = this.symbolList.getSelectionIndex();
        if (index == -1 || index == 0) {
            return;
        }
        String selItem = this.symbolList.getItem(index);
        this.symbolList.remove(index);
        this.symbolList.add(selItem, --index);
        this.symbolList.select(index);
        this.enableSymbolButtons();
    }

    public boolean isValid() {
        return true;
    }

    private void setListContents() {
        if (this.getContainer().getProject() != null) {
            try {
                MakeScannerInfo info = MakeScannerProvider.getDefault().getMakeScannerInfo(this.getContainer().getProject(), false);
                this.pathList.setItems(info.getIncludePaths());
                this.symbolList.setItems(info.getPreprocessorSymbols());
            }
            catch (CoreException coreException) {}
        } else {
            this.pathList.setItems(this.getIncludes(MakeCorePlugin.getDefault().getPluginPreferences()));
            this.symbolList.setItems(this.getSymbols(MakeCorePlugin.getDefault().getPluginPreferences()));
        }
    }
}

