/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.makefile.IMakefile;
import org.eclipse.cdt.make.internal.core.BuildInfoFactory;
import org.eclipse.cdt.make.internal.core.MakeTargetManager;
import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class MakeCorePlugin
extends Plugin {
    public static final String MAKE_PROJECT_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".make";
    private MakeTargetManager fTargetManager;
    public static final String OLD_BUILDER_ID = "org.eclipse.cdt.core.cbuilder";
    private static MakeCorePlugin plugin;
    private ResourceBundle resourceBundle;

    public MakeCorePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.cdt.make.core.PluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public static MakeCorePlugin getDefault() {
        return plugin;
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, MakeCorePlugin.getUniqueIdentifier(), 0, e.getMessage(), e);
        MakeCorePlugin.log(status);
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MakeCorePlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String getFormattedString(String key, String arg) {
        return MessageFormat.format(MakeCorePlugin.getResourceString(key), arg);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getUniqueIdentifier() {
        if (MakeCorePlugin.getDefault() == null) {
            return "org.eclipse.cdt.make.core";
        }
        return MakeCorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    protected void initializeDefaultPluginPreferences() {
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(this.getPluginPreferences(), MakeBuilder.BUILDER_ID, true);
        try {
            info.setBuildCommand((IPath)new Path("make"));
            info.setBuildLocation((IPath)new Path(""));
            info.setStopOnError(false);
            info.setUseDefaultBuildCmd(true);
            info.setAutoBuildEnable(false);
            info.setAutoBuildTarget("all");
            info.setIncrementalBuildEnable(true);
            info.setIncrementalBuildTarget("all");
            info.setFullBuildEnable(true);
            info.setFullBuildTarget("clean all");
            info.setErrorParsers(CCorePlugin.getDefault().getAllErrorParsersIDs());
        }
        catch (CoreException coreException) {}
        this.getPluginPreferences().setDefault("binaryparser", "org.eclipse.cdt.core.ELF");
    }

    public static IMakeBuilderInfo createBuildInfo(Preferences prefs, String builderID, boolean useDefaults) {
        return BuildInfoFactory.create(prefs, builderID, useDefaults);
    }

    public static IMakeBuilderInfo createBuildInfo(IProject project, String builderID) throws CoreException {
        return BuildInfoFactory.create(project, builderID);
    }

    public static IMakeBuilderInfo createBuildInfo(Map args, String builderID) {
        return BuildInfoFactory.create(args, builderID);
    }

    public IMakeTargetManager getTargetManager() {
        if (this.fTargetManager == null) {
            this.fTargetManager = new MakeTargetManager();
            this.fTargetManager.startup();
        }
        return this.fTargetManager;
    }

    public IMakefile createMakefile(IFile file) {
        GNUMakefile gnu = new GNUMakefile();
        try {
            String cwd;
            gnu.parse(file.getLocation().toOSString());
            String[] dirs = gnu.getIncludeDirectories();
            String[] includes = new String[dirs.length + 1];
            System.arraycopy(dirs, 0, includes, 0, dirs.length);
            includes[dirs.length] = cwd = file.getLocation().removeLastSegments(1).toOSString();
            gnu.setIncludeDirectories(includes);
        }
        catch (IOException iOException) {}
        return gnu;
    }

    public void shutdown() throws CoreException {
        super.shutdown();
        if (this.fTargetManager != null) {
            this.fTargetManager.shutdown();
            this.fTargetManager = null;
        }
    }
}

