/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICPathEntry;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.LibraryReference;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;

public class CProject
extends CContainer
implements ICProject {
    private static final String CUSTOM_DEFAULT_OPTION_VALUE = "#\r\n\r#custom-non-empty-default-value#\r\n\r#";

    public CProject(ICElement parent, IProject project) {
        super(parent, (IResource)project, 11);
    }

    public IBinaryContainer getBinaryContainer() {
        return ((CProjectInfo)this.getElementInfo()).getBinaryContainer();
    }

    public IArchiveContainer getArchiveContainer() {
        return ((CProjectInfo)this.getElementInfo()).getArchiveContainer();
    }

    public IProject getProject() {
        return this.getUnderlyingResource().getProject();
    }

    public ICElement findElement(IPath path) throws CModelException {
        ICElement celem = null;
        if (path.isAbsolute()) {
            celem = CModelManager.getDefault().create(path);
        } else {
            IProject project = this.getProject();
            if (project != null) {
                IPath p = project.getFullPath().append(path);
                celem = CModelManager.getDefault().create(p);
            }
        }
        if (celem == null) {
            CModelStatus status = new CModelStatus(979, path);
            throw new CModelException(status);
        }
        return celem;
    }

    public static boolean hasCNature(IProject p) {
        try {
            return p.hasNature("org.eclipse.cdt.core.cnature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    protected CElementInfo createElementInfo() {
        return new CProjectInfo(this);
    }

    public int hashCode() {
        return this.getProject().hashCode();
    }

    public ILibraryReference[] getLibraryReferences() throws CModelException {
        ArrayList<LibraryReference> list = new ArrayList<LibraryReference>(5);
        try {
            ICDescriptor cdesc = CCorePlugin.getDefault().getCProjectDescription(this.getProject());
            ICPathEntry[] entries = cdesc.getPathEntries();
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getEntryKind() == 1) {
                    ICPathEntry entry = entries[i];
                    list.add(new LibraryReference((ICElement)this, entry.getPath().lastSegment(), entry));
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new CModelException(e);
        }
        return list.toArray(new ILibraryReference[0]);
    }

    public String getOption(String optionName, boolean inheritCCoreOptions) {
        if (CModelManager.OptionNames.contains(optionName)) {
            Preferences preferences = this.getPreferences();
            if (preferences == null || preferences.isDefault(optionName)) {
                return inheritCCoreOptions ? CCorePlugin.getOption(optionName) : null;
            }
            return preferences.getString(optionName).trim();
        }
        return null;
    }

    public Map getOptions(boolean inheritCCoreOptions) {
        String propertyName;
        int i;
        HashMap options = inheritCCoreOptions ? CCorePlugin.getOptions() : new HashMap(5);
        Preferences preferences = this.getPreferences();
        if (preferences == null) {
            return options;
        }
        HashSet optionNames = CModelManager.OptionNames;
        if (inheritCCoreOptions) {
            String[] defaultPropertyNames = preferences.defaultPropertyNames();
            i = 0;
            while (i < defaultPropertyNames.length) {
                propertyName = defaultPropertyNames[i];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getDefaultString(propertyName).trim());
                }
                ++i;
            }
        }
        String[] propertyNames = preferences.propertyNames();
        i = 0;
        while (i < propertyNames.length) {
            propertyName = propertyNames[i];
            if (optionNames.contains(propertyName)) {
                options.put(propertyName, preferences.getString(propertyName).trim());
            }
            ++i;
        }
        return options;
    }

    public void setOption(String optionName, String optionValue) {
        if (!CModelManager.OptionNames.contains(optionName)) {
            return;
        }
        Preferences preferences = this.getPreferences();
        preferences.setDefault(optionName, CUSTOM_DEFAULT_OPTION_VALUE);
        preferences.setValue(optionName, optionValue);
        this.savePreferences(preferences);
    }

    public void setOptions(Map newOptions) {
        Preferences preferences = new Preferences();
        this.setPreferences(preferences);
        if (newOptions != null) {
            Iterator keys = newOptions.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!CModelManager.OptionNames.contains(key)) continue;
                String value = (String)newOptions.get(key);
                preferences.setDefault(key, CUSTOM_DEFAULT_OPTION_VALUE);
                preferences.setValue(key, value);
            }
        }
        this.savePreferences(preferences);
    }

    private Preferences getPreferences() {
        Preferences preferences = new Preferences();
        Iterator iter = CModelManager.OptionNames.iterator();
        while (iter.hasNext()) {
            String qualifiedName = (String)iter.next();
            String dequalifiedName = qualifiedName.substring("org.eclipse.cdt.core".length() + 1);
            String value = null;
            try {
                value = this.resource.getPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName));
            }
            catch (CoreException coreException) {}
            if (value == null) continue;
            preferences.setValue(qualifiedName, value);
        }
        return preferences;
    }

    private void savePreferences(Preferences preferences) {
        if (preferences == null) {
            return;
        }
        Iterator iter = CModelManager.OptionNames.iterator();
        while (iter.hasNext()) {
            String qualifiedName = (String)iter.next();
            String dequalifiedName = qualifiedName.substring("org.eclipse.cdt.core".length() + 1);
            String value = null;
            try {
                value = preferences.getString(qualifiedName);
                if (value != null && !value.equals(preferences.getDefaultString(qualifiedName))) {
                    this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName), value);
                    continue;
                }
                this.resource.setPersistentProperty(new QualifiedName("org.eclipse.cdt.core", dequalifiedName), null);
            }
            catch (CoreException coreException) {}
        }
    }

    private void setPreferences(Preferences preferences) {
    }
}

