/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTConstructorMemberInitializer;
import org.eclipse.cdt.core.parser.ast.IASTExceptionSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTTemplate;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTFunction;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;

public class ASTMethod
extends ASTFunction
implements IASTMethod {
    private final List constructorChain;
    private final boolean isConstructor;
    private final boolean isPureVirtual;
    private final ASTAccessVisibility visibility;
    private final boolean isDestructor;

    public ASTMethod(IParameterizedSymbol symbol, int nameEndOffset, List parameters, IASTAbstractDeclaration returnType, IASTExceptionSpecification exception, int startOffset, int nameOffset, IASTTemplate ownerTemplate, List references, boolean previouslyDeclared, boolean isConstructor, boolean isDestructor, boolean isPureVirtual, ASTAccessVisibility visibility, List constructorChain) {
        super(symbol, nameEndOffset, parameters, returnType, exception, startOffset, nameOffset, ownerTemplate, references, previouslyDeclared);
        this.visibility = visibility;
        this.isConstructor = isConstructor;
        this.isDestructor = isDestructor;
        this.isPureVirtual = isPureVirtual;
        this.constructorChain = constructorChain;
    }

    public boolean isVirtual() {
        return this.symbol.getTypeInfo().checkBit(2048);
    }

    public boolean isExplicit() {
        return this.symbol.getTypeInfo().checkBit(4096);
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isDestructor() {
        return this.isDestructor;
    }

    public boolean isConst() {
        return this.symbol.getTypeInfo().checkBit(32768);
    }

    public boolean isVolatile() {
        return this.symbol.getTypeInfo().checkBit(65536);
    }

    public boolean isPureVirtual() {
        return this.isPureVirtual;
    }

    public ASTAccessVisibility getVisiblity() {
        return this.visibility;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptMethodDeclaration(this);
        }
        catch (Exception exception) {}
        this.methodCallbacks(requestor);
    }

    protected void methodCallbacks(ISourceElementRequestor requestor) {
        this.functionCallbacks(requestor);
        this.processConstructorChain(requestor);
    }

    protected void processConstructorChain(ISourceElementRequestor requestor) {
        if (this.constructorChain != null) {
            Iterator i = this.getConstructorChainInitializers();
            while (i.hasNext()) {
                IASTConstructorMemberInitializer c = (IASTConstructorMemberInitializer)i.next();
                c.acceptElement(requestor);
            }
        }
    }

    public void enterScope(ISourceElementRequestor requestor) {
        try {
            requestor.enterMethodBody(this);
        }
        catch (Exception exception) {}
        this.methodCallbacks(requestor);
    }

    public void exitScope(ISourceElementRequestor requestor) {
        try {
            requestor.exitMethodBody(this);
        }
        catch (Exception exception) {}
    }

    public Iterator getConstructorChainInitializers() {
        if (this.constructorChain == null) {
            return new EmptyIterator();
        }
        return this.constructorChain.iterator();
    }
}

