/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.preferences.ColorEditor;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.WorkbenchChainedTextFontFieldEditor;

public class CEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected final String[][] fListModel = new String[][]{{"Multi-line comment", "c_multi_line_comment"}, {"Single-line comment", "c_single_line_comment"}, {"Keywords", "c_keyword"}, {"Built-in types", "c_type"}, {"Strings", "c_string"}, {"Others", "c_default"}, {PreferencesMessages.getString("CEditorPreferencePage.cCommentTaskTags"), "c_comment_task_tag"}};
    protected final String[][] fAppearanceColorListModel = new String[][]{{"Line number color", "lineNumberColor"}, {"Matching bracket color", "matchingBracketsColor"}, {"Current line highlight color", "currentLineColor"}, {"Print margin color", "printMarginColor"}, {"Linked position color", "linkedPositionColor"}};
    protected OverlayPreferenceStore fOverlayStore;
    private CTextTools fCTextTools;
    protected Map fColorButtons = new HashMap();
    private SelectionListener fColorButtonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ColorEditor editor = (ColorEditor)e.widget.getData();
            PreferenceConverter.setValue((IPreferenceStore)CEditorPreferencePage.this.fOverlayStore, (String)((String)CEditorPreferencePage.this.fColorButtons.get(editor)), (RGB)editor.getColorValue());
        }
    };
    protected Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            CEditorPreferencePage.this.fOverlayStore.setValue((String)CEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    protected Map fTextFields = new HashMap();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            CEditorPreferencePage.this.fOverlayStore.setValue((String)CEditorPreferencePage.this.fTextFields.get(text), text.getText());
        }
    };
    private WorkbenchChainedTextFontFieldEditor fFontEditor;
    protected List fList;
    protected ColorEditor fForegroundColorEditor;
    protected ColorEditor fBackgroundColorEditor;
    private Button fBackgroundDefaultRadioButton;
    protected Button fBackgroundCustomRadioButton;
    protected Button fBackgroundColorButton;
    protected Button fBoldCheckBox;
    protected SourceViewer fPreviewViewer;
    protected List fAppearanceColorList;
    protected ColorEditor fAppearanceForegroundColorEditor;
    private final String[][] fAnnotationColorListModel;
    private ColorEditor fAnnotationForegroundColorEditor;
    private List fAnnotationList;
    private Button fShowInOverviewRulerCheckBox;
    private Button fShowInTextCheckBox;
    private Color fBackgroundColor;
    private ArrayList fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CEditorPreferencePage.this.numberFieldChanged((Text)e.widget);
        }
    };
    private Button fBracketHighlightButton;
    private Button fLineHighlightButton;

    public CEditorPreferencePage() {
        this.setDescription(CUIPlugin.getResourceString("CEditorPreferencePage.description"));
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        MarkerAnnotationPreferences preferences = new MarkerAnnotationPreferences();
        this.fAnnotationColorListModel = this.createAnnotationTypeListModel(preferences);
        this.fOverlayStore = this.createOverlayStore(preferences);
    }

    private OverlayPreferenceStore createOverlayStore(MarkerAnnotationPreferences preferences) {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, info.getColorPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getTextPreferenceKey()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, info.getOverviewRulerPreferenceKey()));
        }
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Foreground.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "AbstractTextEditor.Color.Background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "AbstractTextEditor.Color.Background.SystemDefault"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "org.eclipse.cdt.editor.tab.width"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "c_multi_line_comment"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "c_multi_line_comment_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "c_single_line_comment"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "c_single_line_comment_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "c_keyword"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "c_keyword_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "c_type"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "c_type_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "c_string"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "c_string_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "c_default"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "c_default_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "matchingBracketsColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "matchingBrackets"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "currentLineColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "currentLine"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "spacesForTabs"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "printMarginColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "printMarginColumn"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "printMargin"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "linkedPositionColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "lineNumberColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "lineNumberRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "overviewRuler"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoactivation"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "content_assist_autoactivation_delay"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_autoinsert"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_autoactivation_triggers_java"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_show_visible_proposals"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_order_proposals"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_case_sensitivity"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_add_import"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "content_assist_project_scope_search"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "c_comment_task_tag"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "c_comment_task_tag_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "taskIndicationColor"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "taskIndication"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "taskIndicationInOverviewRuler"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    public static void initDefaults(IPreferenceStore store) {
        Display display = Display.getDefault();
        MarkerAnnotationPreferences preferences = new MarkerAnnotationPreferences();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            store.setDefault(info.getTextPreferenceKey(), info.getTextPreferenceValue());
            store.setDefault(info.getOverviewRulerPreferenceKey(), info.getOverviewRulerPreferenceValue());
            PreferenceConverter.setDefault((IPreferenceStore)store, (String)info.getColorPreferenceKey(), (RGB)info.getColorPreferenceValue());
        }
        store.setDefault("matchingBrackets", true);
        Color color = display.getSystemColor(15);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"matchingBracketsColor", (RGB)color.getRGB());
        store.setDefault("currentLine", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"currentLineColor", (RGB)new RGB(225, 235, 224));
        store.setDefault("printMargin", true);
        store.setDefault("printMarginColumn", 80);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"printMarginColor", (RGB)new RGB(176, 180, 185));
        WorkbenchChainedTextFontFieldEditor.startPropagate((IPreferenceStore)store, (String)"org.eclipse.jface.textfont");
        color = display.getSystemColor(24);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Foreground", (RGB)color.getRGB());
        store.setDefault("AbstractTextEditor.Color.Foreground.SystemDefault", true);
        color = display.getSystemColor(25);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"AbstractTextEditor.Color.Background", (RGB)color.getRGB());
        store.setDefault("AbstractTextEditor.Color.Background.SystemDefault", false);
        store.setDefault("org.eclipse.cdt.editor.tab.width", 4);
        store.setDefault("spacesForTabs", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"c_multi_line_comment", (RGB)new RGB(63, 127, 95));
        store.setDefault("c_multi_line_comment_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"c_single_line_comment", (RGB)new RGB(63, 125, 95));
        store.setDefault("c_single_line_comment_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"c_keyword", (RGB)new RGB(127, 0, 85));
        store.setDefault("c_keyword_bold", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"c_type", (RGB)new RGB(127, 0, 85));
        store.setDefault("c_type_bold", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"c_string", (RGB)new RGB(42, 0, 255));
        store.setDefault("c_string_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"c_default", (RGB)new RGB(0, 0, 0));
        store.setDefault("c_default_bold", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"linkedPositionColor", (RGB)new RGB(0, 200, 100));
        store.setDefault("lineNumberRuler", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"lineNumberColor", (RGB)new RGB(0, 0, 0));
        store.setDefault("overviewRuler", true);
        store.setDefault("content_assist_autoactivation", false);
        store.setDefault("content_assist_autoactivation_delay", 500);
        store.setDefault("content_assist_autoinsert", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"content_assist_proposals_background", (RGB)new RGB(254, 241, 233));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"content_assist_proposals_foreground", (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"content_assist_parameters_background", (RGB)new RGB(254, 241, 233));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"content_assist_parameters_foreground", (RGB)new RGB(0, 0, 0));
        store.setDefault("content_assist_case_sensitivity", false);
        store.setDefault("content_assist_order_proposals", false);
        store.setDefault("content_assist_add_import", true);
        store.setDefault("content_assist_project_scope_search", false);
    }

    public void init(IWorkbench workbench) {
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    protected void handleListSelection() {
        int i = this.fList.getSelectionIndex();
        String key = this.fListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fForegroundColorEditor.setColorValue(rgb);
        this.fBoldCheckBox.setSelection(this.fOverlayStore.getBoolean(String.valueOf(key) + "_bold"));
    }

    private Control createAnnotationsPage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 16384);
        label.setText("Annotation Presentation Options");
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAnnotationList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(8);
        this.fAnnotationList.setLayoutData((Object)gd);
        Composite optionsComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        optionsComposite.setLayout((Layout)layout);
        optionsComposite.setLayoutData((Object)new GridData(1808));
        this.fShowInTextCheckBox = new Button(optionsComposite, 32);
        this.fShowInTextCheckBox.setText("Show In Text");
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInTextCheckBox.setLayoutData((Object)gd);
        this.fShowInOverviewRulerCheckBox = new Button(optionsComposite, 32);
        this.fShowInOverviewRulerCheckBox.setText("Show In Overview Ruler");
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fShowInOverviewRulerCheckBox.setLayoutData((Object)gd);
        label = new Label(optionsComposite, 16384);
        label.setText("Annotations Color");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fAnnotationForegroundColorEditor = new ColorEditor(optionsComposite);
        Button foregroundColorButton = this.fAnnotationForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAnnotationList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CEditorPreferencePage.this.handleAnnotationListSelection();
            }
        });
        this.fShowInTextCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = CEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = CEditorPreferencePage.this.fAnnotationColorListModel[i][2];
                CEditorPreferencePage.this.fOverlayStore.setValue(key, CEditorPreferencePage.this.fShowInTextCheckBox.getSelection());
            }
        });
        this.fShowInOverviewRulerCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = CEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = CEditorPreferencePage.this.fAnnotationColorListModel[i][3];
                CEditorPreferencePage.this.fOverlayStore.setValue(key, CEditorPreferencePage.this.fShowInOverviewRulerCheckBox.getSelection());
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = CEditorPreferencePage.this.fAnnotationList.getSelectionIndex();
                String key = CEditorPreferencePage.this.fAnnotationColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)CEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)CEditorPreferencePage.this.fAnnotationForegroundColorEditor.getColorValue());
            }
        });
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.cdt.ui.new_c_editor_annotations_pref_page_context");
        return composite;
    }

    private void handleAnnotationListSelection() {
        int i = this.fAnnotationList.getSelectionIndex();
        String key = this.fAnnotationColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAnnotationForegroundColorEditor.setColorValue(rgb);
        key = this.fAnnotationColorListModel[i][2];
        this.fShowInTextCheckBox.setSelection(this.fOverlayStore.getBoolean(key));
        key = this.fAnnotationColorListModel[i][3];
        this.fShowInOverviewRulerCheckBox.setSelection(this.fOverlayStore.getBoolean(key));
    }

    private String[][] createAnnotationTypeListModel(MarkerAnnotationPreferences preferences) {
        ArrayList<String[]> listModelItems = new ArrayList<String[]>();
        Iterator e = preferences.getAnnotationPreferences().iterator();
        while (e.hasNext()) {
            AnnotationPreference info = (AnnotationPreference)e.next();
            listModelItems.add(new String[]{info.getPreferenceLabel(), info.getColorPreferenceKey(), info.getTextPreferenceKey(), info.getOverviewRulerPreferenceKey()});
        }
        String[][] items = new String[listModelItems.size()][];
        listModelItems.toArray((T[])items);
        return items;
    }

    private Control createColorPage(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Composite backgroundComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        backgroundComposite.setLayout((Layout)layout);
        Label label = new Label(backgroundComposite, 0);
        label.setText("Bac&kground Color:");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        SelectionListener backgroundSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean custom = CEditorPreferencePage.this.fBackgroundCustomRadioButton.getSelection();
                CEditorPreferencePage.this.fBackgroundColorButton.setEnabled(custom);
                CEditorPreferencePage.this.fOverlayStore.setValue("AbstractTextEditor.Color.Background.SystemDefault", !custom);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fBackgroundDefaultRadioButton = new Button(backgroundComposite, 16400);
        this.fBackgroundDefaultRadioButton.setText("S&ystem Default");
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fBackgroundDefaultRadioButton.setLayoutData((Object)gd);
        this.fBackgroundDefaultRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundCustomRadioButton = new Button(backgroundComposite, 16400);
        this.fBackgroundCustomRadioButton.setText("C&ustom");
        this.fBackgroundCustomRadioButton.addSelectionListener(backgroundSelectionListener);
        this.fBackgroundColorEditor = new ColorEditor(backgroundComposite);
        this.fBackgroundColorButton = this.fBackgroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fBackgroundColorButton.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText("Fo&reground:");
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fList = new List(editorComposite, 516);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setText("C&olor:");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        label = new Label(stylesComposite, 16384);
        label.setText("&Bold:");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        label = new Label(colorComposite, 16384);
        label.setText("Preview:");
        label.setLayoutData((Object)new GridData(768));
        Control previewer = this.createPreviewer(colorComposite);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        previewer.setLayoutData((Object)gd);
        this.fList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CEditorPreferencePage.this.handleListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = CEditorPreferencePage.this.fList.getSelectionIndex();
                String key = CEditorPreferencePage.this.fListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)CEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)CEditorPreferencePage.this.fForegroundColorEditor.getColorValue());
            }
        });
        this.fBackgroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PreferenceConverter.setValue((IPreferenceStore)CEditorPreferencePage.this.fOverlayStore, (String)"AbstractTextEditor.Color.Background", (RGB)CEditorPreferencePage.this.fBackgroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = CEditorPreferencePage.this.fList.getSelectionIndex();
                String key = CEditorPreferencePage.this.fListModel[i][1];
                CEditorPreferencePage.this.fOverlayStore.setValue(String.valueOf(key) + "_bold", CEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        WorkbenchHelp.setHelp((Control)colorComposite, (String)"org.eclipse.cdt.ui.new_c_editor_colors_pref_page_context");
        return colorComposite;
    }

    private Control createPreviewer(Composite parent) {
        this.fCTextTools = new CTextTools(this.fOverlayStore);
        this.fPreviewViewer = new SourceViewer(parent, null, 768);
        this.fPreviewViewer.configure((SourceViewerConfiguration)new CSourceViewerConfiguration(this.fCTextTools, null));
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        this.initializeViewerColors((ISourceViewer)this.fPreviewViewer);
        String content = this.loadPreviewContentFromFile("ColorSettingPreviewCode.txt");
        Document document = new Document(content);
        IDocumentPartitioner partitioner = this.fCTextTools.createDocumentPartitioner();
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner(partitioner);
        this.fPreviewViewer.setDocument((IDocument)document);
        this.fOverlayStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String p = event.getProperty();
                if (p.equals("AbstractTextEditor.Color.Background") || p.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
                    CEditorPreferencePage.this.initializeViewerColors((ISourceViewer)CEditorPreferencePage.this.fPreviewViewer);
                }
                CEditorPreferencePage.this.fPreviewViewer.getDocument().set(CEditorPreferencePage.this.fPreviewViewer.getDocument().get());
            }
        });
        return this.fPreviewViewer.getControl();
    }

    protected void initializeViewerColors(ISourceViewer viewer) {
        OverlayPreferenceStore store = this.fOverlayStore;
        if (store != null) {
            StyledText styledText = viewer.getTextWidget();
            Color color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
            styledText.setBackground(color);
            if (this.fBackgroundColor != null) {
                this.fBackgroundColor.dispose();
            }
            this.fBackgroundColor = color;
        }
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    protected static void setEnabled(Control control, boolean enable) {
        control.setEnabled(enable);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                CEditorPreferencePage.setEnabled(children[i], enable);
                ++i;
            }
        }
    }

    protected void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceForegroundColorEditor.setColorValue(rgb);
    }

    private Control createBehaviorPage(Composite parent) {
        Composite behaviorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        behaviorComposite.setLayout((Layout)layout);
        String label = "Text &font:";
        this.addTextFontEditor(behaviorComposite, label, "org.eclipse.jface.textfont");
        label = "Displayed &tab width:";
        this.addTextField(behaviorComposite, label, "org.eclipse.cdt.editor.tab.width", 2, 0, true);
        label = "Print margin col&umn:";
        this.addTextField(behaviorComposite, label, "printMarginColumn", 4, 0, true);
        label = "Insert &space for tabs";
        this.addCheckBox(behaviorComposite, label, "spacesForTabs", 0);
        label = "Highlight &matching brackets";
        this.fBracketHighlightButton = this.addCheckBox(behaviorComposite, label, "matchingBrackets", 0);
        label = "Show line numbers";
        this.addCheckBox(behaviorComposite, label, "lineNumberRuler", 0);
        label = "Highlight &current line";
        this.fLineHighlightButton = this.addCheckBox(behaviorComposite, label, "currentLine", 0);
        label = "Show overview ruler";
        this.addCheckBox(behaviorComposite, label, "overviewRuler", 0);
        label = "Show print &margin";
        this.addCheckBox(behaviorComposite, label, "printMargin", 0);
        Label l = new Label(behaviorComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(behaviorComposite, 16384);
        l.setText("Appearance color options");
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(behaviorComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        l.setText("Color:");
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceForegroundColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = CEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = CEditorPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)CEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)CEditorPreferencePage.this.fAppearanceForegroundColorEditor.getColorValue());
            }
        });
        WorkbenchHelp.setHelp((Control)behaviorComposite, (String)"org.eclipse.cdt.ui.new_c_editor_pref_page_context");
        return behaviorComposite;
    }

    private Control createContentAssistPage(Composite parent) {
        Composite contentAssistComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        contentAssistComposite.setLayout((Layout)layout);
        String label = "&Search entire project for completion proposals";
        this.addCheckBox(contentAssistComposite, label, "content_assist_project_scope_search", 0);
        label = "Insert single &proposals automatically";
        this.addCheckBox(contentAssistComposite, label, "content_assist_autoinsert", 0);
        label = "&Enable auto activation";
        this.addCheckBox(contentAssistComposite, label, "content_assist_autoactivation", 0);
        label = "Auto activation dela&y:";
        this.addTextField(contentAssistComposite, label, "content_assist_autoactivation_delay", 4, 0, true);
        label = "Auto activation &triggers for C:";
        this.addTextField(contentAssistComposite, label, "content_assist_autoactivation_triggers_java", 25, 0, false);
        label = "&Background for completion proposals:";
        this.addColorButton(contentAssistComposite, label, "content_assist_proposals_background", 0);
        label = "&Foreground for completion proposals:";
        this.addColorButton(contentAssistComposite, label, "content_assist_proposals_foreground", 0);
        WorkbenchHelp.setHelp((Control)contentAssistComposite, (String)"org.eclipse.cdt.ui.new_c_editor_content_assist_pref_page_context");
        return contentAssistComposite;
    }

    protected Control createContents(Composite parent) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText("&General");
        item.setImage(CPluginImages.get("org.eclipse.cdt.ui.c_file_obj.gif"));
        item.setControl(this.createBehaviorPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setImage(CPluginImages.get("org.eclipse.cdt.ui.c_file_obj.gif"));
        item.setText("Annotations");
        item.setControl(this.createAnnotationsPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("&Colors");
        item.setImage(CPluginImages.get("org.eclipse.cdt.ui.c_file_obj.gif"));
        item.setControl(this.createColorPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText("Content A&ssist");
        item.setImage(CPluginImages.get("org.eclipse.cdt.ui.c_file_obj.gif"));
        item.setControl(this.createContentAssistPage((Composite)folder));
        this.initialize();
        return folder;
    }

    private void initialize() {
        this.fFontEditor.setPreferenceStore(this.getPreferenceStore());
        this.fFontEditor.setPreferencePage((PreferencePage)this);
        this.fFontEditor.load();
        this.initializeFields();
        int i = 0;
        while (i < this.fListModel.length) {
            this.fList.add(this.fListModel[i][0]);
            ++i;
        }
        this.fList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                CEditorPreferencePage.this.fList.select(0);
                CEditorPreferencePage.this.handleListSelection();
            }
        });
        i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                CEditorPreferencePage.this.fAppearanceColorList.select(0);
                CEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        i = 0;
        while (i < this.fAnnotationColorListModel.length) {
            this.fAnnotationList.add(this.fAnnotationColorListModel[i][0]);
            ++i;
        }
        this.fAnnotationList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (CEditorPreferencePage.this.fAnnotationList != null && !CEditorPreferencePage.this.fAnnotationList.isDisposed()) {
                    CEditorPreferencePage.this.fAnnotationList.select(0);
                    CEditorPreferencePage.this.handleAnnotationListSelection();
                }
            }
        });
    }

    private void initializeFields() {
        String key;
        Iterator e = this.fColorButtons.keySet().iterator();
        while (e.hasNext()) {
            ColorEditor c = (ColorEditor)e.next();
            key = (String)this.fColorButtons.get(c);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
            c.setColorValue(rgb);
        }
        e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.Background");
        this.fBackgroundColorEditor.setColorValue(rgb);
        boolean default_ = this.fOverlayStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        this.fBackgroundDefaultRadioButton.setSelection(default_);
        this.fBackgroundCustomRadioButton.setSelection(!default_);
        this.fBackgroundColorButton.setEnabled(!default_);
    }

    public boolean performOk() {
        this.fFontEditor.store();
        this.fOverlayStore.propagate();
        return true;
    }

    protected void performDefaults() {
        this.fFontEditor.loadDefault();
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleListSelection();
        this.handleAppearanceColorListSelection();
        super.performDefaults();
        this.fPreviewViewer.invalidateTextPresentation();
    }

    public void dispose() {
        if (this.fCTextTools != null) {
            this.fCTextTools = null;
        }
        this.fFontEditor.setPreferencePage(null);
        this.fFontEditor.setPreferenceStore(null);
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private Control addColorButton(Composite parent, String label, String key, int indentation) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        gd = new GridData(768);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        ColorEditor editor = new ColorEditor(composite);
        Button button = editor.getButton();
        button.setData((Object)editor);
        gd = new GridData();
        gd.horizontalAlignment = 3;
        button.setLayoutData((Object)gd);
        button.addSelectionListener(this.fColorButtonListener);
        this.fColorButtons.put(editor, key);
        return composite;
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(768);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private Control addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    private void addTextFontEditor(Composite parent, String label, String key) {
        Composite editorComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        editorComposite.setLayout((Layout)layout);
        this.fFontEditor = new WorkbenchChainedTextFontFieldEditor(key, label, editorComposite);
        this.fFontEditor.setChangeButtonText("C&hange...");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuffer buffer;
        block11: {
            String separator = System.getProperty("line.separator");
            buffer = new StringBuffer(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append(separator);
                    }
                }
                catch (IOException io) {
                    CUIPlugin.getDefault().log(io);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var7_9 = null;
            if (reader == null) break block11;
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        return buffer.toString();
    }

    protected void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue((String)this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() != 0) {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError("CEditorPreferencePage.invalid_input");
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError("CEditorPreferencePage.invalid_input");
            }
        }
        return status;
    }

    private void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = (Text)this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = StatusUtil.getMoreSevere(s, status);
                ++i;
            }
        }
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }
}

