/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIBreakpointManager;
import org.eclipse.cdt.debug.core.cdi.ICDIEventManager;
import org.eclipse.cdt.debug.core.cdi.ICDIExpressionManager;
import org.eclipse.cdt.debug.core.cdi.ICDIMemoryManager;
import org.eclipse.cdt.debug.core.cdi.ICDIRegisterManager;
import org.eclipse.cdt.debug.core.cdi.ICDISharedLibraryManager;
import org.eclipse.cdt.debug.core.cdi.ICDISignalManager;
import org.eclipse.cdt.debug.core.cdi.ICDISourceManager;
import org.eclipse.cdt.debug.core.cdi.ICDIVariableManager;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SessionObject;
import org.eclipse.cdt.debug.mi.core.cdi.event.ChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.CreatedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.DestroyedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.DisconnectedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.ExitedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.MemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.ResumedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.event.SuspendedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.model.MemoryBlock;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIBreakpointDeletedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MICreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDestroyedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIDetachedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIGDBExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIInferiorSignalExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIMemoryCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRunningEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISharedLibUnloadedEvent;
import org.eclipse.cdt.debug.mi.core.event.MISignalChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIStoppedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIThreadExitEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarCreatedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarDeletedEvent;

public class EventManager
extends SessionObject
implements ICDIEventManager,
Observer {
    List list = Collections.synchronizedList(new ArrayList(1));
    List tokenList = new ArrayList(1);

    public void update(Observable o, Object arg) {
        MIEvent miEvent = (MIEvent)arg;
        Session session = (Session)this.getSession();
        ArrayList<Object> cdiList = new ArrayList<Object>(1);
        if (!this.ignoreEventToken(miEvent.getToken())) {
            MIEvent bpoint;
            if (miEvent instanceof MIStoppedEvent) {
                this.processSuspendedEvent((MIStoppedEvent)miEvent);
                cdiList.add(new SuspendedEvent(session, miEvent));
            } else if (miEvent instanceof MIRunningEvent) {
                cdiList.add(new ResumedEvent(session, (MIRunningEvent)miEvent));
            } else if (miEvent instanceof MIChangedEvent) {
                if (miEvent instanceof MIVarChangedEvent) {
                    cdiList.add(new ChangedEvent(session, (MIVarChangedEvent)miEvent));
                } else if (miEvent instanceof MIRegisterChangedEvent) {
                    cdiList.add(new ChangedEvent(session, (MIRegisterChangedEvent)miEvent));
                } else if (miEvent instanceof MIMemoryChangedEvent) {
                    MemoryManager mgr = (MemoryManager)session.getMemoryManager();
                    MemoryBlock[] blocks = mgr.listMemoryBlocks();
                    MIMemoryChangedEvent miMem = (MIMemoryChangedEvent)miEvent;
                    Long[] addresses = miMem.getAddresses();
                    int i = 0;
                    while (i < blocks.length) {
                        if (blocks[i].contains(addresses) && (!blocks[i].isFrozen() || blocks[i].isDirty())) {
                            cdiList.add(new MemoryChangedEvent(session, blocks[i], miMem));
                            blocks[i].setDirty(false);
                        }
                        ++i;
                    }
                } else if (miEvent instanceof MIBreakpointChangedEvent) {
                    bpoint = (MIBreakpointChangedEvent)miEvent;
                    if (((MIBreakpointChangedEvent)bpoint).getNumber() > 0) {
                        cdiList.add(new ChangedEvent(session, (MIBreakpointChangedEvent)bpoint));
                    } else {
                        try {
                            session.getBreakpointManager().update();
                        }
                        catch (CDIException cDIException) {}
                    }
                } else if (miEvent instanceof MISharedLibChangedEvent) {
                    cdiList.add(new ChangedEvent(session, (MISharedLibChangedEvent)miEvent));
                } else if (miEvent instanceof MISignalChangedEvent) {
                    MISignalChangedEvent sig = (MISignalChangedEvent)miEvent;
                    String name = sig.getName();
                    if (name == null || name.length() == 0) {
                        try {
                            session.getSignalManager().update();
                        }
                        catch (CDIException cDIException) {}
                    } else {
                        cdiList.add(new ChangedEvent(session, sig));
                    }
                }
            } else if (miEvent instanceof MIDestroyedEvent) {
                if (miEvent instanceof MIThreadExitEvent) {
                    cdiList.add(new DestroyedEvent(session, (MIThreadExitEvent)miEvent));
                } else if (miEvent instanceof MIInferiorSignalExitEvent) {
                    cdiList.add(new ExitedEvent(session, (MIInferiorSignalExitEvent)miEvent));
                } else if (miEvent instanceof MIInferiorExitEvent) {
                    cdiList.add(new ExitedEvent(session, (MIInferiorExitEvent)miEvent));
                } else if (miEvent instanceof MIGDBExitEvent) {
                    cdiList.add(new DestroyedEvent(session));
                } else if (miEvent instanceof MIDetachedEvent) {
                    cdiList.add(new DisconnectedEvent(session));
                } else if (miEvent instanceof MIBreakpointDeletedEvent) {
                    bpoint = (MIBreakpointDeletedEvent)miEvent;
                    if (((MIBreakpointDeletedEvent)bpoint).getNumber() > 0) {
                        cdiList.add(new DestroyedEvent(session, (MIBreakpointDeletedEvent)bpoint));
                    } else {
                        try {
                            session.getBreakpointManager().update();
                        }
                        catch (CDIException cDIException) {}
                    }
                } else if (miEvent instanceof MISharedLibUnloadedEvent) {
                    cdiList.add(new DestroyedEvent(session, (MISharedLibUnloadedEvent)miEvent));
                } else if (miEvent instanceof MIVarDeletedEvent) {
                    cdiList.add(new DestroyedEvent(session, (MIVarDeletedEvent)miEvent));
                }
            } else if (miEvent instanceof MICreatedEvent) {
                if (miEvent instanceof MIBreakpointCreatedEvent) {
                    bpoint = (MIBreakpointCreatedEvent)miEvent;
                    if (((MIBreakpointCreatedEvent)bpoint).getNumber() > 0) {
                        cdiList.add(new CreatedEvent(session, (MIBreakpointCreatedEvent)bpoint));
                    } else {
                        try {
                            session.getBreakpointManager().update();
                        }
                        catch (CDIException cDIException) {}
                    }
                } else if (miEvent instanceof MIVarCreatedEvent) {
                    cdiList.add(new CreatedEvent(session, (MIVarCreatedEvent)miEvent));
                } else if (miEvent instanceof MIRegisterCreatedEvent) {
                    cdiList.add(new CreatedEvent(session, (MIRegisterCreatedEvent)miEvent));
                } else if (miEvent instanceof MIThreadCreatedEvent) {
                    cdiList.add(new CreatedEvent(session, (MIThreadCreatedEvent)miEvent));
                } else if (miEvent instanceof MIMemoryCreatedEvent) {
                    cdiList.add(new CreatedEvent(session, (MIMemoryCreatedEvent)miEvent));
                } else if (miEvent instanceof MISharedLibCreatedEvent) {
                    cdiList.add(new CreatedEvent(session, (MISharedLibCreatedEvent)miEvent));
                }
            }
        }
        ICDIEvent[] cdiEvents = cdiList.toArray(new ICDIEvent[0]);
        this.fireEvents(cdiEvents);
    }

    public EventManager(Session session) {
        super(session);
    }

    public void addEventListener(ICDIEventListener listener) {
        this.list.add(listener);
    }

    public void removeEventListener(ICDIEventListener listener) {
        this.list.remove(listener);
    }

    private void fireEvents(ICDIEvent[] cdiEvents) {
        if (cdiEvents != null) {
            int i = 0;
            while (i < cdiEvents.length) {
                this.fireEvent(cdiEvents[i]);
                ++i;
            }
        }
    }

    private void fireEvent(ICDIEvent cdiEvent) {
        if (cdiEvent != null) {
            ICDIEventListener[] listeners = this.list.toArray(new ICDIEventListener[0]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].handleDebugEvent(cdiEvent);
                ++i;
            }
        }
    }

    void processSuspendedEvent(MIStoppedEvent stopped) {
        Session session = (Session)this.getSession();
        ICDITarget currentTarget = session.getCurrentTarget();
        int threadId = stopped.getThreadId();
        if (currentTarget instanceof Target) {
            ((Target)currentTarget).updateState(threadId);
        }
        ICDIVariableManager varMgr = session.getVariableManager();
        ICDIExpressionManager expMgr = session.getExpressionManager();
        ICDIRegisterManager regMgr = session.getRegisterManager();
        ICDIMemoryManager memMgr = session.getMemoryManager();
        ICDISharedLibraryManager libMgr = session.getSharedLibraryManager();
        ICDIBreakpointManager bpMgr = session.getBreakpointManager();
        ICDISignalManager sigMgr = session.getSignalManager();
        ICDISourceManager srcMgr = session.getSourceManager();
        try {
            if (varMgr.isAutoUpdate()) {
                varMgr.update();
            }
            if (expMgr.isAutoUpdate()) {
                expMgr.update();
            }
            if (regMgr.isAutoUpdate()) {
                regMgr.update();
            }
            if (memMgr.isAutoUpdate()) {
                memMgr.update();
            }
            if (libMgr.isAutoUpdate()) {
                libMgr.update();
            }
            if (bpMgr.isAutoUpdate()) {
                bpMgr.update();
            }
            if (sigMgr.isAutoUpdate()) {
                sigMgr.update();
            }
            if (srcMgr.isAutoUpdate()) {
                srcMgr.update();
            }
        }
        catch (CDIException cDIException) {}
    }

    void processRunningEvent() {
    }

    void disableEventToken(int token) {
        this.tokenList.add(new Integer(token));
    }

    void disableEventTokens(int[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            this.disableEventToken(tokens[i]);
            ++i;
        }
    }

    void enableEventToken(int token) {
        Integer t = new Integer(token);
        if (this.tokenList.contains(t)) {
            this.tokenList.remove(t);
        }
    }

    void enableEventTokens(int[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            this.enableEventToken(tokens[i]);
            ++i;
        }
    }

    private boolean ignoreEventToken(int token) {
        return this.tokenList.contains(new Integer(token));
    }
}

