/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class CoreFileLaunchDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Launching postmortem debugger", -1);
        if (monitor.isCanceled()) {
            return;
        }
        IFile exeFile = this.getProgramFile(config);
        ICDebugConfiguration debugConfig = this.getDebugConfig(config);
        ICDISession dsession = null;
        ICProject cproject = AbstractCLaunchDelegate.getCProject(config);
        IPath corefile = this.getCoreFilePath((IProject)cproject.getResource());
        if (corefile == null) {
            this.cancel("No Corefile selected", 108);
        }
        Process debugger = null;
        IProcess debuggerProcess = null;
        try {
            dsession = debugConfig.getDebugger().createCoreSession(config, exeFile, corefile);
            debugger = dsession.getSessionProcess();
        }
        catch (CDIException e) {
            this.abort("Failed Launching CDI Debugger", e, 150);
        }
        if (debugger != null) {
            debuggerProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)debugger, (String)"Debug Console");
            launch.removeProcess(debuggerProcess);
        }
        this.setSourceLocator(launch, config);
        CDebugModel.newCoreFileDebugTarget((ILaunch)launch, (ICDITarget)dsession.getCurrentTarget(), (String)this.renderTargetLabel(debugConfig), (IProcess)debuggerProcess, (IFile)exeFile);
        monitor.done();
    }

    protected IPath getCoreFilePath(final IProject project) throws CoreException {
        final Shell shell = LaunchUIPlugin.getShell();
        final String[] res = new String[1];
        if (shell == null) {
            this.abort("No Shell availible in Launch", null, 150);
        }
        Display display = shell.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                FileDialog dialog = new FileDialog(shell);
                dialog.setText("Select Corefile");
                String initPath = null;
                try {
                    initPath = project.getPersistentProperty(new QualifiedName(LaunchUIPlugin.getUniqueIdentifier(), "SavePath"));
                }
                catch (CoreException coreException) {}
                if (initPath == null || initPath.equals("")) {
                    initPath = project.getLocation().toString();
                }
                dialog.setFilterPath(initPath);
                res[0] = dialog.open();
            }
        });
        if (res[0] != null) {
            return new Path(res[0]);
        }
        return null;
    }

    public String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

