/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.MakefileGenerator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class GeneratedMakefileBuilder
extends ACBuilder {
    private static final String MESSAGE = "ManagedMakeBuilder.message";
    private static final String BUILD_ERROR = "ManagedMakeBuilder.message.error";
    private static final String REFRESH_ERROR = "ManagedMakeBuilder.message.error.refresh";
    private static final String BUILD_FINISHED = "ManagedMakeBuilder.message.finished";
    private static final String INCREMENTAL = "ManagedMakeBuilder.message.incremental";
    private static final String MAKE = "ManagedMakeBuilder.message.make";
    private static final String REBUILD = "ManagedMakeBuilder.message.rebuild";
    private static final String START = "ManagedMakeBuilder.message.starting";
    private static final String REFRESH = "ManagedMakeBuilder.message.updating";
    private static final String MARKERS = "ManagedMakeBuilder.message.creating.markers";
    protected List resourcesToBuild;
    protected List ruleList;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        String statusMsg = ManagedBuilderCorePlugin.getFormattedString(START, this.getProject().getName());
        if (statusMsg != null) {
            monitor.subTask(statusMsg);
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.getProject());
        if (kind == 6 || info.isDirty()) {
            this.fullBuild(monitor, info);
        } else if (kind == 9 && info.isDirty()) {
            this.fullBuild(monitor, info);
        } else {
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor, info);
            } else {
                delta.accept((IResourceDeltaVisitor)visitor);
                if (visitor.shouldBuild()) {
                    this.incrementalBuild(delta, info, monitor);
                }
            }
        }
        info.setDirty(false);
        IProject[] deps = this.getProject().getReferencedProjects();
        int i = 0;
        while (i < deps.length) {
            IProject project = deps[i];
            IManagedBuildInfo depInfo = ManagedBuildManager.getBuildInfo((IResource)project);
            if (depInfo != null) {
                depInfo.setDirty(false);
            }
            ++i;
        }
        return deps;
    }

    public void checkCancel(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void fullBuild(IProgressMonitor monitor, IManagedBuildInfo info) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProject[] deps = this.getProject().getReferencedProjects();
        int i = 0;
        while (i < deps.length) {
            IProject depProject = deps[i];
            if (ManagedBuildManager.manages((IResource)depProject)) {
                IManagedBuildInfo depInfo = ManagedBuildManager.getBuildInfo((IResource)depProject);
                MakefileGenerator generator = new MakefileGenerator(depProject, depInfo, monitor);
                generator.regenerateMakefiles();
            }
            ++i;
        }
        String statusMsg = ManagedBuilderCorePlugin.getFormattedString(REBUILD, this.getProject().getName());
        monitor.subTask(statusMsg);
        MakefileGenerator generator = new MakefileGenerator(this.getProject(), info, monitor);
        generator.regenerateMakefiles();
        IPath topBuildDir = generator.getTopBuildDir();
        if (topBuildDir != null) {
            this.invokeMake(true, topBuildDir.removeFirstSegments(1), info, monitor);
        } else {
            monitor.done();
        }
    }

    protected String[] getMakeTargets(boolean fullBuild) {
        ArrayList<String> args = new ArrayList<String>();
        if (fullBuild) {
            args.add("clean");
        }
        args.add("all");
        return args.toArray(new String[args.size()]);
    }

    protected List getResourcesToBuild() {
        if (this.resourcesToBuild == null) {
            this.resourcesToBuild = new ArrayList();
        }
        return this.resourcesToBuild;
    }

    protected List getRuleList() {
        if (this.ruleList == null) {
            this.ruleList = new ArrayList();
        }
        return this.ruleList;
    }

    public IPath getWorkingDirectory() {
        IProject currProject = this.getProject();
        IPath workingDirectory = currProject.getLocation();
        return workingDirectory;
    }

    protected void incrementalBuild(IResourceDelta delta, IManagedBuildInfo info, IProgressMonitor monitor) throws CoreException {
        String statusMsg = null;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        statusMsg = ManagedBuilderCorePlugin.getFormattedString(INCREMENTAL, this.getProject().getName());
        monitor.subTask(statusMsg);
        IProject[] deps = this.getProject().getReferencedProjects();
        int i = 0;
        while (i < deps.length) {
            IProject depProject = deps[i];
            if (ManagedBuildManager.manages((IResource)depProject)) {
                IManagedBuildInfo depInfo = ManagedBuildManager.getBuildInfo((IResource)depProject);
                MakefileGenerator generator = new MakefileGenerator(depProject, depInfo, monitor);
                generator.regenerateMakefiles();
            }
            ++i;
        }
        MakefileGenerator generator = new MakefileGenerator(this.getProject(), info, monitor);
        generator.generateMakefiles(delta);
        Path buildDir = new Path(info.getConfigurationName());
        this.invokeMake(false, (IPath)buildDir, info, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void invokeMake(boolean fullBuild, IPath buildDir, IManagedBuildInfo info, IProgressMonitor monitor) {
        block27: {
            block26: {
                block25: {
                    block24: {
                        IProject currentProject = this.getProject();
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        try {
                            try {
                                String[] env;
                                CommandLauncher launcher;
                                String errMsg;
                                String[] makeTargets;
                                IProject[] deps;
                                ConsoleOutputStream consoleOutStream;
                                Path makeCommand;
                                IPath workingDirectory;
                                block28: {
                                    Enumeration<?> names;
                                    ArrayList<String> envList;
                                    Properties props;
                                    workingDirectory = this.getWorkingDirectory().append(buildDir);
                                    IWorkspace workspace = currentProject.getWorkspace();
                                    if (workspace == null) {
                                        Object var30_9 = null;
                                        break block24;
                                    }
                                    IWorkspaceRoot root = workspace.getRoot();
                                    if (root == null) {
                                        break block25;
                                    }
                                    IPath makefile = workingDirectory.addTrailingSeparator().append("makefile");
                                    if (root.getFileForLocation(makefile) == null) {
                                        break block26;
                                    }
                                    makeCommand = new Path(info.getMakeCommand());
                                    if (makeCommand == null) break block27;
                                    String[] msgs = new String[]{makeCommand.toString(), currentProject.getName()};
                                    monitor.beginTask(ManagedBuilderCorePlugin.getFormattedString(MAKE, msgs), -1);
                                    IConsole console = CCorePlugin.getDefault().getConsole();
                                    console.start(currentProject);
                                    consoleOutStream = console.getOutputStream();
                                    this.removeAllMarkers(currentProject);
                                    deps = currentProject.getReferencedProjects();
                                    int i = 0;
                                    while (true) {
                                        if (i >= deps.length) {
                                            ArrayList<String> makeArgs = new ArrayList<String>();
                                            String args = info.getMakeArguments();
                                            if (args.length() > 0) {
                                                makeArgs.add(args);
                                            }
                                            makeArgs.addAll(Arrays.asList(this.getMakeTargets(fullBuild)));
                                            makeTargets = makeArgs.toArray(new String[makeArgs.size()]);
                                            errMsg = null;
                                            launcher = new CommandLauncher();
                                            launcher.showCommand(true);
                                            props = launcher.getEnvironment();
                                            ((Hashtable)props).put("CWD", workingDirectory.toOSString());
                                            ((Hashtable)props).put("PWD", workingDirectory.toOSString());
                                            env = null;
                                            envList = new ArrayList<String>();
                                            names = props.propertyNames();
                                            if (names != null) {
                                                break;
                                            }
                                            break block28;
                                        }
                                        IProject project = deps[i];
                                        this.removeAllMarkers(project);
                                        ++i;
                                    }
                                    while (true) {
                                        if (!names.hasMoreElements()) {
                                            env = envList.toArray(new String[envList.size()]);
                                            break;
                                        }
                                        String key = (String)names.nextElement();
                                        envList.add(String.valueOf(key) + "=" + props.getProperty(key));
                                    }
                                }
                                ErrorParserManager epm = new ErrorParserManager((ACBuilder)this);
                                epm.setOutputStream((OutputStream)consoleOutStream);
                                OutputStream stdout = epm.getOutputStream();
                                OutputStream stderr = epm.getOutputStream();
                                Process proc = launcher.execute((IPath)makeCommand, makeTargets, env, workingDirectory);
                                if (proc != null) {
                                    try {
                                        proc.getOutputStream().close();
                                    }
                                    catch (IOException iOException) {}
                                    if (launcher.waitAndRead(stdout, stderr, (IProgressMonitor)new SubProgressMonitor(monitor, -1)) != 0) {
                                        errMsg = launcher.getErrorMessage();
                                    }
                                    monitor.subTask(ManagedBuilderCorePlugin.getResourceString(REFRESH));
                                    try {
                                        currentProject.refreshLocal(2, null);
                                        int j = 0;
                                        while (j < deps.length) {
                                            IProject project = deps[j];
                                            project.refreshLocal(2, null);
                                            ++j;
                                        }
                                    }
                                    catch (CoreException coreException) {
                                        monitor.subTask(ManagedBuilderCorePlugin.getResourceString(REFRESH_ERROR));
                                    }
                                } else {
                                    errMsg = launcher.getErrorMessage();
                                }
                                StringBuffer buf = new StringBuffer();
                                if (errMsg != null && errMsg.length() > 0) {
                                    String errorDesc = ManagedBuilderCorePlugin.getResourceString(BUILD_ERROR);
                                    buf.append(errorDesc);
                                    buf.append(System.getProperty("line.separator", "\n"));
                                    buf.append("(").append(errMsg).append(")");
                                } else {
                                    String successMsg = ManagedBuilderCorePlugin.getFormattedString(BUILD_FINISHED, currentProject.getName());
                                    buf.append(successMsg);
                                    buf.append(System.getProperty("line.separator", "\n"));
                                }
                                consoleOutStream.write(buf.toString().getBytes());
                                consoleOutStream.flush();
                                stdout.close();
                                stderr.close();
                                monitor.subTask(ManagedBuilderCorePlugin.getResourceString(MARKERS));
                                epm.reportProblems();
                            }
                            catch (Exception e) {
                                CCorePlugin.log((Throwable)e);
                                this.forgetLastBuiltState();
                            }
                            break block27;
                        }
                        catch (Throwable throwable) {
                            Object var30_12 = null;
                            monitor.done();
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return;
                }
                Object var30_10 = null;
                monitor.done();
                return;
            }
            Object var30_11 = null;
            monitor.done();
            return;
        }
        Object var30_13 = null;
        monitor.done();
    }

    private void removeAllMarkers(IProject project) throws CoreException {
        IWorkspace workspace = project.getWorkspace();
        IMarker[] markers = project.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (markers != null) {
            workspace.deleteMarkers(markers);
        }
    }

    public class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean buildNeeded = false;

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource != null && resource.getProject() == GeneratedMakefileBuilder.this.getProject()) {
                this.buildNeeded = true;
                return false;
            }
            return true;
        }

        public boolean shouldBuild() {
            return this.buildNeeded;
        }
    }
}

