/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.model.ICDebugElementErrorStatus;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;

public class CDebugElement
extends PlatformObject
implements IDebugElement,
ICDebugElementErrorStatus {
    private CDebugTarget fDebugTarget;
    private int fSeverity = 0;
    private String fMessage = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CDebugElement(CDebugTarget target) {
        this.setDebugTarget(target);
    }

    public String getModelIdentifier() {
        return CDebugModel.getPluginIdentifier();
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    protected void setDebugTarget(CDebugTarget target) {
        this.fDebugTarget = target;
    }

    public void internalError(Exception e) {
        this.logError(e);
    }

    public void internalError(String message) {
        this.logError(message);
    }

    protected void logError(Exception e) {
        CDebugCorePlugin.log(e);
    }

    protected void logError(String message) {
        CDebugCorePlugin.log(message);
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    public void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    public void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 1, detail));
    }

    public void fireSuspendEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 2, detail));
    }

    public void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public void fireChangeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 16, detail));
    }

    public ICDISession getCDISession() {
        return this.getCDITarget().getSession();
    }

    public ICDITarget getCDITarget() {
        IDebugTarget iDebugTarget = this.getDebugTarget();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.cdi.model.ICDITarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ICDITarget)iDebugTarget.getAdapter((Class)clazz);
    }

    public void requestFailed(String message, Exception e) throws DebugException {
        this.requestFailed(message, e, 5012);
    }

    public void targetRequestFailed(String message, CDIException e) throws DebugException {
        this.requestFailed("Target request failed: " + message, e, 5010);
    }

    public void requestFailed(String message, Throwable e, int code) throws DebugException {
        this.throwDebugException(message, code, e);
    }

    public void targetRequestFailed(String message, Throwable e) throws DebugException {
        this.throwDebugException("Target request failed: " + message, 5010, e);
    }

    public void notSupported(String message) throws DebugException {
        this.throwDebugException(message, 5011, null);
    }

    protected void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, CDebugModel.getPluginIdentifier(), code, message, exception));
    }

    protected void infoMessage(Throwable e) {
        Status newStatus = new Status(1, CDebugCorePlugin.getUniqueIdentifier(), 10001, e.getMessage(), null);
        CDebugUtils.info((IStatus)newStatus, this.getDebugTarget());
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.cdi.ICDISession");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            return this.getCDISession();
        }
        return super.getAdapter(adapter);
    }

    protected void setStatus(int severity, String message) {
        this.fSeverity = severity;
        this.fMessage = message;
        if (this.fMessage != null) {
            this.fMessage.trim();
        }
    }

    protected void resetStatus() {
        this.fSeverity = 0;
        this.fMessage = null;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getMessage() {
        return this.fMessage;
    }
}

