/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.debug.core.DebugException;

public class CSignal
extends CDebugElement
implements ICSignal,
ICDIEventListener {
    private ICDISignal fCDISignal;

    public CSignal(CDebugTarget target, ICDISignal cdiSignal) {
        super(target);
        this.fCDISignal = cdiSignal;
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public String getDescription() {
        return this.getCDISignal().getDescription();
    }

    public String getName() {
        return this.getCDISignal().getName();
    }

    public boolean isPassEnabled() {
        return !this.getCDISignal().isIgnore();
    }

    public boolean isStopEnabled() {
        return this.getCDISignal().isStopSet();
    }

    public void setPassEnabled(boolean enable) throws DebugException {
        this.handle(enable, this.isStopEnabled());
    }

    public void setStopEnabled(boolean enable) throws DebugException {
        this.handle(this.isPassEnabled(), enable);
    }

    public void handleDebugEvent(ICDIEvent event) {
    }

    public void dispose() {
        this.getCDISession().getEventManager().removeEventListener(this);
    }

    public void signal() throws DebugException {
        try {
            this.getCDITarget().signal(this.getCDISignal());
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }

    protected ICDISignal getCDISignal() {
        return this.fCDISignal;
    }

    private void handle(boolean pass, boolean stop) throws DebugException {
        try {
            this.getCDISignal().handle(!pass, stop);
        }
        catch (CDIException e) {
            this.targetRequestFailed(e.getMessage(), null);
        }
    }
}

