/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.cdt.debug.internal.ui.actions.BreakpointLocationVerifier;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.ITextEditor;

public class ManageBreakpointActionDelegate
implements IWorkbenchWindowActionDelegate,
IPartListener {
    private boolean fInitialized = false;
    private IAction fAction = null;
    private int fLineNumber;
    private ITextEditor fTextEditor = null;
    private IWorkbenchWindow fWorkbenchWindow = null;
    private IFile fFile = null;

    public void dispose() {
        this.getWorkbenchWindow().getPartService().removePartListener((IPartListener)this);
    }

    public void init(IWorkbenchWindow window) {
        this.setWorkbenchWindow(window);
        window.getPartService().addPartListener((IPartListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            this.setTextEditor((ITextEditor)part);
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getTextEditor()) {
            this.setTextEditor(null);
            if (this.getAction() != null) {
                this.getAction().setEnabled(false);
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof ITextEditor && this.getTextEditor() == null) {
            this.setTextEditor((ITextEditor)part);
        }
    }

    public void run(IAction action) {
        if (this.getTextEditor() != null) {
            this.update();
            this.manageBreakpoint(this.getTextEditor().getEditorInput());
        }
    }

    protected void update(ISelection selection) {
        this.setEnabledState(this.getTextEditor());
    }

    protected void update() {
        IAction action = this.getAction();
        if (action != null) {
            if (this.getTextEditor() != null) {
                this.breakpointExists(this.getTextEditor().getEditorInput());
            }
            action.setEnabled(this.getTextEditor() != null && this.getFile() != null);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!this.fInitialized) {
            IEditorPart part;
            IWorkbenchPage page;
            this.setAction(action);
            if (this.getWorkbenchWindow() != null && (page = this.getWorkbenchWindow().getActivePage()) != null && (part = page.getActiveEditor()) instanceof ITextEditor) {
                this.setTextEditor((ITextEditor)part);
                this.update(this.getTextEditor().getSelectionProvider().getSelection());
            }
            this.fInitialized = true;
        }
        this.update(selection);
    }

    protected void manageBreakpoint(IEditorInput editorInput) {
        ISelectionProvider sp = this.getTextEditor().getSelectionProvider();
        if (sp == null || this.getFile() == null) {
            this.beep();
            return;
        }
        ISelection selection = sp.getSelection();
        if (selection instanceof ITextSelection) {
            if (this.getFile() == null) {
                return;
            }
            BreakpointLocationVerifier bv = new BreakpointLocationVerifier();
            IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)editorInput);
            int lineNumber = bv.getValidLineBreakpointLocation(document, ((ITextSelection)selection).getStartLine());
            if (lineNumber > -1) {
                try {
                    ICLineBreakpoint breakpoint = CDebugModel.lineBreakpointExists((String)this.getFile().getLocation().toOSString(), (int)lineNumber);
                    if (breakpoint != null) {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                    } else {
                        CDebugModel.createLineBreakpoint((IResource)this.getFile(), (int)lineNumber, (boolean)true, (int)0, (String)"", (boolean)true);
                    }
                }
                catch (CoreException ce) {
                    CDebugUIPlugin.errorDialog("Cannot add breakpoint", ce);
                }
            }
        }
    }

    protected boolean breakpointExists(IEditorInput editorInput) {
        if (this.getFile() != null) {
            try {
                return CDebugModel.lineBreakpointExists((String)this.getFile().getLocation().toOSString(), (int)this.getLineNumber()) == null;
            }
            catch (CoreException ce) {
                CDebugUIPlugin.log(ce);
            }
        }
        return false;
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.fWorkbenchWindow;
    }

    protected void setWorkbenchWindow(IWorkbenchWindow workbenchWindow) {
        this.fWorkbenchWindow = workbenchWindow;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected void setTextEditor(ITextEditor editor) {
        this.fTextEditor = editor;
        if (this.fTextEditor != null) {
            IEditorInput input = this.fTextEditor.getEditorInput();
            this.setFile(input != null && input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null);
        }
        this.setEnabledState(editor);
    }

    protected void setEnabledState(ITextEditor editor) {
        if (this.getAction() != null) {
            this.getAction().setEnabled(editor != null);
        }
    }

    protected void beep() {
        if (CDebugUIPlugin.getActiveWorkbenchShell() != null) {
            CDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
        }
    }

    protected int getLineNumber() {
        return this.fLineNumber;
    }

    protected void setLineNumber(int lineNumber) {
        this.fLineNumber = lineNumber;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IFile getFile() {
        return this.fFile;
    }

    protected void setFile(IFile file) {
        this.fFile = file;
    }
}

