/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.sourcelookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.core.sourcelookup.IDirectorySourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.IProjectSourceLocation;
import org.eclipse.cdt.debug.core.sourcelookup.SourceLocationFactory;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CDirectorySourceLocation;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLocator;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.PixelConverter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.CheckedListDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.DialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.debug.internal.ui.dialogfields.IListAdapter;
import org.eclipse.cdt.debug.internal.ui.dialogfields.LayoutUtil;
import org.eclipse.cdt.debug.internal.ui.dialogfields.ListDialogField;
import org.eclipse.cdt.debug.internal.ui.dialogfields.Separator;
import org.eclipse.cdt.debug.internal.ui.wizards.AddSourceLocationWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class SourceLookupBlock {
    private static final String CP_LOCATION = "location";
    private static final String CP_ASSOCIATION = "association";
    private Composite fControl = null;
    private Shell fShell = null;
    private CheckedListDialogField fGeneratedSourceListField;
    private SourceListDialogField fAddedSourceListField;
    private ILaunchConfigurationDialog fLaunchConfigurationDialog = null;
    private boolean fIsDirty = false;
    private ICSourceLocator fLocator = null;
    private IProject fProject = null;

    public SourceLookupBlock() {
        String[] generatedSourceButtonLabels = new String[]{"Select All", "Deselect All"};
        String[] stringArray = new String[6];
        stringArray[0] = "Add...";
        stringArray[2] = "Up";
        stringArray[3] = "Down";
        stringArray[5] = "Remove";
        String[] addedSourceButtonLabels = stringArray;
        IListAdapter generatedSourceAdapter = new IListAdapter(){

            public void customButtonPressed(DialogField field, int index) {
                SourceLookupBlock.this.doGeneratedSourceButtonPressed(index);
            }

            public void selectionChanged(DialogField field) {
                SourceLookupBlock.this.doGeneratedSourceSelectionChanged();
            }
        };
        this.fGeneratedSourceListField = new CheckedListDialogField(generatedSourceAdapter, generatedSourceButtonLabels, (ILabelProvider)new SourceLookupLabelProvider());
        this.fGeneratedSourceListField.setLabelText("Generic Source Locations");
        this.fGeneratedSourceListField.setCheckAllButtonIndex(0);
        this.fGeneratedSourceListField.setUncheckAllButtonIndex(1);
        this.fGeneratedSourceListField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                SourceLookupBlock.this.doCheckStateChanged();
            }
        });
        IListAdapter addedSourceAdapter = new IListAdapter(){

            public void customButtonPressed(DialogField field, int index) {
                SourceLookupBlock.this.doAddedSourceButtonPressed(index);
            }

            public void selectionChanged(DialogField field) {
                SourceLookupBlock.this.doAddedSourceSelectionChanged();
            }
        };
        this.fAddedSourceListField = new SourceListDialogField(addedSourceAdapter, addedSourceButtonLabels, (ILabelProvider)new SourceLookupLabelProvider());
        this.fAddedSourceListField.setLabelText("Additional Source Locations");
        this.fAddedSourceListField.setUpButtonIndex(2);
        this.fAddedSourceListField.setDownButtonIndex(3);
        this.fAddedSourceListField.setRemoveButtonIndex(5);
    }

    public void createControl(Composite parent) {
        this.fShell = parent.getShell();
        this.fControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.fControl.setLayout((Layout)layout);
        this.fControl.setLayoutData((Object)new GridData(1808));
        this.fControl.setFont(JFaceResources.getDialogFont());
        PixelConverter converter = new PixelConverter((Control)this.fControl);
        this.fGeneratedSourceListField.doFillIntoGrid(this.fControl, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fGeneratedSourceListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fGeneratedSourceListField.getLabelControl(null), converter.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fGeneratedSourceListField.getListControl(null));
        ((CheckboxTableViewer)this.fGeneratedSourceListField.getTableViewer()).addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof IProjectSourceLocation) {
                    SourceLookupBlock.this.doCheckStateChanged();
                }
            }
        });
        new Separator().doFillIntoGrid(this.fControl, 3, converter.convertHeightInCharsToPixels(1));
        this.fAddedSourceListField.doFillIntoGrid(this.fControl, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fAddedSourceListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fAddedSourceListField.getLabelControl(null), converter.convertWidthInCharsToPixels(40));
        LayoutUtil.setHorizontalGrabbing(this.fAddedSourceListField.getListControl(null));
        TableViewer viewer = this.fAddedSourceListField.getTableViewer();
        Table table = viewer.getTable();
        TextCellEditor cellEditor = new TextCellEditor((Composite)table);
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = cellEditor;
        viewer.setCellEditors(cellEditorArray);
        viewer.setColumnProperties(new String[]{CP_LOCATION, CP_ASSOCIATION});
        viewer.setCellModifier(this.createCellModifier());
        new Separator().doFillIntoGrid(this.fControl, 3, converter.convertHeightInCharsToPixels(1));
    }

    private ICellModifier createCellModifier() {
        return new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return element instanceof CDirectorySourceLocation && property.equals(SourceLookupBlock.CP_ASSOCIATION);
            }

            public Object getValue(Object element, String property) {
                if (element instanceof CDirectorySourceLocation && property.equals(SourceLookupBlock.CP_ASSOCIATION)) {
                    return ((CDirectorySourceLocation)element).getAssociation() != null ? ((CDirectorySourceLocation)element).getAssociation().toOSString() : "";
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                Path association;
                Object entry = SourceLookupBlock.this.getSelection();
                if (entry instanceof CDirectorySourceLocation && property.equals(SourceLookupBlock.CP_ASSOCIATION) && value instanceof String && (association = new Path((String)value)).isValidPath((String)value)) {
                    ((CDirectorySourceLocation)entry).setAssociation((IPath)association);
                    SourceLookupBlock.this.getAddedSourceListField().refresh();
                    SourceLookupBlock.this.updateLaunchConfigurationDialog();
                }
            }
        };
    }

    public Control getControl() {
        return this.fControl;
    }

    public void initialize(ICSourceLocator locator) {
        this.fLocator = locator;
        if (this.fLocator != null) {
            ICSourceLocation[] locations = this.fLocator.getSourceLocations();
            this.initializeGeneratedLocations(this.fLocator.getProject(), locations);
            this.resetAdditionalLocations(locations);
        }
    }

    private void initializeGeneratedLocations(IProject project, ICSourceLocation[] locations) {
        boolean checked;
        this.fGeneratedSourceListField.removeAllElements();
        if (project == null && project.exists() && project.isOpen()) {
            return;
        }
        List list = CDebugUtils.getReferencedProjects((IProject)project);
        IProject[] refs = list.toArray(new IProject[list.size()]);
        ICSourceLocation loc = this.getLocationForProject(project, locations);
        boolean bl = checked = loc != null && ((IProjectSourceLocation)loc).isGeneric();
        if (loc == null) {
            loc = SourceLocationFactory.createProjectSourceLocation((IProject)project, (boolean)true);
        }
        this.fGeneratedSourceListField.addElement(loc);
        this.fGeneratedSourceListField.setChecked(loc, checked);
        int i = 0;
        while (i < refs.length) {
            loc = this.getLocationForProject(refs[i], locations);
            boolean bl2 = checked = loc != null;
            if (loc == null) {
                loc = SourceLocationFactory.createProjectSourceLocation((IProject)refs[i], (boolean)true);
            }
            this.fGeneratedSourceListField.addElement(loc);
            this.fGeneratedSourceListField.setChecked(loc, checked);
            ++i;
        }
    }

    private void resetGeneratedLocations(ICSourceLocation[] locations) {
        this.fGeneratedSourceListField.checkAll(false);
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof IProjectSourceLocation && ((IProjectSourceLocation)locations[i]).isGeneric()) {
                this.fGeneratedSourceListField.setChecked(locations[i], true);
            }
            ++i;
        }
    }

    private void resetAdditionalLocations(ICSourceLocation[] locations) {
        this.fAddedSourceListField.removeAllElements();
        int i = 0;
        while (i < locations.length) {
            if (!(locations[i] instanceof IProjectSourceLocation) || !((IProjectSourceLocation)locations[i]).isGeneric()) {
                this.fAddedSourceListField.addElement(locations[i]);
            }
            ++i;
        }
    }

    protected void doAddedSourceButtonPressed(int index) {
        switch (index) {
            case 0: {
                if (!this.addSourceLocation()) break;
                this.fIsDirty = true;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.fIsDirty = true;
            }
        }
        if (this.isDirty()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void doAddedSourceSelectionChanged() {
    }

    protected void doCheckStateChanged() {
        this.fIsDirty = true;
        this.updateLaunchConfigurationDialog();
    }

    protected void doGeneratedSourceButtonPressed(int index) {
        switch (index) {
            case 0: 
            case 1: {
                this.fIsDirty = true;
            }
        }
        if (this.isDirty()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void doGeneratedSourceSelectionChanged() {
    }

    public ICSourceLocation[] getSourceLocations() {
        ArrayList<IProjectSourceLocation> list = new ArrayList<IProjectSourceLocation>(this.getGeneratedSourceListField().getElements().size() + this.getAddedSourceListField().getElements().size());
        Iterator it = this.getGeneratedSourceListField().getElements().iterator();
        while (it.hasNext()) {
            IProjectSourceLocation location = (IProjectSourceLocation)it.next();
            if (!this.getGeneratedSourceListField().isChecked(location)) continue;
            list.add(location);
        }
        list.addAll(this.getAddedSourceListField().getElements());
        return list.toArray(new ICSourceLocation[list.size()]);
    }

    private boolean addSourceLocation() {
        AddSourceLocationWizard wizard = new AddSourceLocationWizard(this.getSourceLocations());
        WizardDialog dialog = new WizardDialog(this.fControl.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            this.fAddedSourceListField.addElement(wizard.getSourceLocation());
            return true;
        }
        return false;
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            this.getLaunchConfigurationDialog().updateMessage();
            this.getLaunchConfigurationDialog().updateButtons();
            this.fIsDirty = false;
        }
    }

    public ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fLaunchConfigurationDialog;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog launchConfigurationDialog) {
        this.fLaunchConfigurationDialog = launchConfigurationDialog;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    protected Object getSelection() {
        List list = this.fAddedSourceListField.getSelectedElements();
        return list.size() > 0 ? list.get(0) : null;
    }

    protected void restoreDefaults() {
        ICSourceLocation[] locations = new ICSourceLocation[]{};
        if (this.getProject() != null) {
            locations = CSourceLocator.getDefaultSourceLocations((IProject)this.getProject());
        }
        this.resetGeneratedLocations(locations);
        this.resetAdditionalLocations(locations);
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public SourceListDialogField getAddedSourceListField() {
        return this.fAddedSourceListField;
    }

    public CheckedListDialogField getGeneratedSourceListField() {
        return this.fGeneratedSourceListField;
    }

    private ICSourceLocation getLocationForProject(IProject project, ICSourceLocation[] locations) {
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof IProjectSourceLocation && project.equals((Object)((IProjectSourceLocation)locations[i]).getProject())) {
                return locations[i];
            }
            ++i;
        }
        return null;
    }

    private class SourceListDialogField
    extends ListDialogField {
        public SourceListDialogField(IListAdapter adapter, String[] buttonLabels, ILabelProvider lprovider) {
            super(adapter, buttonLabels, lprovider);
        }

        protected boolean managedButtonPressed(int index) {
            super.managedButtonPressed(index);
            return false;
        }

        protected TableViewer createTableViewer(Composite parent) {
            TableViewer viewer = super.createTableViewer(parent);
            Table table = viewer.getTable();
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            GridData gd = new GridData(272);
            gd.grabExcessVerticalSpace = true;
            gd.grabExcessHorizontalSpace = true;
            table.setLayoutData((Object)gd);
            table.setLinesVisible(true);
            table.setHeaderVisible(true);
            new TableColumn(table, 0);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
            new TableColumn(table, 0);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
            TableColumn[] columns = table.getColumns();
            columns[0].setText("Location");
            columns[1].setText("Association");
            return viewer;
        }
    }

    private static class SourceLookupLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        SourceLookupLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof IProjectSourceLocation) {
                    if (((IProjectSourceLocation)element).getProject().isOpen()) {
                        return CDebugImages.get("org.eclipse.cdt.debug.ui.project_obj.gif");
                    }
                    return CDebugImages.get("org.eclipse.cdt.debug.ui.cproject_obj.gif");
                }
                if (element instanceof IDirectorySourceLocation) {
                    return CDebugImages.get("org.eclipse.cdt.debug.ui.folder_obj.gif");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof IProjectSourceLocation) {
                    return ((IProjectSourceLocation)element).getProject().getName();
                }
                if (element instanceof IDirectorySourceLocation) {
                    return ((IDirectorySourceLocation)element).getDirectory().toOSString();
                }
            } else if (columnIndex == 1 && element instanceof IDirectorySourceLocation && ((IDirectorySourceLocation)element).getAssociation() != null) {
                return ((IDirectorySourceLocation)element).getAssociation().toOSString();
            }
            return "";
        }
    }
}

