/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.ui.CUIException;
import org.eclipse.cdt.internal.ui.CUIStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TemplateSet {
    private static final String TEMPLATE_TAG = "template";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String CONTEXT_ATTRIBUTE = "context";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private List fTemplates = new ArrayList();
    private Comparator fTemplateComparator = new TemplateComparator();
    private Template[] fSortedTemplates = new Template[0];

    public void addFromFile(File file) throws CoreException {
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(file);
                this.addFromStream(stream);
            }
            catch (IOException e) {
                TemplateSet.throwReadException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var4_6 = null;
        try {
            if (stream != null) {
                ((InputStream)stream).close();
            }
        }
        catch (IOException iOException) {}
    }

    public void addFromStream(InputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(new InputSource(stream));
            NodeList elements = document.getElementsByTagName(TEMPLATE_TAG);
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    String name = this.getAttributeValue(attributes, NAME_ATTRIBUTE);
                    String description = this.getAttributeValue(attributes, DESCRIPTION_ATTRIBUTE);
                    String context = this.getAttributeValue(attributes, CONTEXT_ATTRIBUTE);
                    Node enabledNode = attributes.getNamedItem(ENABLED_ATTRIBUTE);
                    if (name == null || description == null || context == null) {
                        throw new SAXException("Missing required attribute");
                    }
                    boolean enabled = enabledNode == null || enabledNode.getNodeValue().equals("true");
                    StringBuffer buffer = new StringBuffer();
                    NodeList children = node.getChildNodes();
                    int j = 0;
                    while (j != children.getLength()) {
                        String value = children.item(j).getNodeValue();
                        if (value != null) {
                            buffer.append(value);
                        }
                        ++j;
                    }
                    String pattern = buffer.toString().trim();
                    Template template = new Template(name, description, context, pattern);
                    template.setEnabled(enabled);
                    this.add(template);
                }
                ++i;
            }
            this.sort();
        }
        catch (ParserConfigurationException e) {
            TemplateSet.throwReadException(e);
        }
        catch (IOException e) {
            TemplateSet.throwReadException(e);
        }
        catch (SAXException e) {
            TemplateSet.throwReadException(e);
        }
    }

    private String getAttributeValue(NamedNodeMap attributes, String name) {
        Node node = attributes.getNamedItem(name);
        return node == null ? null : node.getNodeValue();
    }

    public void saveToFile(File file) throws CoreException {
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(file);
                this.saveToStream(stream);
            }
            catch (IOException e) {
                TemplateSet.throwWriteException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var4_6 = null;
        try {
            if (stream != null) {
                ((OutputStream)stream).close();
            }
        }
        catch (IOException iOException) {}
    }

    public void saveToStream(OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("templates");
            document.appendChild(root);
            int i = 0;
            while (i != this.fTemplates.size()) {
                Template template = (Template)this.fTemplates.get(i);
                Element node = document.createElement(TEMPLATE_TAG);
                root.appendChild(node);
                NamedNodeMap attributes = node.getAttributes();
                Attr name = document.createAttribute(NAME_ATTRIBUTE);
                name.setValue(template.getName());
                attributes.setNamedItem(name);
                Attr description = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                description.setValue(template.getDescription());
                attributes.setNamedItem(description);
                Attr context = document.createAttribute(CONTEXT_ATTRIBUTE);
                context.setValue(template.getContextTypeName());
                attributes.setNamedItem(context);
                Attr enabled = document.createAttribute(ENABLED_ATTRIBUTE);
                enabled.setValue(template.isEnabled() ? "true" : "false");
                attributes.setNamedItem(enabled);
                Text pattern = document.createTextNode(template.getPattern());
                node.appendChild(pattern);
                ++i;
            }
            OutputFormat format = new OutputFormat();
            format.setPreserveSpace(true);
            Serializer serializer = SerializerFactory.getSerializerFactory((String)"xml").makeSerializer(stream, format);
            serializer.asDOMSerializer().serialize(document);
        }
        catch (ParserConfigurationException e) {
            TemplateSet.throwWriteException(e);
        }
        catch (IOException e) {
            TemplateSet.throwWriteException(e);
        }
    }

    private static void throwReadException(Throwable t) throws CoreException {
        CUIStatus status = new CUIStatus(2, TemplateMessages.getString("TemplateSet.error.read"), t);
        throw new CUIException((IStatus)status);
    }

    private static void throwWriteException(Throwable t) throws CoreException {
        CUIStatus status = new CUIStatus(2, TemplateMessages.getString("TemplateSet.error.write"), t);
        throw new CUIException((IStatus)status);
    }

    public void add(Template template) {
        if (this.exists(template)) {
            return;
        }
        this.fTemplates.add(template);
        this.sort();
    }

    private boolean exists(Template template) {
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template anotherTemplate = (Template)iterator.next();
            if (!template.equals(anotherTemplate)) continue;
            return true;
        }
        return false;
    }

    public void remove(Template template) {
        this.fTemplates.remove(template);
        this.sort();
    }

    public void clear() {
        this.fTemplates.clear();
        this.sort();
    }

    public Template[] getTemplates() {
        return this.fTemplates.toArray(new Template[this.fTemplates.size()]);
    }

    private void sort() {
        this.fSortedTemplates = this.fTemplates.toArray(new Template[this.fTemplates.size()]);
        Arrays.sort(this.fSortedTemplates, this.fTemplateComparator);
    }

    private static class TemplateComparator
    implements Comparator {
        TemplateComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 == arg1) {
                return 0;
            }
            if (arg0 == null) {
                return -1;
            }
            Template template0 = (Template)arg0;
            Template template1 = (Template)arg1;
            return template0.getName().compareTo(template1.getName());
        }
    }
}

