/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import org.eclipse.jface.util.Assert;

public class TextUtil {
    public static int getLength(int start, int end) {
        return end - start + 1;
    }

    public static int getIndent(String line, int tabWidth) {
        int result = 0;
        int blanks = 0;
        int size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            switch (c) {
                case '\t': {
                    ++result;
                    blanks = 0;
                    break;
                }
                case ' ': {
                    if (++blanks != tabWidth) break;
                    ++result;
                    blanks = 0;
                    break;
                }
                default: {
                    return result;
                }
            }
            ++i;
        }
        return result;
    }

    public static String removeIndent(int numberOfIndents, String line, int tabWidth) {
        if (numberOfIndents <= 0) {
            return new String(line);
        }
        int start = 0;
        int indents = 0;
        int blanks = 0;
        int size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            switch (c) {
                case '\t': {
                    ++indents;
                    blanks = 0;
                    break;
                }
                case ' ': {
                    if (++blanks != tabWidth) break;
                    ++indents;
                    blanks = 0;
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Line does not have requested number of indents");
                }
            }
            if (indents == numberOfIndents) {
                start = i + 1;
                break;
            }
            ++i;
        }
        if (start == size) {
            return "";
        }
        return line.substring(start);
    }

    public static String removeLeadingIndents(String line, int tabWidth) {
        int indents = TextUtil.getIndent(line, tabWidth);
        return TextUtil.removeIndent(indents, line, tabWidth);
    }

    public static String createIndentString(int indent) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < indent) {
            result.append('\t');
            ++i;
        }
        return result.toString();
    }

    public static String removeLeadingWhiteSpaces(String line) {
        int size = line.length();
        int start = 0;
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c != '\t' && c != ' ') {
                start = i;
                break;
            }
            ++i;
        }
        return line.substring(start);
    }

    public static boolean containsOnlyWhiteSpaces(String line) {
        int size = line.length();
        int i = 0;
        while (i < size) {
            char c = line.charAt(i);
            if (c != '\t' && c != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }
}

