/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class CElementFilters {
    static List definedFilters = null;
    static List defaultFilters = null;
    static StringMatcher[] matchers = null;
    static String FILTERS_TAG = "CElementFilters";
    static String COMMA_SEPARATOR = ",";

    public static List getDefaultFilters() {
        if (defaultFilters == null) {
            CElementFilters.readFilters();
        }
        return defaultFilters;
    }

    public static List getDefinedFilters() {
        if (definedFilters == null) {
            CUIPlugin plugin = CUIPlugin.getDefault();
            String storedPatterns = plugin.getPluginPreferences().getString(FILTERS_TAG);
            if (storedPatterns.length() > 0) {
                StringTokenizer entries = new StringTokenizer(storedPatterns, COMMA_SEPARATOR);
                definedFilters = new ArrayList();
                while (entries.hasMoreElements()) {
                    String nextToken = entries.nextToken();
                    definedFilters.add(nextToken);
                }
            } else {
                CElementFilters.readFilters();
            }
        }
        return definedFilters;
    }

    public static StringMatcher[] getMatchers() {
        if (matchers == null) {
            List list = CElementFilters.getDefinedFilters();
            matchers = new StringMatcher[list.size()];
            int i = 0;
            while (i < matchers.length) {
                CElementFilters.matchers[i] = new StringMatcher((String)list.get(i), true, false);
                ++i;
            }
        }
        return matchers;
    }

    public static void setPatterns(String[] newPatterns) {
        matchers = new StringMatcher[newPatterns.length];
        int i = 0;
        while (i < newPatterns.length) {
            CElementFilters.matchers[i] = new StringMatcher(newPatterns[i], true, false);
            ++i;
        }
    }

    public static boolean match(String name) {
        StringMatcher[] m = CElementFilters.getMatchers();
        if (m == null) {
            return false;
        }
        int i = 0;
        while (i < m.length) {
            if (m[i].match(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private CElementFilters() {
    }

    static void readFilters() {
        IExtensionPoint extension;
        definedFilters = new ArrayList();
        defaultFilters = new ArrayList();
        CUIPlugin plugin = CUIPlugin.getDefault();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint(FILTERS_TAG)) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String selected;
                    String pattern = configElements[j].getAttribute("pattern");
                    if (pattern != null) {
                        definedFilters.add(pattern);
                    }
                    if ((selected = configElements[j].getAttribute("selected")) != null && selected.equalsIgnoreCase("true")) {
                        defaultFilters.add(pattern);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

