/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.internal.ui.CCompletionContributorManager;
import org.eclipse.cdt.internal.ui.CFileElementWorkingCopy;
import org.eclipse.cdt.internal.ui.codemanipulation.AddIncludeOperation;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.IRequiredInclude;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class AddIncludeOnSelectionAction
extends Action
implements IUpdate {
    private ITextEditor fEditor;

    public AddIncludeOnSelectionAction() {
        this(null);
    }

    public AddIncludeOnSelectionAction(ITextEditor editor) {
        super(CEditorMessages.getString("AddIncludeOnSelection.label"));
        this.setToolTipText(CEditorMessages.getString("AddIncludeOnSelection.tooltip"));
        this.setDescription(CEditorMessages.getString("AddIncludeOnSelection.description"));
        this.fEditor = editor;
    }

    private void addInclude(IRequiredInclude[] inc, CFileElementWorkingCopy tu) {
        AddIncludeOperation op = new AddIncludeOperation(this.fEditor, tu, inc, false);
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            dialog.run(false, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)CEditorMessages.getString("AddIncludeOnSelection.error.message1"), (String)e.getTargetException().getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private CFileElementWorkingCopy getTranslationUnit() {
        CFileElementWorkingCopy unit;
        block5: {
            unit = null;
            if (this.fEditor != null) {
                IEditorInput editorInput = this.fEditor.getEditorInput();
                IDocumentProvider provider = this.fEditor.getDocumentProvider();
                try {
                    if (editorInput instanceof IFileEditorInput) {
                        unit = new CFileElementWorkingCopy((IStorageEditorInput)((IFileEditorInput)editorInput), provider);
                        break block5;
                    }
                    if (editorInput instanceof IStorageEditorInput) {
                        unit = new CFileElementWorkingCopy((IStorageEditorInput)editorInput, provider);
                        break block5;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, "no Editor Input", null));
                }
                catch (CoreException e) {
                    CUIPlugin.getDefault().log(e.getStatus());
                }
            }
        }
        return unit;
    }

    protected Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    private int getNameStart(IDocument doc, int pos) throws BadLocationException {
        if (pos > 0 && doc.getChar(pos - 1) == '.') {
            --pos;
            while (pos > 0) {
                char ch = doc.getChar(pos - 1);
                if (!Character.isJavaIdentifierPart(ch) && ch != '.') {
                    return pos;
                }
                --pos;
            }
        }
        return pos;
    }

    public void run() {
        CFileElementWorkingCopy tu = this.getTranslationUnit();
        if (tu != null) {
            ISelection s = this.fEditor.getSelectionProvider().getSelection();
            IDocument doc = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
            if (!s.isEmpty() && doc != null) {
                ITextSelection selection = (ITextSelection)s;
                try {
                    IRequiredInclude[] ri;
                    int selStart = selection.getOffset();
                    int nameStart = this.getNameStart(doc, selStart);
                    int len = selStart - nameStart + selection.getLength();
                    String name = doc.get(nameStart, len).trim();
                    IFunctionSummary fs = CCompletionContributorManager.getDefault().getFunctionInfo(name);
                    if (fs != null && (ri = fs.getIncludes()) != null && ri.length > 0) {
                        this.addInclude(ri, tu);
                        return;
                    }
                }
                catch (BadLocationException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)CEditorMessages.getString("AddIncludeOnSelection.error.message3"), (String)(String.valueOf(CEditorMessages.getString("AddIncludeOnSelection.error.message4")) + e.getMessage()));
                }
            }
        }
        this.getShell().getDisplay().beep();
    }

    public void setContentEditor(ITextEditor editor) {
        this.fEditor = editor;
    }

    public void update() {
        ISelection selection = this.fEditor.getSelectionProvider().getSelection();
        this.setEnabled(!selection.isEmpty());
    }
}

