/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.swt;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.cdt.internal.ui.wizards.swt.MGridData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class MGridLayout
extends Layout {
    public int marginWidth = 5;
    public int marginHeight = 5;
    public int numColumns = 1;
    public boolean makeColumnsEqualWidth = false;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    public int minimumWidth = -1;
    public int minimumHeight = -1;
    public String id;
    boolean initialLayout = true;
    Vector grid = new Vector();
    int[] pixelColumnWidths;
    int[] pixelRowHeights;
    int[] expandableColumns;
    int[] expandableRows;

    void adjustGridDimensions(Composite composite, boolean flushCache) {
        int row = 0;
        while (row < this.grid.size()) {
            int column = 0;
            while (column < this.numColumns) {
                MGridData spec = ((MGridData[])this.grid.elementAt(row))[column];
                if (spec.isItemData()) {
                    int i;
                    int j;
                    int i2;
                    int extraSpaceNeeded;
                    int spannedSize;
                    int lastSpanIndex;
                    Point extent;
                    Control child;
                    if (spec.horizontalSpan > 1) {
                        child = composite.getChildren()[spec.childIndex];
                        extent = child.computeSize(spec.widthHint, spec.heightHint, flushCache);
                        lastSpanIndex = column + spec.horizontalSpan;
                        spannedSize = 0;
                        int c = column;
                        while (c < lastSpanIndex) {
                            spannedSize = spannedSize + this.pixelColumnWidths[c] + this.horizontalSpacing;
                            ++c;
                        }
                        if (extent.x + spec.horizontalIndent > (spannedSize -= this.horizontalSpacing)) {
                            int colWidth;
                            extraSpaceNeeded = extent.x + spec.horizontalIndent - spannedSize;
                            int lastColumn = column + spec.horizontalSpan - 1;
                            if (this.makeColumnsEqualWidth) {
                                int columnExtra = extraSpaceNeeded / this.numColumns;
                                int columnRemainder = extraSpaceNeeded % this.numColumns;
                                int i3 = 0;
                                while (i3 < this.pixelColumnWidths.length) {
                                    this.pixelColumnWidths[i3] = colWidth = this.pixelColumnWidths[i3] + columnExtra;
                                    ++i3;
                                }
                                this.pixelColumnWidths[lastColumn] = colWidth = this.pixelColumnWidths[lastColumn] + columnRemainder;
                            } else {
                                Vector<Integer> localExpandableColumns = new Vector<Integer>();
                                i2 = column;
                                while (i2 < lastColumn) {
                                    j = 0;
                                    while (j < this.expandableColumns.length) {
                                        if (this.expandableColumns[j] == i2) {
                                            localExpandableColumns.addElement(new Integer(i2));
                                        }
                                        ++j;
                                    }
                                    ++i2;
                                }
                                if (localExpandableColumns.size() > 0) {
                                    int columnExtra = extraSpaceNeeded / localExpandableColumns.size();
                                    int columnRemainder = extraSpaceNeeded % localExpandableColumns.size();
                                    i = 0;
                                    while (i < localExpandableColumns.size()) {
                                        int expandableCol = (Integer)localExpandableColumns.elementAt(i);
                                        this.pixelColumnWidths[expandableCol] = colWidth = this.pixelColumnWidths[expandableCol] + columnExtra;
                                        ++i;
                                    }
                                    this.pixelColumnWidths[lastColumn] = colWidth = this.pixelColumnWidths[lastColumn] + columnRemainder;
                                } else {
                                    this.pixelColumnWidths[lastColumn] = colWidth = this.pixelColumnWidths[lastColumn] + extraSpaceNeeded;
                                }
                            }
                        }
                    }
                    if (spec.verticalSpan > 1) {
                        child = composite.getChildren()[spec.childIndex];
                        extent = child.computeSize(spec.widthHint, spec.heightHint, flushCache);
                        lastSpanIndex = row + spec.verticalSpan;
                        spannedSize = 0;
                        int r = row;
                        while (r < lastSpanIndex) {
                            spannedSize = spannedSize + this.pixelRowHeights[r] + this.verticalSpacing;
                            ++r;
                        }
                        if (extent.y > (spannedSize -= this.verticalSpacing)) {
                            int rowHeight;
                            extraSpaceNeeded = extent.y - spannedSize;
                            int lastRow = row + spec.verticalSpan - 1;
                            Vector<Integer> localExpandableRows = new Vector<Integer>();
                            i2 = row;
                            while (i2 < lastRow) {
                                j = 0;
                                while (j < this.expandableRows.length) {
                                    if (this.expandableRows[j] == i2) {
                                        localExpandableRows.addElement(new Integer(i2));
                                    }
                                    ++j;
                                }
                                ++i2;
                            }
                            if (localExpandableRows.size() > 0) {
                                int rowExtra = extraSpaceNeeded / localExpandableRows.size();
                                int rowRemainder = extraSpaceNeeded % localExpandableRows.size();
                                i = 0;
                                while (i < localExpandableRows.size()) {
                                    int expandableRow = (Integer)localExpandableRows.elementAt(i);
                                    this.pixelRowHeights[expandableRow] = rowHeight = this.pixelRowHeights[expandableRow] + rowExtra;
                                    ++i;
                                }
                                this.pixelRowHeights[lastRow] = rowHeight = this.pixelRowHeights[lastRow] + rowRemainder;
                            } else {
                                this.pixelRowHeights[lastRow] = rowHeight = this.pixelRowHeights[lastRow] + extraSpaceNeeded;
                            }
                        }
                    }
                }
                ++column;
            }
            ++row;
        }
    }

    void calculateGridDimensions(Composite composite, boolean flushCache) {
        MGridData spec;
        int maxWidth;
        Control[] children = composite.getChildren();
        Point[] childSizes = new Point[children.length];
        this.pixelColumnWidths = new int[this.numColumns];
        this.pixelRowHeights = new int[this.grid.size()];
        int column = 0;
        while (column < this.numColumns) {
            maxWidth = 0;
            int row = 0;
            while (row < this.grid.size()) {
                spec = ((MGridData[])this.grid.elementAt(row))[column];
                if (spec.isItemData()) {
                    Control child = children[spec.childIndex];
                    childSizes[spec.childIndex] = child.computeSize(spec.widthHint, spec.heightHint, flushCache);
                    int childWidth = childSizes[spec.childIndex].x + spec.horizontalIndent;
                    if (spec.horizontalSpan == 1) {
                        maxWidth = Math.max(maxWidth, childWidth);
                    }
                }
                ++row;
            }
            this.pixelColumnWidths[column] = maxWidth;
            ++column;
        }
        if (this.makeColumnsEqualWidth) {
            maxWidth = 0;
            int i = 0;
            while (i < this.numColumns) {
                maxWidth = Math.max(maxWidth, this.pixelColumnWidths[i]);
                ++i;
            }
            i = 0;
            while (i < this.numColumns) {
                this.pixelColumnWidths[i] = maxWidth;
                ++i;
            }
        }
        int row = 0;
        while (row < this.grid.size()) {
            int maxHeight = 0;
            int column2 = 0;
            while (column2 < this.numColumns) {
                spec = ((MGridData[])this.grid.elementAt(row))[column2];
                if (spec.isItemData()) {
                    int childHeight = childSizes[spec.childIndex].y;
                    if (spec.verticalSpan == 1) {
                        maxHeight = Math.max(maxHeight, childHeight);
                    }
                }
                ++column2;
            }
            this.pixelRowHeights[row] = maxHeight;
            ++row;
        }
    }

    void computeExpandableCells() {
        Hashtable<Integer, Object> growColumns = new Hashtable<Integer, Object>();
        Hashtable<Integer, Object> growRows = new Hashtable<Integer, Object>();
        int col = 0;
        while (col < this.numColumns) {
            int row = 0;
            while (row < this.grid.size()) {
                MGridData spec = ((MGridData[])this.grid.elementAt(row))[col];
                if (spec.grabExcessHorizontalSpace) {
                    if (spec.grabColumn >= 0 && spec.grabColumn < spec.horizontalSpan) {
                        growColumns.put(new Integer(col + spec.grabColumn), new Object());
                    } else {
                        growColumns.put(new Integer(col + spec.horizontalSpan - 1), new Object());
                    }
                }
                if (spec.grabExcessVerticalSpace) {
                    if (spec.grabRow >= 0 && spec.grabRow < spec.verticalSpan) {
                        growRows.put(new Integer(row + spec.grabRow), new Object());
                    } else {
                        growRows.put(new Integer(row + spec.verticalSpan - 1), new Object());
                    }
                }
                ++row;
            }
            ++col;
        }
        int i = 0;
        Enumeration enumeration = growColumns.keys();
        this.expandableColumns = new int[growColumns.size()];
        while (enumeration.hasMoreElements()) {
            this.expandableColumns[i] = (Integer)enumeration.nextElement();
            ++i;
        }
        i = 0;
        enumeration = growRows.keys();
        this.expandableRows = new int[growRows.size()];
        while (enumeration.hasMoreElements()) {
            this.expandableRows[i] = (Integer)enumeration.nextElement();
            ++i;
        }
    }

    Point computeLayoutSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (this.grid.size() == 0) {
            this.createGrid(composite);
            this.calculateGridDimensions(composite, flushCache);
            this.computeExpandableCells();
            this.adjustGridDimensions(composite, flushCache);
        }
        int cols = this.numColumns;
        int rows = this.grid.size();
        int totalMarginHeight = this.marginHeight + composite.getBorderWidth();
        int totalMarginWidth = this.marginWidth + composite.getBorderWidth();
        int totalWidth = totalMarginWidth * 2 + (cols - 1) * this.horizontalSpacing;
        int i = 0;
        while (i < this.pixelColumnWidths.length) {
            totalWidth += this.pixelColumnWidths[i];
            ++i;
        }
        int totalHeight = totalMarginHeight * 2 + (rows - 1) * this.verticalSpacing;
        i = 0;
        while (i < this.pixelRowHeights.length) {
            totalHeight += this.pixelRowHeights[i];
            ++i;
        }
        if (wHint != -1) {
            totalWidth = wHint;
        }
        if (hHint != -1) {
            totalHeight = hHint;
        }
        return new Point(totalWidth, totalHeight);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (composite.getChildren().length == 0) {
            return new Point(0, 0);
        }
        if (flushCache) {
            this.initialLayout = true;
        }
        if (this.initialLayout) {
            this.initializeLayoutData(composite);
            this.initialLayout = false;
        }
        if (flushCache) {
            this.grid.removeAllElements();
        }
        Point size = this.computeLayoutSize(composite, wHint, hHint, flushCache);
        if (this.minimumWidth != -1 && size.x < this.minimumWidth) {
            size.x = this.minimumWidth;
        }
        if (this.minimumHeight != -1 && size.y < this.minimumHeight) {
            size.y = this.minimumHeight;
        }
        return size;
    }

    void createGrid(Composite composite) {
        MGridData spacerSpec;
        Control[] children = composite.getChildren();
        this.grid.addElement(this.emptyRow());
        int row = 0;
        int column = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            MGridData spec = (MGridData)child.getLayoutData();
            while (((MGridData[])this.grid.elementAt(row))[column] != null) {
                if (++column < this.numColumns) continue;
                column = 0;
                if (++row < this.grid.size()) continue;
                this.grid.addElement(this.emptyRow());
            }
            if (column + spec.horizontalSpan - 1 >= this.numColumns) {
                this.grid.addElement(this.emptyRow());
                ++row;
                column = 0;
            }
            int j = 2;
            while (j <= spec.verticalSpan) {
                if (row + j > this.grid.size()) {
                    this.grid.addElement(this.emptyRow());
                }
                ++j;
            }
            ((MGridData[])this.grid.elementAt((int)row))[column] = spec;
            spec.childIndex = i;
            int rowFill = spec.verticalSpan - 1;
            int columnFill = spec.horizontalSpan - 1;
            int r = 1;
            while (r <= rowFill) {
                int c = 0;
                while (c < spec.horizontalSpan) {
                    spacerSpec = new MGridData();
                    spacerSpec.isItemData = false;
                    ((MGridData[])this.grid.elementAt((int)(row + r)))[column + c] = spacerSpec;
                    ++c;
                }
                ++r;
            }
            int c = 1;
            while (c <= columnFill) {
                int r2 = 0;
                while (r2 < spec.verticalSpan) {
                    spacerSpec = new MGridData();
                    spacerSpec.isItemData = false;
                    ((MGridData[])this.grid.elementAt((int)(row + r2)))[column + c] = spacerSpec;
                    ++r2;
                }
                ++c;
            }
            column = column + spec.horizontalSpan - 1;
            ++i;
        }
        int k = column + 1;
        while (k < this.numColumns) {
            spacerSpec = new MGridData();
            spacerSpec.isItemData = false;
            ((MGridData[])this.grid.elementAt((int)row))[k] = spacerSpec;
            ++k;
        }
        k = row + 1;
        while (k < this.grid.size()) {
            spacerSpec = new MGridData();
            spacerSpec.isItemData = false;
            ((MGridData[])this.grid.elementAt((int)k))[column] = spacerSpec;
            ++k;
        }
    }

    MGridData[] emptyRow() {
        MGridData[] row = new MGridData[this.numColumns];
        int i = 0;
        while (i < this.numColumns) {
            row[i] = null;
            ++i;
        }
        return row;
    }

    void initializeLayoutData(Composite composite) {
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.getLayoutData() == null) {
                child.setLayoutData((Object)new MGridData());
            }
            ++i;
        }
    }

    protected void layout(Composite composite, boolean flushCache) {
        MGridData spec;
        int i;
        int last;
        int remainder;
        int excess;
        Control[] children;
        if (flushCache) {
            this.grid.removeAllElements();
        }
        if ((children = composite.getChildren()).length == 0) {
            return;
        }
        Point extent = this.computeLayoutSize(composite, -1, -1, flushCache);
        int[] columnWidths = new int[this.numColumns];
        int i2 = 0;
        while (i2 < this.pixelColumnWidths.length) {
            columnWidths[i2] = this.pixelColumnWidths[i2];
            ++i2;
        }
        int[] rowHeights = new int[this.grid.size()];
        i2 = 0;
        while (i2 < this.pixelRowHeights.length) {
            rowHeights[i2] = this.pixelRowHeights[i2];
            ++i2;
        }
        int columnWidth = 0;
        int rowSize = Math.max(1, this.grid.size());
        int compositeWidth = extent.x;
        int compositeHeight = extent.y;
        int excessHorizontal = composite.getClientArea().width - compositeWidth;
        int excessVertical = composite.getClientArea().height - compositeHeight;
        if (this.expandableColumns.length != 0) {
            int colWidth;
            excess = excessHorizontal / this.expandableColumns.length;
            remainder = excessHorizontal % this.expandableColumns.length;
            last = 0;
            i = 0;
            while (i < this.expandableColumns.length) {
                int expandableCol = this.expandableColumns[i];
                colWidth = columnWidths[expandableCol];
                columnWidths[expandableCol] = colWidth += excess;
                last = Math.max(last, expandableCol);
                ++i;
            }
            colWidth = columnWidths[last];
            columnWidths[last] = colWidth += remainder;
        }
        int i3 = 0;
        while (i3 < this.expandableColumns.length) {
            int expandableCol = this.expandableColumns[i3];
            int colWidth = columnWidths[expandableCol];
            int minWidth = 0;
            int j = 0;
            while (j < this.grid.size()) {
                MGridData[] row = (MGridData[])this.grid.elementAt(j);
                spec = row[expandableCol];
                minWidth = Math.max(minWidth, spec.widthHint);
                ++j;
            }
            columnWidths[expandableCol] = Math.max(colWidth, minWidth);
            ++i3;
        }
        if (this.expandableRows.length != 0) {
            int rowHeight;
            excess = excessVertical / this.expandableRows.length;
            remainder = excessVertical % this.expandableRows.length;
            last = 0;
            i = 0;
            while (i < this.expandableRows.length) {
                int expandableRow = this.expandableRows[i];
                rowHeight = rowHeights[expandableRow];
                rowHeights[expandableRow] = rowHeight += excess;
                last = Math.max(last, expandableRow);
                ++i;
            }
            rowHeight = rowHeights[last];
            rowHeights[last] = rowHeight += remainder;
        }
        i3 = 0;
        while (i3 < this.expandableRows.length) {
            int expandableRow = this.expandableRows[i3];
            int rowHeight = rowHeights[expandableRow];
            int minHeight = 0;
            MGridData[] row = (MGridData[])this.grid.elementAt(expandableRow);
            int j = 0;
            while (j < this.numColumns) {
                spec = row[j];
                minHeight = Math.max(minHeight, spec.heightHint);
                ++j;
            }
            rowHeights[expandableRow] = Math.max(rowHeight, minHeight);
            ++i3;
        }
        int columnX = this.marginWidth + composite.getBorderWidth() + composite.getClientArea().x;
        int rowY = this.marginHeight + composite.getBorderWidth() + composite.getClientArea().y;
        int r = 0;
        while (r < rowSize) {
            int rowHeight = rowHeights[r];
            MGridData[] row = (MGridData[])this.grid.elementAt(r);
            int c = 0;
            while (c < row.length) {
                int spannedWidth = 0;
                int spannedHeight = 0;
                int hAlign = 0;
                int vAlign = 0;
                int widgetX = 0;
                int widgetY = 0;
                int widgetW = 0;
                int widgetH = 0;
                MGridData spec2 = row[c];
                if (this.makeColumnsEqualWidth) {
                    columnWidth = composite.getBounds().width - (this.marginWidth + composite.getBorderWidth()) * 2 - (this.numColumns - 1) * this.horizontalSpacing;
                    columnWidth /= this.numColumns;
                    int i4 = 0;
                    while (i4 < columnWidths.length) {
                        columnWidths[i4] = columnWidth;
                        ++i4;
                    }
                } else {
                    columnWidth = columnWidths[c];
                }
                spannedWidth = columnWidth;
                int k = 1;
                while (k < spec2.horizontalSpan) {
                    if (c + k <= this.numColumns) {
                        if (!this.makeColumnsEqualWidth) {
                            columnWidth = columnWidths[c + k];
                        }
                        spannedWidth = spannedWidth + columnWidth + this.horizontalSpacing;
                    }
                    ++k;
                }
                spannedHeight = rowHeight;
                k = 1;
                while (k < spec2.verticalSpan) {
                    if (r + k <= this.grid.size()) {
                        spannedHeight = spannedHeight + rowHeights[r + k] + this.verticalSpacing;
                    }
                    ++k;
                }
                if (spec2.isItemData()) {
                    Control child = children[spec2.childIndex];
                    Point childExtent = child.computeSize(spec2.widthHint, spec2.heightHint, flushCache);
                    hAlign = spec2.horizontalAlignment;
                    widgetX = columnX;
                    widgetX = hAlign == 2 ? widgetX + spannedWidth / 2 - childExtent.x / 2 : (hAlign == 3 ? widgetX + spannedWidth - childExtent.x - spec2.horizontalIndent : (widgetX += spec2.horizontalIndent));
                    if (hAlign == 4) {
                        widgetW = spannedWidth - spec2.horizontalIndent;
                        widgetX = columnX + spec2.horizontalIndent;
                    } else {
                        widgetW = childExtent.x;
                    }
                    vAlign = spec2.verticalAlignment;
                    widgetY = rowY;
                    if (vAlign == 2) {
                        widgetY = widgetY + spannedHeight / 2 - childExtent.y / 2;
                    } else if (vAlign == 3) {
                        widgetY = widgetY + spannedHeight - childExtent.y;
                    }
                    if (vAlign == 4) {
                        widgetH = spannedHeight;
                        widgetY = rowY;
                    } else {
                        widgetH = childExtent.y;
                    }
                    child.setBounds(widgetX, widgetY, widgetW, widgetH);
                }
                columnX = columnX + columnWidths[c] + this.horizontalSpacing;
                ++c;
            }
            rowY = rowY + rowHeights[r] + this.verticalSpacing;
            columnX = this.marginWidth + composite.getBorderWidth() + composite.getClientArea().x;
            ++r;
        }
    }
}

