/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.ui.ISearchResultViewEntry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CSearchResultLabelProvider
extends LabelProvider {
    public static final int SHOW_NAME_ONLY = 0;
    public static final int SHOW_ELEMENT_CONTAINER = 1;
    public static final int SHOW_CONTAINER_ELEMENT = 2;
    public static final int SHOW_PATH = 3;
    public static final String POTENTIAL_MATCH = CSearchMessages.getString("CSearchResultLabelProvider.potentialMatch");
    private int _sortOrder = 3;
    private int _textFlags;
    private int _imageFlags;
    private static final Point SMALL_SIZE = new Point(16, 16);

    public Image getImage(Object element) {
        IMatch match = null;
        if (element instanceof ISearchResultViewEntry) {
            ISearchResultViewEntry viewEntry = (ISearchResultViewEntry)element;
            IMarker marker = viewEntry.getSelectedMarker();
            try {
                match = (IMatch)marker.getAttribute("IMatchObject");
            }
            catch (CoreException coreException) {
                return null;
            }
        } else if (element instanceof IMatch) {
            match = (IMatch)element;
        }
        if (match == null) {
            return null;
        }
        Object imageDescriptor = null;
        block1 : switch (match.getElementType()) {
            case 64: {
                imageDescriptor = CPluginImages.DESC_OBJS_CLASS;
                break;
            }
            case 65: {
                imageDescriptor = CPluginImages.DESC_OBJS_STRUCT;
                break;
            }
            case 66: {
                imageDescriptor = CPluginImages.DESC_OBJS_UNION;
                break;
            }
            case 61: {
                imageDescriptor = CPluginImages.DESC_OBJS_CONTAINER;
                break;
            }
            case 63: {
                imageDescriptor = CPluginImages.DESC_OBJS_ENUMERATION;
                break;
            }
            case 77: {
                imageDescriptor = CPluginImages.DESC_OBJS_MACRO;
                break;
            }
            case 71: {
                imageDescriptor = CPluginImages.DESC_OBJS_FUNCTION;
                break;
            }
            case 74: {
                imageDescriptor = CPluginImages.DESC_OBJS_FIELD;
                break;
            }
            case 79: {
                imageDescriptor = CPluginImages.DESC_OBJS_ENUMERATOR;
                break;
            }
            case 78: {
                imageDescriptor = CPluginImages.DESC_OBJS_TYPEDEF;
                break;
            }
            case 69: {
                switch (match.getVisibility()) {
                    case 8192: {
                        imageDescriptor = CPluginImages.DESC_OBJS_PUBLIC_FIELD;
                        break block1;
                    }
                    case 4096: {
                        imageDescriptor = CPluginImages.DESC_OBJS_PRIVATE_FIELD;
                        break block1;
                    }
                }
                imageDescriptor = CPluginImages.DESC_OBJS_PROTECTED_FIELD;
                break;
            }
            case 67: {
                switch (match.getVisibility()) {
                    case 8192: {
                        imageDescriptor = CPluginImages.DESC_OBJS_PUBLIC_METHOD;
                        break block1;
                    }
                    case 4096: {
                        imageDescriptor = CPluginImages.DESC_OBJS_PRIVATE_METHOD;
                        break block1;
                    }
                }
                imageDescriptor = CPluginImages.DESC_OBJS_PROTECTED_METHOD;
            }
        }
        int flags = 0;
        if (match.isStatic()) {
            flags |= 8;
        }
        if (match.isConst()) {
            flags |= 2;
        }
        if (match.isVolatile()) {
            flags |= 4;
        }
        imageDescriptor = new CElementImageDescriptor((ImageDescriptor)imageDescriptor, flags, SMALL_SIZE);
        Image image = CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)imageDescriptor);
        return image;
    }

    public String getText(Object element) {
        IMatch match = null;
        if (element instanceof ISearchResultViewEntry) {
            ISearchResultViewEntry viewEntry = (ISearchResultViewEntry)element;
            IMarker marker = viewEntry.getSelectedMarker();
            try {
                match = (IMatch)marker.getAttribute("IMatchObject");
            }
            catch (CoreException coreException) {
                return "";
            }
        } else if (element instanceof IMatch) {
            match = (IMatch)element;
        }
        if (match == null) {
            return "";
        }
        IResource resource = match.getResource();
        String result = "";
        String path = resource != null ? resource.getFullPath().toString() : "";
        switch (this.getOrder()) {
            case 0: {
                result = match.getName();
            }
            case 1: {
                if (!match.getParentName().equals("")) {
                    result = String.valueOf(match.getName()) + " - " + match.getParentName() + " ( " + path + " )";
                    break;
                }
                result = String.valueOf(match.getName()) + " ( " + path + " )";
                break;
            }
            case 3: {
                result = String.valueOf(path) + " - " + match.getParentName() + "::" + match.getName();
                break;
            }
            case 2: {
                result = String.valueOf(match.getParentName()) + "::" + match.getName() + " ( " + path + " )";
            }
        }
        return result;
    }

    public int getOrder() {
        return this._sortOrder;
    }

    public void setOrder(int orderFlag) {
        this._sortOrder = orderFlag;
    }
}

