/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractBinaryParserPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class BinaryParserBlock
extends AbstractBinaryParserPage {
    private static final String PREFIX = "BinaryParserBlock";
    private static final String LABEL = "BinaryParserBlock.label";
    private static final String DESC = "BinaryParserBlock.desc";
    private static String[][] radios;
    protected Combo comboBox;
    private HashMap idMap = new HashMap();
    private String initial;
    private Preferences fPrefs;

    public BinaryParserBlock(Preferences prefs) {
        super(CUIPlugin.getResourceString(LABEL));
        this.setDescription(CUIPlugin.getResourceString(DESC));
        this.fPrefs = prefs;
    }

    public void createControl(Composite parent) {
        Composite control = ControlFactory.createComposite(parent, 2);
        ((GridLayout)control.getLayout()).makeColumnsEqualWidth = false;
        ((GridLayout)control.getLayout()).marginWidth = 5;
        this.setControl((Control)control);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.ui.cdt_binary_parser_page");
        ControlFactory.createEmptySpace(control, 2);
        Label label = ControlFactory.createLabel(control, "Binary Parser:");
        label.setLayoutData((Object)new GridData());
        this.comboBox = new Combo(control, 12);
        GridData gd = new GridData(512);
        gd.grabExcessHorizontalSpace = true;
        this.comboBox.setLayoutData((Object)gd);
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BinaryParserBlock.this.getContainer().updateContainer();
                BinaryParserBlock.this.handleBinaryParserChanged();
            }
        });
        Iterator items = this.idMap.keySet().iterator();
        while (items.hasNext()) {
            this.comboBox.add((String)items.next());
        }
        if (this.initial != null) {
            this.comboBox.setText(this.initial);
        }
        Group parserGroup = new Group(control, 16);
        parserGroup.setText("Binary Parser Options");
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        parserGroup.setLayout((Layout)tabHolderLayout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        parserGroup.setLayoutData((Object)gd);
        this.setCompositeParent((Composite)parserGroup);
        this.handleBinaryParserChanged();
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Setting Binary Parser...", 2);
        String selected = this.comboBox.getText();
        if (!(selected == null || this.initial != null && selected.equals(this.initial))) {
            if (this.getContainer().getProject() != null) {
                ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(this.getContainer().getProject());
                desc.remove("org.eclipse.cdt.core.BinaryParser");
                desc.create("org.eclipse.cdt.core.BinaryParser", (String)this.idMap.get(selected));
                CCorePlugin.getDefault().getCoreModel().resetBinaryParser(this.getContainer().getProject());
            } else {
                this.fPrefs.setValue("binaryparser", (String)this.idMap.get(selected));
            }
            this.initial = selected;
        }
        monitor.worked(1);
        super.performApply((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    public void setContainer(ICOptionContainer container) {
        super.setContainer(container);
        IExtensionPoint point = CCorePlugin.getDefault().getDescriptor().getExtensionPoint("BinaryParser");
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            radios = new String[exts.length][2];
            int i = 0;
            while (i < exts.length) {
                this.idMap.put(exts[i].getLabel(), exts[i].getUniqueIdentifier());
                ++i;
            }
        }
        if (this.getContainer().getProject() != null) {
            try {
                ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(this.getContainer().getProject());
                ICExtensionReference[] ref = desc.get("org.eclipse.cdt.core.BinaryParser");
                if (ref.length > 0) {
                    this.initial = point.getExtension(ref[0].getID()).getLabel();
                }
            }
            catch (CoreException coreException) {}
        }
        if (this.initial == null) {
            String id = this.fPrefs.getString("binaryparser");
            this.initial = id == null || id.length() == 0 ? point.getExtension("org.eclipse.cdt.core.ELF").getLabel() : point.getExtension(id).getLabel();
        }
    }

    public void performDefaults() {
        IExtensionPoint point = CCorePlugin.getDefault().getDescriptor().getExtensionPoint("BinaryParser");
        String id = this.getContainer().getProject() != null ? this.fPrefs.getString("binaryparser") : this.fPrefs.getDefaultString("binaryparser");
        String selected = id == null || id.length() == 0 ? point.getExtension("org.eclipse.cdt.core.ELF").getLabel() : point.getExtension(id).getLabel();
        this.comboBox.setText(selected);
        this.handleBinaryParserChanged();
        this.getContainer().updateContainer();
    }

    protected String getCurrentBinaryParserID() {
        String selected = this.comboBox.getText();
        return (String)this.idMap.get(selected);
    }
}

