/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.model;

import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.internal.core.model.BatchOperation;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class CoreModel {
    private static CoreModel cmodel = null;
    private static CModelManager manager = null;
    public static final String CORE_MODEL_ID = "org.eclipse.cdt.core.coremodel";

    public ICElement create(IPath path) {
        return manager.create(path);
    }

    public ICElement create(IFile file) {
        return manager.create(file);
    }

    public ICContainer create(IFolder folder) {
        return manager.create(folder);
    }

    public ICProject create(IProject project) {
        return manager.create(project);
    }

    public ICElement create(IResource resource) {
        return manager.create(resource);
    }

    public ICModel getCModel() {
        return manager.getCModel();
    }

    public boolean isSharedLib(IFile file) {
        return manager.isSharedLib(file);
    }

    public boolean isObject(IFile file) {
        return manager.isObject(file);
    }

    public boolean isExecutable(IFile file) {
        return manager.isExecutable(file);
    }

    public boolean isBinary(IFile file) {
        return manager.isBinary(file);
    }

    public boolean isArchive(IFile file) {
        return manager.isArchive(file);
    }

    public boolean isTranslationUnit(IFile file) {
        return manager.isTranslationUnit(file);
    }

    public boolean isValidTranslationUnitName(String name) {
        return manager.isValidTranslationUnitName(name);
    }

    public String[] getHeaderExtensions() {
        return manager.getHeaderExtensions();
    }

    public String[] getSourceExtensions() {
        return manager.getSourceExtensions();
    }

    public String[] getTranslationUnitExtensions() {
        return manager.getTranslationUnitExtensions();
    }

    public boolean hasCNature(IProject project) {
        return manager.hasCNature(project);
    }

    public boolean hasCCNature(IProject project) {
        return manager.hasCCNature(project);
    }

    public void resetBinaryParser(IProject project) {
        manager.resetBinaryParser(project);
    }

    public static CoreModel getDefault() {
        if (cmodel == null) {
            cmodel = new CoreModel();
            manager = CModelManager.getDefault();
        }
        return cmodel;
    }

    public void addElementChangedListener(IElementChangedListener listener) {
        manager.addElementChangedListener(listener);
    }

    public void removeElementChangedListener(IElementChangedListener listener) {
        manager.removeElementChangedListener(listener);
    }

    public void startup() {
        manager.startup();
    }

    public void shutdown() {
        manager.shutdown();
    }

    private CoreModel() {
    }

    public static void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isTreeLocked()) {
            new BatchOperation(action).run(monitor);
        } else {
            workspace.run((IWorkspaceRunnable)new BatchOperation(action), monitor);
        }
    }

    public void startIndexing() {
        manager.getIndexManager().reset();
    }

    public IndexManager getIndexManager() {
        return manager.getIndexManager();
    }
}

