/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.impl;

import java.io.UTFDataFormatException;
import org.eclipse.cdt.internal.core.index.impl.CodeByteStream;
import org.eclipse.cdt.internal.core.index.impl.IncludeEntry;
import org.eclipse.cdt.internal.core.index.impl.IndexBlock;
import org.eclipse.cdt.internal.core.index.impl.Util;
import org.eclipse.cdt.internal.core.index.impl.WordEntry;

public class GammaCompressedIndexBlock
extends IndexBlock {
    CodeByteStream writeCodeStream = new CodeByteStream();
    CodeByteStream readCodeStream = new CodeByteStream(this.field.buffer());
    char[] prevWord = null;
    int offset = 0;

    public GammaCompressedIndexBlock(int blockSize) {
        super(blockSize);
    }

    public boolean addEntry(WordEntry entry) {
        this.writeCodeStream.reset();
        this.encodeEntry(entry, this.prevWord, this.writeCodeStream);
        if (this.offset + this.writeCodeStream.byteLength() > this.blockSize - 2) {
            return false;
        }
        byte[] bytes = this.writeCodeStream.toByteArray();
        this.field.put(this.offset, bytes);
        this.offset += bytes.length;
        this.prevWord = entry.getWord();
        return true;
    }

    protected void encodeEntry(WordEntry entry, char[] prevWord, CodeByteStream codeStream) {
        char[] word = entry.getWord();
        int prefixLen = prevWord == null ? 0 : Util.prefixLength(prevWord, word);
        codeStream.writeByte(prefixLen);
        codeStream.writeUTF(word, prefixLen, word.length);
        int n = entry.getNumRefs();
        codeStream.writeGamma(n);
        int prevRef = 0;
        int i = 0;
        while (i < n) {
            int ref = entry.getRef(i);
            if (ref <= prevRef) {
                throw new IllegalArgumentException();
            }
            codeStream.writeGamma(ref - prevRef);
            prevRef = ref;
            ++i;
        }
    }

    public boolean addIncludeEntry(IncludeEntry entry) {
        this.writeCodeStream.reset();
        this.encodeEntry(entry, this.prevWord, this.writeCodeStream);
        if (this.offset + this.writeCodeStream.byteLength() > this.blockSize - 2) {
            return false;
        }
        byte[] bytes = this.writeCodeStream.toByteArray();
        this.field.put(this.offset, bytes);
        this.offset += bytes.length;
        this.prevWord = entry.getFile();
        return true;
    }

    protected void encodeEntry(IncludeEntry entry, char[] prevWord, CodeByteStream codeStream) {
        char[] file = entry.getFile();
        int prefixLen = prevWord == null ? 0 : Util.prefixLength(prevWord, file);
        codeStream.writeByte(prefixLen);
        codeStream.writeUTF(file, prefixLen, file.length);
        int n = entry.getNumRefs();
        codeStream.writeGamma(n);
        int prevRef = 0;
        int i = 0;
        while (i < n) {
            int ref = entry.getRef(i);
            if (ref <= prevRef) {
                throw new IllegalArgumentException();
            }
            codeStream.writeGamma(ref - prevRef);
            prevRef = ref;
            ++i;
        }
    }

    public void flush() {
        if (this.offset > 0) {
            this.field.putInt2(this.offset, 0);
            this.offset = 0;
            this.prevWord = null;
        }
    }

    public boolean isEmpty() {
        return this.offset == 0;
    }

    public boolean nextEntry(WordEntry entry) {
        try {
            this.readCodeStream.reset(this.field.buffer(), this.offset);
            int prefixLength = this.readCodeStream.readByte();
            char[] word = this.readCodeStream.readUTF();
            if (this.prevWord != null && prefixLength > 0) {
                char[] temp = new char[prefixLength + word.length];
                System.arraycopy(this.prevWord, 0, temp, 0, prefixLength);
                System.arraycopy(word, 0, temp, prefixLength, word.length);
                word = temp;
            }
            if (word.length == 0) {
                return false;
            }
            entry.reset(word);
            int n = this.readCodeStream.readGamma();
            int prevRef = 0;
            int i = 0;
            while (i < n) {
                int ref = prevRef + this.readCodeStream.readGamma();
                if (ref < prevRef) {
                    throw new InternalError();
                }
                entry.addRef(ref);
                prevRef = ref;
                ++i;
            }
            this.offset = this.readCodeStream.byteLength();
            this.prevWord = word;
            return true;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return false;
        }
    }

    public boolean nextEntry(IncludeEntry entry) {
        try {
            this.readCodeStream.reset(this.field.buffer(), this.offset);
            int prefixLength = this.readCodeStream.readByte();
            char[] file = this.readCodeStream.readUTF();
            if (this.prevWord != null && prefixLength > 0) {
                char[] temp = new char[prefixLength + file.length];
                System.arraycopy(this.prevWord, 0, temp, 0, prefixLength);
                System.arraycopy(file, 0, temp, prefixLength, file.length);
                file = temp;
            }
            if (file.length == 0) {
                return false;
            }
            entry.reset(file);
            int n = this.readCodeStream.readGamma();
            int prevRef = 0;
            int i = 0;
            while (i < n) {
                int ref = prevRef + this.readCodeStream.readGamma();
                if (ref < prevRef) {
                    throw new InternalError();
                }
                entry.addRef(ref);
                prevRef = ref;
                ++i;
            }
            this.offset = this.readCodeStream.byteLength();
            this.prevWord = file;
            return true;
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            return false;
        }
    }

    public void reset() {
        super.reset();
        this.offset = 0;
        this.prevWord = null;
    }
}

