/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.StructureInfo;

public class Structure
extends SourceManipulation
implements IStructure {
    Map superClassesNames = new TreeMap();

    public Structure(ICElement parent, int kind, String name) {
        super(parent, name, kind);
    }

    public IField[] getFields() {
        ArrayList fields = new ArrayList();
        fields.addAll(this.getChildrenOfType(69));
        return fields.toArray(new IField[fields.size()]);
    }

    public IField getField(String name) {
        IField[] fields = this.getFields();
        int i = 0;
        while (i < fields.length) {
            IField field = fields[i];
            if (field.getElementName().equals(name)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public IMethodDeclaration[] getMethods() {
        ArrayList methods = new ArrayList();
        methods.addAll(this.getChildrenOfType(68));
        methods.addAll(this.getChildrenOfType(67));
        return methods.toArray(new IMethodDeclaration[methods.size()]);
    }

    public IMethodDeclaration getMethod(String name) {
        IMethodDeclaration[] methods = this.getMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodDeclaration method = methods[i];
            if (method.getElementName().equals(name)) {
                return method;
            }
            ++i;
        }
        return null;
    }

    public boolean isUnion() {
        return this.getStructureInfo().isUnion();
    }

    public boolean isClass() {
        return this.getStructureInfo().isClass();
    }

    public boolean isStruct() {
        return this.getStructureInfo().isStruct();
    }

    public boolean isAbstract() {
        IMethodDeclaration[] methods = this.getMethods();
        int i = 0;
        while (i < methods.length) {
            IMethodDeclaration method = methods[i];
            if (method.isPureVirtual()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getSuperClassesNames() {
        return this.superClassesNames.keySet().toArray(new String[this.superClassesNames.keySet().size()]);
    }

    public ASTAccessVisibility getSuperClassAccess(String name) {
        return (ASTAccessVisibility)this.superClassesNames.get(name);
    }

    public String getTypeName() {
        return this.getStructureInfo().getTypeName();
    }

    public void setTypeName(String type) {
        this.getStructureInfo().setTypeString(type);
    }

    public boolean isConst() {
        return this.getStructureInfo().isConst();
    }

    public void setConst(boolean isConst) {
        this.getStructureInfo().setConst(isConst);
    }

    public boolean isVolatile() {
        return this.getStructureInfo().isVolatile();
    }

    public void setVolatile(boolean isVolatile) {
        this.getStructureInfo().setVolatile(isVolatile);
    }

    public boolean isStatic() {
        return this.getStructureInfo().isStatic();
    }

    public void setStatic(boolean isStatic) {
        this.getStructureInfo().setStatic(isStatic);
    }

    public StructureInfo getStructureInfo() {
        return (StructureInfo)this.getElementInfo();
    }

    public void addSuperClass(String name) {
        this.superClassesNames.put(name, ASTAccessVisibility.PUBLIC);
    }

    public void addSuperClass(String name, ASTAccessVisibility access) {
        this.superClassesNames.put(name, access);
    }

    protected CElementInfo createElementInfo() {
        return new StructureInfo(this);
    }
}

