/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.parser.Backtrack;
import org.eclipse.cdt.core.parser.EndOfFile;
import org.eclipse.cdt.core.parser.ILineOffsetReconciler;
import org.eclipse.cdt.core.parser.IMacroDescriptor;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IProblemReporter;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITranslationOptions;
import org.eclipse.cdt.core.parser.ITranslationResult;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ScannerException;
import org.eclipse.cdt.core.parser.ast.ExpressionEvaluationException;
import org.eclipse.cdt.core.parser.ast.IASTExpression;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.parser.BranchTracker;
import org.eclipse.cdt.internal.core.parser.ContextStack;
import org.eclipse.cdt.internal.core.parser.IScannerContext;
import org.eclipse.cdt.internal.core.parser.MacroDescriptor;
import org.eclipse.cdt.internal.core.parser.NullSourceElementRequestor;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ScannerContext;
import org.eclipse.cdt.internal.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.parser.Token;

public class Scanner
implements IScanner {
    private Reader backupReader;
    private static final int NOCHAR = -1;
    private static final String TEXT = "<text>";
    private static final String START = "<initial reader>";
    private static final String EXPRESSION = "<expression>";
    private static final String PASTING = "<pasting>";
    private static final String DEFINED = "defined";
    private static final String POUND_DEFINE = "#define ";
    private ContextStack contextStack = new ContextStack();
    private IScannerContext lastContext = null;
    private IScannerInfo originalConfig;
    private List includePathNames = new ArrayList();
    private List includePaths = new ArrayList();
    private Hashtable definitions = new Hashtable();
    private StringBuffer storageBuffer = null;
    private int count = 0;
    private static HashMap cppKeywords = new HashMap();
    private static HashMap cKeywords = new HashMap();
    private static HashMap ppDirectives = new HashMap();
    private IToken currentToken = null;
    private IToken cachedToken = null;
    private boolean passOnToClient = true;
    private BranchTracker branches = new BranchTracker();
    private boolean enableDigraphReplacement = true;
    private boolean enableTrigraphReplacement = true;
    private boolean enableTrigraphReplacementInStrings = true;
    private boolean throwExceptionOnBadPreprocessorSyntax = true;
    private boolean throwExceptionOnInclusionNotFound = true;
    private boolean throwExceptionOnBadMacroExpansion = true;
    private boolean throwExceptionOnUnboundedString = true;
    private boolean throwExceptionOnEOFWithinMultilineComment = true;
    private boolean throwExceptionOnEOFWithoutBalancedEndifs = true;
    private boolean throwExceptionOnBadCharacterRead = false;
    private boolean atEOF = false;
    private boolean tokenizingMacroReplacementList = false;
    private final ParserMode mode;
    protected static endOfMacroTokenException endOfMacroToken = new endOfMacroTokenException();
    private ParserLanguage language = ParserLanguage.CPP;
    private final ISourceElementRequestor requestor;
    private IASTFactory astFactory = null;
    IProblemReporter problemReporter = null;
    ITranslationResult translationResult = null;
    TaskTagsInfo taskTagsInfo = null;

    static {
        cppKeywords.put("and", new Integer(54));
        cppKeywords.put("and_eq", new Integer(55));
        cppKeywords.put("asm", new Integer(56));
        cppKeywords.put("auto", new Integer(57));
        cppKeywords.put("bitand", new Integer(58));
        cppKeywords.put("bitor", new Integer(59));
        cppKeywords.put("bool", new Integer(60));
        cppKeywords.put("break", new Integer(61));
        cppKeywords.put("case", new Integer(62));
        cppKeywords.put("catch", new Integer(63));
        cppKeywords.put("char", new Integer(64));
        cppKeywords.put("class", new Integer(65));
        cppKeywords.put("compl", new Integer(66));
        cppKeywords.put("const", new Integer(67));
        cppKeywords.put("const_cast", new Integer(69));
        cppKeywords.put("continue", new Integer(70));
        cppKeywords.put("default", new Integer(71));
        cppKeywords.put("delete", new Integer(72));
        cppKeywords.put("do", new Integer(73));
        cppKeywords.put("double", new Integer(74));
        cppKeywords.put("dynamic_cast", new Integer(75));
        cppKeywords.put("else", new Integer(76));
        cppKeywords.put("enum", new Integer(77));
        cppKeywords.put("explicit", new Integer(78));
        cppKeywords.put("export", new Integer(79));
        cppKeywords.put("extern", new Integer(80));
        cppKeywords.put("false", new Integer(81));
        cppKeywords.put("float", new Integer(82));
        cppKeywords.put("for", new Integer(83));
        cppKeywords.put("friend", new Integer(84));
        cppKeywords.put("goto", new Integer(85));
        cppKeywords.put("if", new Integer(86));
        cppKeywords.put("inline", new Integer(87));
        cppKeywords.put("int", new Integer(88));
        cppKeywords.put("long", new Integer(89));
        cppKeywords.put("mutable", new Integer(90));
        cppKeywords.put("namespace", new Integer(91));
        cppKeywords.put("new", new Integer(92));
        cppKeywords.put("not", new Integer(93));
        cppKeywords.put("not_eq", new Integer(94));
        cppKeywords.put("operator", new Integer(95));
        cppKeywords.put("or", new Integer(96));
        cppKeywords.put("or_eq", new Integer(97));
        cppKeywords.put("private", new Integer(98));
        cppKeywords.put("protected", new Integer(99));
        cppKeywords.put("public", new Integer(100));
        cppKeywords.put("register", new Integer(101));
        cppKeywords.put("reinterpret_cast", new Integer(102));
        cppKeywords.put("return", new Integer(103));
        cppKeywords.put("short", new Integer(104));
        cppKeywords.put("signed", new Integer(108));
        cppKeywords.put("sizeof", new Integer(105));
        cppKeywords.put("static", new Integer(106));
        cppKeywords.put("static_cast", new Integer(107));
        cppKeywords.put("struct", new Integer(109));
        cppKeywords.put("switch", new Integer(110));
        cppKeywords.put("template", new Integer(111));
        cppKeywords.put("this", new Integer(112));
        cppKeywords.put("throw", new Integer(113));
        cppKeywords.put("true", new Integer(114));
        cppKeywords.put("try", new Integer(115));
        cppKeywords.put("typedef", new Integer(116));
        cppKeywords.put("typeid", new Integer(117));
        cppKeywords.put("typename", new Integer(118));
        cppKeywords.put("union", new Integer(119));
        cppKeywords.put("unsigned", new Integer(120));
        cppKeywords.put("using", new Integer(121));
        cppKeywords.put("virtual", new Integer(122));
        cppKeywords.put("void", new Integer(123));
        cppKeywords.put("volatile", new Integer(124));
        cppKeywords.put("wchar_t", new Integer(125));
        cppKeywords.put("while", new Integer(126));
        cppKeywords.put("xor", new Integer(127));
        cppKeywords.put("xor_eq", new Integer(128));
        ppDirectives.put("#define", new Integer(0));
        ppDirectives.put("#undef", new Integer(1));
        ppDirectives.put("#if", new Integer(2));
        ppDirectives.put("#ifdef", new Integer(3));
        ppDirectives.put("#ifndef", new Integer(4));
        ppDirectives.put("#else", new Integer(5));
        ppDirectives.put("#endif", new Integer(6));
        ppDirectives.put("#include", new Integer(7));
        ppDirectives.put("#line", new Integer(8));
        ppDirectives.put("#error", new Integer(9));
        ppDirectives.put("#pragma", new Integer(10));
        ppDirectives.put("#elif", new Integer(12));
        ppDirectives.put("#", new Integer(11));
        cKeywords.put("auto", new Integer(57));
        cKeywords.put("break", new Integer(61));
        cKeywords.put("case", new Integer(62));
        cKeywords.put("char", new Integer(64));
        cKeywords.put("const", new Integer(67));
        cKeywords.put("continue", new Integer(70));
        cKeywords.put("default", new Integer(71));
        cKeywords.put("delete", new Integer(72));
        cKeywords.put("do", new Integer(73));
        cKeywords.put("double", new Integer(74));
        cKeywords.put("else", new Integer(76));
        cKeywords.put("enum", new Integer(77));
        cKeywords.put("extern", new Integer(80));
        cKeywords.put("float", new Integer(82));
        cKeywords.put("for", new Integer(83));
        cKeywords.put("goto", new Integer(85));
        cKeywords.put("if", new Integer(86));
        cKeywords.put("inline", new Integer(87));
        cKeywords.put("int", new Integer(88));
        cKeywords.put("long", new Integer(89));
        cKeywords.put("register", new Integer(101));
        cKeywords.put("restrict", new Integer(137));
        cKeywords.put("return", new Integer(103));
        cKeywords.put("short", new Integer(104));
        cKeywords.put("signed", new Integer(108));
        cKeywords.put("sizeof", new Integer(105));
        cKeywords.put("static", new Integer(106));
        cKeywords.put("struct", new Integer(109));
        cKeywords.put("switch", new Integer(110));
        cKeywords.put("typedef", new Integer(116));
        cKeywords.put("union", new Integer(119));
        cKeywords.put("unsigned", new Integer(120));
        cKeywords.put("void", new Integer(123));
        cKeywords.put("volatile", new Integer(124));
        cKeywords.put("while", new Integer(126));
        cKeywords.put("_Bool", new Integer(134));
        cKeywords.put("_Complex", new Integer(135));
        cKeywords.put("_Imaginary", new Integer(136));
    }

    public Scanner(Reader reader, String filename, IScannerInfo info, IProblemReporter problemReporter, ITranslationResult unitResult, ISourceElementRequestor requestor, ParserMode parserMode, ParserLanguage language) {
        this.requestor = requestor;
        this.mode = parserMode;
        this.language = language;
        this.astFactory = ParserFactory.createASTFactory(this.mode, language);
        this.backupReader = reader;
        try {
            this.contextStack.push(new ScannerContext().initialize(new StringReader("\n"), START, 0, null), requestor);
            if (filename == null) {
                this.contextStack.push(new ScannerContext().initialize(reader, TEXT, 1, null), requestor);
            } else {
                this.contextStack.push(new ScannerContext().initialize(reader, filename, 1, null), requestor);
            }
        }
        catch (ScannerException scannerException) {}
        this.originalConfig = info;
        if (info.getDefinedSymbols() != null) {
            this.definitions.putAll(info.getDefinedSymbols());
        }
        if (info.getIncludePaths() != null) {
            this.overwriteIncludePath(info.getIncludePaths());
        }
        this.problemReporter = problemReporter;
        this.translationResult = unitResult;
        if (problemReporter != null && problemReporter.getOptions() != null) {
            this.taskTagsInfo = new TaskTagsInfo(problemReporter.getOptions());
        }
    }

    public void addIncludePath(String includePath) {
        this.includePathNames.add(includePath);
        this.includePaths.add(new File(includePath));
    }

    public void overwriteIncludePath(String[] newIncludePaths) {
        if (newIncludePaths == null) {
            return;
        }
        this.includePathNames = null;
        this.includePaths = null;
        this.includePathNames = new ArrayList();
        this.includePaths = new ArrayList();
        int i = 0;
        while (i < newIncludePaths.length) {
            this.includePathNames.add(newIncludePaths[i]);
            ++i;
        }
        Iterator i2 = this.includePathNames.iterator();
        while (i2.hasNext()) {
            String path = (String)i2.next();
            this.includePaths.add(new File(path));
        }
    }

    public void addDefinition(String key, IMacroDescriptor macro) {
        this.definitions.put(key, macro);
    }

    public void addDefinition(String key, String value) {
        this.definitions.put(key, value);
    }

    public final Object getDefinition(String key) {
        return this.definitions.get(key);
    }

    public final String[] getIncludePaths() {
        return (String[])this.includePathNames.toArray();
    }

    protected boolean skipOverWhitespace() throws ScannerException {
        int c = this.getChar();
        boolean result = false;
        while (c != -1 && (c == 32 || c == 9)) {
            c = this.getChar();
            result = true;
        }
        if (c != -1) {
            this.ungetChar(c);
        }
        return result;
    }

    protected String getRestOfPreprocessorLine() throws ScannerException {
        StringBuffer buffer;
        block11: {
            buffer = new StringBuffer();
            this.skipOverWhitespace();
            int c = this.getChar();
            boolean inString = false;
            boolean inChar = false;
            while (true) {
                if (c != 10 && c != 13 && c != 92 && c != 47 && (c != 34 || c == 34 && inChar) && (c != 39 || c == 39 && inString) && c != -1) {
                    buffer.append((char)c);
                    c = this.getChar(true);
                    continue;
                }
                if (c == 47) {
                    if (inString || inChar) {
                        buffer.append((char)c);
                        c = this.getChar(true);
                        continue;
                    }
                    int next = this.getChar();
                    if (next == 47) {
                        this.skipOverSinglelineComment();
                        break block11;
                    }
                    if (next == 42) {
                        if (!this.skipOverMultilineComment()) {
                            c = this.getChar(true);
                            continue;
                        }
                        break block11;
                    }
                    buffer.append((char)c);
                    c = next;
                    continue;
                }
                if (c == 34) {
                    inString = !inString;
                    buffer.append((char)c);
                    c = this.getChar(true);
                    continue;
                }
                if (c == 39) {
                    inChar = !inChar;
                    buffer.append((char)c);
                    c = this.getChar(true);
                    continue;
                }
                if (c != 92) break;
                c = this.getChar(true);
                if (c == 13) {
                    c = this.getChar(true);
                    if (c != 10) continue;
                    c = this.getChar(true);
                    continue;
                }
                if (c == 10) {
                    c = this.getChar(true);
                    continue;
                }
                buffer.append('\\');
                if (c != 34 && c != 39) continue;
                buffer.append((char)c);
                c = this.getChar(true);
            }
            this.ungetChar(c);
        }
        return buffer.toString();
    }

    protected void skipOverTextUntilNewline() throws ScannerException {
        while (true) {
            switch (this.getChar()) {
                case -1: 
                case 10: {
                    return;
                }
                case 92: {
                    this.getChar();
                }
            }
        }
    }

    private void setCurrentToken(IToken t) {
        if (this.currentToken != null) {
            this.currentToken.setNext(t);
        }
        this.currentToken = t;
    }

    protected void resetStorageBuffer() {
        if (this.storageBuffer != null) {
            this.storageBuffer = null;
        }
    }

    protected IToken newToken(int t, String i, IScannerContext c) {
        this.setCurrentToken(new Token(t, i, c));
        return this.currentToken;
    }

    protected IToken newToken(int t, String i) {
        this.setCurrentToken(new Token(t, i));
        return this.currentToken;
    }

    protected String getNextIdentifier() throws ScannerException {
        StringBuffer buffer = new StringBuffer();
        this.skipOverWhitespace();
        int c = this.getChar();
        if (c >= 97 && c <= 122 || (c >= 65 && c <= 90) | c == 95) {
            buffer.append((char)c);
            c = this.getChar();
            while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
                buffer.append((char)c);
                c = this.getChar();
            }
        }
        this.ungetChar(c);
        return buffer.toString();
    }

    protected void handleInclusion(String fileName, boolean useIncludePaths, int nameOffset, int beginOffset, int endOffset) throws ScannerException {
        FileReader inclusionReader = null;
        String newPath = null;
        if (useIncludePaths) {
            Iterator iter = this.includePaths.iterator();
            while (iter.hasNext()) {
                File includeFile;
                File pathFile = (File)iter.next();
                String path = pathFile.getPath();
                if (!pathFile.exists() && path.indexOf(34) != -1) {
                    StringTokenizer tokenizer = new StringTokenizer(path, "\"");
                    StringBuffer buffer = new StringBuffer(path.length());
                    while (tokenizer.hasMoreTokens()) {
                        buffer.append(tokenizer.nextToken());
                    }
                    pathFile = new File(buffer.toString());
                }
                if (!pathFile.isDirectory() || !(includeFile = new File(newPath = String.valueOf(pathFile.getPath()) + File.separatorChar + fileName)).exists() || !includeFile.isFile()) continue;
                try {
                    inclusionReader = new FileReader(includeFile);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            if (this.throwExceptionOnInclusionNotFound && inclusionReader == null) {
                throw new ScannerException(ScannerException.ErrorCode.INCLUSION_NOT_FOUND, fileName);
            }
        } else {
            String currentFilename = this.contextStack.getCurrentContext().getFilename();
            File currentIncludeFile = new File(currentFilename);
            String parentDirectory = currentIncludeFile.getParentFile().getAbsolutePath();
            currentIncludeFile = null;
            newPath = String.valueOf(parentDirectory) + File.separatorChar + fileName;
            File includeFile = new File(newPath);
            if (includeFile.exists() && includeFile.isFile()) {
                try {
                    inclusionReader = new FileReader(includeFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.handleInclusion(fileName, true, nameOffset, beginOffset, endOffset);
                }
            } else {
                this.handleInclusion(fileName, true, nameOffset, beginOffset, endOffset);
            }
        }
        if (inclusionReader != null) {
            IASTInclusion inclusion = null;
            try {
                inclusion = this.astFactory.createInclusion(fileName, newPath, !useIncludePaths, beginOffset, nameOffset, nameOffset + fileName.length(), endOffset);
            }
            catch (Exception exception) {}
            this.contextStack.updateContext(inclusionReader, newPath, 2, inclusion, this.requestor);
        }
    }

    public void setTokenizingMacroReplacementList(boolean mr) {
        this.tokenizingMacroReplacementList = mr;
    }

    private int getChar() throws ScannerException {
        return this.getChar(false);
    }

    private int getChar(boolean insideString) throws ScannerException {
        boolean done;
        int c = -1;
        this.lastContext = this.contextStack.getCurrentContext();
        if (this.contextStack.getCurrentContext() == null) {
            return c;
        }
        do {
            done = true;
            if (this.contextStack.getCurrentContext().undoStackSize() != 0) {
                c = this.contextStack.getCurrentContext().popUndo();
                continue;
            }
            try {
                c = this.contextStack.getCurrentContext().read();
                if (c != -1) continue;
                if (!this.contextStack.rollbackContext(this.requestor)) {
                    c = -1;
                    break;
                }
                done = false;
            }
            catch (IOException iOException) {
                if (!this.contextStack.rollbackContext(this.requestor)) {
                    c = -1;
                    continue;
                }
                done = false;
            }
        } while (!done);
        int baseOffset = this.lastContext.getOffset() - this.lastContext.undoStackSize() - 1;
        if (this.enableTrigraphReplacement && (!insideString || this.enableTrigraphReplacementInStrings)) {
            this.enableTrigraphReplacement = false;
            if (c == 63) {
                c = this.getChar(insideString);
                if (c == 63) {
                    c = this.getChar(insideString);
                    switch (c) {
                        case 40: {
                            this.expandDefinition("??(", "[", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 41: {
                            this.expandDefinition("??)", "]", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 60: {
                            this.expandDefinition("??<", "{", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 62: {
                            this.expandDefinition("??>", "}", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 61: {
                            this.expandDefinition("??=", "#", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 47: {
                            this.expandDefinition("??/", "\\", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 39: {
                            this.expandDefinition("??'", "^", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 33: {
                            this.expandDefinition("??!", "|", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        case 45: {
                            this.expandDefinition("??-", "~", baseOffset);
                            c = this.getChar(insideString);
                            break;
                        }
                        default: {
                            this.ungetChar(c);
                            this.ungetChar(63);
                            c = 63;
                            break;
                        }
                    }
                } else {
                    this.ungetChar(c);
                    c = 63;
                }
            }
            this.enableTrigraphReplacement = true;
        }
        if (!insideString) {
            if (c == 92) {
                c = this.getChar(false);
                if (c == 13) {
                    c = this.getChar(false);
                    if (c == 10) {
                        c = this.getChar(false);
                    }
                } else if (c == 10) {
                    c = this.getChar(false);
                } else {
                    this.ungetChar(c);
                    c = 92;
                }
            } else if (this.enableDigraphReplacement) {
                this.enableDigraphReplacement = false;
                if (c == 60) {
                    c = this.getChar(false);
                    if (c == 37) {
                        this.expandDefinition("<%", "{", baseOffset);
                        c = this.getChar(false);
                    } else if (c == 58) {
                        this.expandDefinition("<:", "[", baseOffset);
                        c = this.getChar(false);
                    } else {
                        this.ungetChar(c);
                        c = 60;
                    }
                } else if (c == 58) {
                    c = this.getChar(false);
                    if (c == 62) {
                        this.expandDefinition(":>", "]", baseOffset);
                        c = this.getChar(false);
                    } else {
                        this.ungetChar(c);
                        c = 58;
                    }
                } else if (c == 37) {
                    c = this.getChar(false);
                    if (c == 62) {
                        this.expandDefinition("%>", "}", baseOffset);
                        c = this.getChar(false);
                    } else if (c == 58) {
                        this.expandDefinition("%:", "#", baseOffset);
                        c = this.getChar(false);
                    } else {
                        this.ungetChar(c);
                        c = 37;
                    }
                }
                this.enableDigraphReplacement = true;
            }
        }
        return c;
    }

    private void ungetChar(int c) throws ScannerException {
        this.contextStack.getCurrentContext().pushUndo(c);
        this.contextStack.undoRollback(this.lastContext, this.requestor);
    }

    protected boolean lookAheadForTokenPasting() throws ScannerException {
        int c = this.getChar();
        if (c == 35) {
            c = this.getChar();
            if (c == 35) {
                return true;
            }
            this.ungetChar(c);
        }
        this.ungetChar(c);
        return false;
    }

    public IToken nextToken() throws ScannerException, EndOfFile {
        return this.nextToken(true, false);
    }

    public IToken nextToken(boolean pasting) throws ScannerException, EndOfFile {
        return this.nextToken(pasting, false);
    }

    /*
     * Unable to fully structure code
     */
    public IToken nextToken(boolean pasting, boolean lookingForNextAlready) throws ScannerException, EndOfFile {
        if (this.cachedToken != null) {
            this.setCurrentToken(this.cachedToken);
            this.cachedToken = null;
            return this.currentToken;
        }
        ++this.count;
        possibleWideLiteral = true;
        wideLiteral = false;
        c = this.getChar();
        block118: while (c != -1) {
            block192: {
                if (!this.passOnToClient) {
                    while (c != -1 && c != 35) {
                        c = this.getChar();
                        if (c != 47) continue;
                        c = this.getChar();
                        if (c == 47) {
                            this.skipOverSinglelineComment();
                            c = this.getChar();
                            continue;
                        }
                        if (c != 42) continue;
                        this.skipOverMultilineComment();
                        c = this.getChar();
                    }
                    if (c == -1) continue;
                }
                if (c == 32 || c == 13 || c == 9 || c == 10) {
                    c = this.getChar();
                    continue;
                }
                if (c == 76 && possibleWideLiteral) {
                    oldChar = c;
                    c = this.getChar();
                    if (c != 34 && c != 39) {
                        this.ungetChar(c);
                        c = oldChar;
                        possibleWideLiteral = false;
                        continue;
                    }
                    wideLiteral = true;
                    continue;
                }
                if (c == 34) {
                    buff = new StringBuffer();
                    beforePrevious = -1;
                    previous = c;
                    c = this.getChar(true);
                    while ((c != 34 || previous == 92 && beforePrevious != 92) && c != -1) {
                        buff.append((char)c);
                        beforePrevious = previous;
                        previous = c;
                        c = this.getChar(true);
                    }
                    if (c != -1) {
                        type = wideLiteral != false ? 131 : 130;
                        returnToken = this.newToken(type, buff.toString(), this.contextStack.getCurrentContext());
                        if (!lookingForNextAlready) {
                            next = null;
                            try {
                                next = this.nextToken(true, true);
                            }
                            catch (EndOfFile v0) {
                                next = null;
                            }
                            while (next != null && next.getType() == returnToken.getType()) {
                                returnToken.setImage(String.valueOf(returnToken.getImage()) + next.getImage());
                                returnToken.setNext(null);
                                this.currentToken = returnToken;
                                try {
                                    next = this.nextToken(true, true);
                                }
                                catch (EndOfFile v1) {
                                    next = null;
                                }
                            }
                            this.cachedToken = next;
                        }
                        this.currentToken = returnToken;
                        returnToken.setNext(null);
                        return returnToken;
                    }
                    if (!this.throwExceptionOnUnboundedString) continue;
                    throw new ScannerException(ScannerException.ErrorCode.UNBOUNDED_STRING, this.getCurrentFile(), this.getCurrentOffset());
                }
                if (c >= 97 && c <= 122 || (c >= 65 && c <= 90) | c == 95) {
                    baseOffset = this.lastContext.getOffset() - this.lastContext.undoStackSize() - 1;
                    buff = new StringBuffer();
                    buff.append((char)c);
                    c = this.getChar();
                    while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
                        buff.append((char)c);
                        c = this.getChar();
                    }
                    this.ungetChar(c);
                    ident = buff.toString();
                    if (ident.equals("defined")) {
                        return this.newToken(2, this.handleDefinedMacro());
                    }
                    mapping = this.definitions.get(ident);
                    if (mapping != null && this.contextStack.shouldExpandDefinition("#define " + ident)) {
                        this.expandDefinition(ident, mapping, baseOffset);
                        c = this.getChar();
                        continue;
                    }
                    tokenTypeObject = this.language == ParserLanguage.CPP ? Scanner.cppKeywords.get(ident) : Scanner.cKeywords.get(ident);
                    tokenType = 1;
                    if (tokenTypeObject != null) {
                        tokenType = (Integer)tokenTypeObject;
                    }
                    if (pasting) {
                        if (this.lookAheadForTokenPasting()) {
                            if (this.storageBuffer == null) {
                                this.storageBuffer = buff;
                            } else {
                                this.storageBuffer.append(ident);
                            }
                            c = this.getChar();
                            continue;
                        }
                        if (this.storageBuffer != null) {
                            this.storageBuffer.append(ident);
                            this.contextStack.updateContext(new StringReader(this.storageBuffer.toString()), "<pasting>", 3, null, this.requestor);
                            this.storageBuffer = null;
                            c = this.getChar();
                            continue;
                        }
                    }
                    return this.newToken(tokenType, ident, this.contextStack.getCurrentContext());
                }
                if (c >= 48 && c <= 57 || c == 46) {
                    buff = pasting ? (this.storageBuffer != null ? this.storageBuffer : new StringBuffer()) : new StringBuffer();
                    hex = false;
                    floatingPoint = c == 46;
                    firstCharZero = c == 48;
                    buff.append((char)c);
                    c = this.getChar();
                    if (!firstCharZero && floatingPoint && (c < 48 || c > 57)) {
                        if (buff.toString().equals(".")) {
                            if (c == 42) {
                                return this.newToken(49, ".*", this.contextStack.getCurrentContext());
                            }
                            if (c == 46) {
                                if (this.getChar() == 46) {
                                    return this.newToken(48, "...");
                                }
                                throw new ScannerException(ScannerException.ErrorCode.BAD_FLOATING_POINT, this.getCurrentFile(), this.getCurrentOffset());
                            }
                            this.ungetChar(c);
                            return this.newToken(50, ".", this.contextStack.getCurrentContext());
                        }
                    } else if (c == 120) {
                        if (!firstCharZero) {
                            throw new ScannerException(ScannerException.ErrorCode.BAD_HEXIDECIMAL_FORMAT, this.getCurrentFile(), this.getCurrentOffset());
                        }
                        hex = true;
                        c = this.getChar();
                    }
                    while (c >= 48 && c <= 57 || hex && (c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                        buff.append((char)c);
                        c = this.getChar();
                    }
                    if (c == 46) {
                        buff.append((char)c);
                        floatingPoint = true;
                        c = this.getChar();
                        while (c >= 48 && c <= 57 || hex && (c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                            buff.append((char)c);
                            c = this.getChar();
                        }
                    }
                    if (c == 101 || c == 69 || hex && (c == 112 || c == 80)) {
                        if (!floatingPoint) {
                            floatingPoint = true;
                        }
                        buff.append((char)c);
                        c = this.getChar();
                        if (c == 43 || c == 45) {
                            buff.append((char)c);
                            c = this.getChar();
                        }
                        while (c >= 48 && c <= 57) {
                            buff.append((char)c);
                            c = this.getChar();
                        }
                        if (c == 108 || c == 76 || c == 102 || c == 70) {
                            buff.append((char)c);
                            c = this.getChar();
                        }
                    } else if (floatingPoint) {
                        if (c == 108 || c == 76 || c == 102 || c == 70) {
                            c = this.getChar();
                        }
                    } else if (c == 117 || c == 85) {
                        c = this.getChar();
                        if (c == 108 || c == 76) {
                            c = this.getChar();
                        }
                        if (c == 108 || c == 76) {
                            c = this.getChar();
                        }
                    } else if (c == 108 || c == 76) {
                        c = this.getChar();
                        if (c == 108 || c == 76) {
                            c = this.getChar();
                        }
                        if (c == 117 || c == 85) {
                            c = this.getChar();
                        }
                    }
                    this.ungetChar(c);
                    if (pasting) {
                        if (this.lookAheadForTokenPasting()) {
                            this.storageBuffer = buff;
                            c = this.getChar();
                            continue;
                        }
                        if (this.storageBuffer != null) {
                            this.contextStack.updateContext(new StringReader(buff.toString()), "<pasting>", 3, null, this.requestor);
                            this.storageBuffer = null;
                            c = this.getChar();
                            continue;
                        }
                    }
                    result = buff.toString();
                    tokenType = floatingPoint != false && result.equals(".") != false ? 50 : (floatingPoint != false ? 129 : 2);
                    return this.newToken(tokenType, result, this.contextStack.getCurrentContext());
                }
                if (c != 35) break block192;
                beginningOffset = this.contextStack.getCurrentContext().getOffset() - 1;
                buff = new StringBuffer();
                buff.append((char)c);
                skipped = this.skipOverWhitespace();
                c = this.getChar();
                if (c == 35) {
                    if (skipped) {
                        throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                    }
                    return this.newToken(-6, "##");
                }
                if (!this.tokenizingMacroReplacementList) ** GOTO lbl224
                this.ungetChar(c);
                return this.newToken(-7, "#");
lbl-1000:
                // 1 sources

                {
                    buff.append((char)c);
                    c = this.getChar();
lbl224:
                    // 2 sources

                    ** while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95)
                }
lbl225:
                // 1 sources

                this.ungetChar(c);
                token = buff.toString();
                directive = Scanner.ppDirectives.get(token);
                if (directive == null) {
                    if (!this.throwExceptionOnBadPreprocessorSyntax) continue;
                    throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                }
                type = (Integer)directive;
                switch (type) {
                    case 0: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block118;
                        }
                        this.poundDefine(beginningOffset);
                        c = this.getChar();
                        continue block118;
                    }
                    case 7: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block118;
                        }
                        this.poundInclude(beginningOffset);
                        c = this.getChar();
                        continue block118;
                    }
                    case 1: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block118;
                        }
                        this.skipOverWhitespace();
                        toBeUndefined = this.getNextIdentifier();
                        this.definitions.remove(toBeUndefined);
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block118;
                    }
                    case 2: {
                        expression = this.getRestOfPreprocessorLine();
                        expressionEvalResult = false;
                        try {
                            expressionEvalResult = this.evaluateExpression(expression);
                        }
                        catch (ScannerException v2) {}
                        this.passOnToClient = this.branches.poundif(expressionEvalResult);
                        c = this.getChar();
                        continue block118;
                    }
                    case 3: {
                        this.skipOverWhitespace();
                        definition = this.getNextIdentifier();
                        mapping = this.definitions.get(definition);
                        if (mapping == null) {
                            this.passOnToClient = this.branches.poundif(false);
                            this.skipOverTextUntilNewline();
                            continue block118;
                        }
                        this.passOnToClient = this.branches.poundif(true);
                        c = this.getChar();
                        continue block118;
                    }
                    case 6: {
                        restOfLine = this.getRestOfPreprocessorLine().trim();
                        if (!restOfLine.equals("") && this.throwExceptionOnBadPreprocessorSyntax) {
                            throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                        }
                        this.passOnToClient = this.branches.poundendif();
                        c = this.getChar();
                        continue block118;
                    }
                    case 4: {
                        this.skipOverWhitespace();
                        def = this.getNextIdentifier();
                        map = this.definitions.get(def);
                        if (map != null) {
                            this.skipOverTextUntilNewline();
                            this.passOnToClient = this.branches.poundif(false);
                            continue block118;
                        }
                        this.passOnToClient = this.branches.poundif(true);
                        c = this.getChar();
                        continue block118;
                    }
                    case 5: {
                        try {
                            this.passOnToClient = this.branches.poundelse();
                        }
                        catch (ScannerException se) {
                            this.repackageScannerExceptionAndThrow(se);
                        }
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block118;
                    }
                    case 12: {
                        elsifExpression = this.getRestOfPreprocessorLine();
                        if (elsifExpression.equals("") && this.throwExceptionOnBadPreprocessorSyntax) {
                            throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                        }
                        elsifResult = false;
                        try {
                            elsifResult = this.evaluateExpression(elsifExpression);
                        }
                        catch (ScannerException v3) {}
                        try {
                            this.passOnToClient = this.branches.poundelif(elsifResult);
                        }
                        catch (ScannerException se) {
                            this.repackageScannerExceptionAndThrow(se);
                        }
                        c = this.getChar();
                        continue block118;
                    }
                    case 8: {
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block118;
                    }
                    case 9: {
                        if (!this.passOnToClient) {
                            this.skipOverTextUntilNewline();
                            c = this.getChar();
                            continue block118;
                        }
                        error = this.getRestOfPreprocessorLine();
                        if (this.mode == ParserMode.COMPLETE_PARSE) {
                            throw new ScannerException(ScannerException.ErrorCode.POUND_ERROR, error, this.getCurrentFile(), this.getCurrentOffset());
                        }
                        c = this.getChar();
                        continue block118;
                    }
                    case 10: {
                        this.skipOverTextUntilNewline();
                        c = this.getChar();
                        continue block118;
                    }
                    case 11: {
                        remainderOfLine = this.getRestOfPreprocessorLine().trim();
                        if (!remainderOfLine.equals("") && this.throwExceptionOnBadPreprocessorSyntax) {
                            throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                        }
                        c = this.getChar();
                        continue block118;
                    }
                    default: {
                        if (!this.throwExceptionOnBadPreprocessorSyntax) continue block118;
                        throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                    }
                }
            }
            block21 : switch (c) {
                case 39: {
                    type = wideLiteral != false ? 133 : 132;
                    c = this.getChar(true);
                    next = this.getChar(true);
                    if (c != 92) ** GOTO lbl369
                    c = next;
                    next = this.getChar(true);
                    if (next == 39) {
                        return this.newToken(type, String.valueOf('\\') + new Character((char)c).toString(), this.contextStack.getCurrentContext());
                    }
                    if (this.throwExceptionOnBadCharacterRead) {
                        throw new ScannerException(ScannerException.ErrorCode.INVALID_ESCAPE_CHARACTER_SEQUENCE, this.getCurrentFile(), this.getCurrentOffset());
                    }
                    ** GOTO lbl373
lbl369:
                    // 1 sources

                    if (next == 39) {
                        return this.newToken(type, new Character((char)c).toString(), this.contextStack.getCurrentContext());
                    }
                    if (this.throwExceptionOnBadCharacterRead) {
                        throw new ScannerException(ScannerException.ErrorCode.INVALID_ESCAPE_CHARACTER_SEQUENCE, this.getCurrentFile(), this.getCurrentOffset());
                    }
                }
lbl373:
                // 4 sources

                case 58: {
                    c = this.getChar();
                    switch (c) {
                        case 58: {
                            return this.newToken(3, "::", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(4, ":", this.contextStack.getCurrentContext());
                }
                case 59: {
                    return this.newToken(5, ";", this.contextStack.getCurrentContext());
                }
                case 44: {
                    return this.newToken(6, ",", this.contextStack.getCurrentContext());
                }
                case 63: {
                    return this.newToken(7, "?", this.contextStack.getCurrentContext());
                }
                case 40: {
                    return this.newToken(8, "(", this.contextStack.getCurrentContext());
                }
                case 41: {
                    return this.newToken(9, ")", this.contextStack.getCurrentContext());
                }
                case 91: {
                    return this.newToken(10, "[", this.contextStack.getCurrentContext());
                }
                case 93: {
                    return this.newToken(11, "]", this.contextStack.getCurrentContext());
                }
                case 123: {
                    return this.newToken(12, "{", this.contextStack.getCurrentContext());
                }
                case 125: {
                    return this.newToken(13, "}", this.contextStack.getCurrentContext());
                }
                case 43: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(14, "+=", this.contextStack.getCurrentContext());
                        }
                        case 43: {
                            return this.newToken(15, "++", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(16, "+", this.contextStack.getCurrentContext());
                }
                case 45: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(17, "-=", this.contextStack.getCurrentContext());
                        }
                        case 45: {
                            return this.newToken(18, "--", this.contextStack.getCurrentContext());
                        }
                        case 62: {
                            c = this.getChar();
                            switch (c) {
                                case 42: {
                                    return this.newToken(19, "->*", this.contextStack.getCurrentContext());
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(20, "->", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(21, "-", this.contextStack.getCurrentContext());
                }
                case 42: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(22, "*=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(23, "*", this.contextStack.getCurrentContext());
                }
                case 37: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(24, "%=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(25, "%", this.contextStack.getCurrentContext());
                }
                case 94: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(26, "^=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(27, "^", this.contextStack.getCurrentContext());
                }
                case 38: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(28, "&=", this.contextStack.getCurrentContext());
                        }
                        case 38: {
                            return this.newToken(29, "&&", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(30, "&", this.contextStack.getCurrentContext());
                }
                case 124: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(31, "|=", this.contextStack.getCurrentContext());
                        }
                        case 124: {
                            return this.newToken(32, "||", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(33, "|", this.contextStack.getCurrentContext());
                }
                case 126: {
                    return this.newToken(34, "~", this.contextStack.getCurrentContext());
                }
                case 33: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(35, "!=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(36, "!", this.contextStack.getCurrentContext());
                }
                case 61: {
                    c = this.getChar();
                    switch (c) {
                        case 61: {
                            return this.newToken(37, "==", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(38, "=", this.contextStack.getCurrentContext());
                }
                case 60: {
                    c = this.getChar();
                    switch (c) {
                        case 60: {
                            c = this.getChar();
                            switch (c) {
                                case 61: {
                                    return this.newToken(47, "<<=", this.contextStack.getCurrentContext());
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(40, "<<", this.contextStack.getCurrentContext());
                        }
                        case 61: {
                            return this.newToken(41, "<=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(42, "<", this.contextStack.getCurrentContext());
                }
                case 62: {
                    c = this.getChar();
                    switch (c) {
                        case 62: {
                            c = this.getChar();
                            switch (c) {
                                case 61: {
                                    return this.newToken(43, ">>=", this.contextStack.getCurrentContext());
                                }
                            }
                            this.ungetChar(c);
                            return this.newToken(44, ">>", this.contextStack.getCurrentContext());
                        }
                        case 61: {
                            return this.newToken(45, ">=", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(46, ">", this.contextStack.getCurrentContext());
                }
                case 46: {
                    c = this.getChar();
                    switch (c) {
                        case 46: {
                            c = this.getChar();
                            switch (c) {
                                case 46: {
                                    return this.newToken(48, "...", this.contextStack.getCurrentContext());
                                }
                            }
                            break block21;
                        }
                        case 42: {
                            return this.newToken(49, ".*", this.contextStack.getCurrentContext());
                        }
                    }
                    this.ungetChar(c);
                    return this.newToken(50, ".", this.contextStack.getCurrentContext());
                }
                case 47: {
                    c = this.getChar();
                    switch (c) {
                        case 47: {
                            this.skipOverSinglelineComment();
                            c = this.getChar();
                            continue block118;
                        }
                        case 42: {
                            this.skipOverMultilineComment();
                            c = this.getChar();
                            continue block118;
                        }
                        case 61: {
                            return this.newToken(51, "/=", this.contextStack.getCurrentContext());
                        }
                        default: {
                            this.ungetChar(c);
                            return this.newToken(52, "/", this.contextStack.getCurrentContext());
                        }
                    }
                }
                default: {
                    if (this.throwExceptionOnBadCharacterRead) {
                        throw new ScannerException(ScannerException.ErrorCode.INVALID_ESCAPE_CHARACTER_SEQUENCE, this.getCurrentFile(), this.getCurrentOffset());
                    }
                    c = 32;
                    continue block118;
                }
            }
            throw Parser.endOfFile;
        }
        if (this.throwExceptionOnEOFWithoutBalancedEndifs && this.getDepth() != 0 && !this.atEOF) {
            this.atEOF = true;
            throw new ScannerException(ScannerException.ErrorCode.UNBALANCED_CONDITIONALS, this.getCurrentFile(), this.getCurrentOffset());
        }
        throw Parser.endOfFile;
    }

    protected void repackageScannerExceptionAndThrow(ScannerException se) throws ScannerException {
        throw new ScannerException(se.getErrorCode(), this.getCurrentFile(), this.getCurrentOffset());
    }

    protected String getCurrentFile() {
        if (this.contextStack.getCurrentContext() != null) {
            return this.contextStack.getCurrentContext().getFilename();
        }
        return "";
    }

    protected int getCurrentOffset() {
        if (this.contextStack.getCurrentContext() != null) {
            return this.contextStack.getCurrentContext().getOffset();
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public IToken nextTokenForStringizing() throws ScannerException, EndOfFile {
        c = this.getChar();
        tokenImage = new StringBuffer();
        try {
            while (c != -1) {
                if (c == 32 || c == 13 || c == 9 || c == 10) {
                    if (tokenImage.length() > 0) {
                        throw Scanner.endOfMacroToken;
                    }
                    c = this.getChar();
                    continue;
                }
                if (c == 34) {
                    if (tokenImage.length() > 0) {
                        throw Scanner.endOfMacroToken;
                    }
                    buff = new StringBuffer();
                    c = this.getChar(true);
                    while (c != 34 && c != -1) {
                        buff.append((char)c);
                        c = this.getChar(true);
                    }
                    if (c != -1) {
                        return this.newToken(130, buff.toString(), this.contextStack.getCurrentContext());
                    }
                    if (!this.throwExceptionOnUnboundedString) continue;
                    throw new ScannerException(ScannerException.ErrorCode.UNBOUNDED_STRING, this.getCurrentFile(), this.getCurrentOffset());
                }
                block1 : switch (c) {
                    case 39: {
                        if (tokenImage.length() > 0) {
                            throw Scanner.endOfMacroToken;
                        }
                        c = this.getChar(true);
                        next = this.getChar(true);
                        if (c != 92) ** GOTO lbl38
                        c = next;
                        next = this.getChar(true);
                        if (next == 39) {
                            return this.newToken(132, String.valueOf('\\') + new Character((char)c).toString(), this.contextStack.getCurrentContext());
                        }
                        if (this.throwExceptionOnBadCharacterRead) {
                            throw new ScannerException(ScannerException.ErrorCode.INVALID_ESCAPE_CHARACTER_SEQUENCE, this.getCurrentFile(), this.getCurrentOffset());
                        }
                        ** GOTO lbl42
lbl38:
                        // 1 sources

                        if (next == 39) {
                            return this.newToken(132, new Character((char)c).toString(), this.contextStack.getCurrentContext());
                        }
                        if (this.throwExceptionOnBadCharacterRead) {
                            throw new ScannerException(ScannerException.ErrorCode.INVALID_ESCAPE_CHARACTER_SEQUENCE, this.getCurrentFile(), this.getCurrentOffset());
                        }
                    }
lbl42:
                    // 4 sources

                    case 44: {
                        if (tokenImage.length() > 0) {
                            throw Scanner.endOfMacroToken;
                        }
                        return this.newToken(6, ",", this.contextStack.getCurrentContext());
                    }
                    case 40: {
                        if (tokenImage.length() > 0) {
                            throw Scanner.endOfMacroToken;
                        }
                        return this.newToken(8, "(", this.contextStack.getCurrentContext());
                    }
                    case 41: {
                        if (tokenImage.length() > 0) {
                            throw Scanner.endOfMacroToken;
                        }
                        return this.newToken(9, ")", this.contextStack.getCurrentContext());
                    }
                    case 47: {
                        if (tokenImage.length() > 0) {
                            throw Scanner.endOfMacroToken;
                        }
                        c = this.getChar();
                        switch (c) {
                            case 47: {
                                this.skipOverSinglelineComment();
                                c = this.getChar();
                                break block1;
                            }
                            case 42: {
                                this.skipOverMultilineComment();
                                c = this.getChar();
                                break block1;
                            }
                        }
                        tokenImage.append('/');
                        break;
                    }
                    default: {
                        tokenImage.append((char)c);
                        c = this.getChar();
                    }
                }
            }
        }
        catch (endOfMacroTokenException v0) {
            this.ungetChar(c);
        }
        if (tokenImage.length() > 0) {
            return this.newToken(1, tokenImage.toString(), this.contextStack.getCurrentContext());
        }
        throw Parser.endOfFile;
    }

    public final int getCount() {
        return this.count;
    }

    public final int getDepth() {
        return this.branches.getDepth();
    }

    protected boolean evaluateExpression(String expression) throws ScannerException {
        if (this.mode == ParserMode.QUICK_PARSE) {
            return !expression.trim().equals("0");
        }
        NullSourceElementRequestor nullCallback = new NullSourceElementRequestor();
        IScanner trial = ParserFactory.createScanner(new StringReader(String.valueOf(expression) + ";"), EXPRESSION, new ScannerInfo(this.definitions, this.originalConfig.getIncludePaths()), ParserMode.QUICK_PARSE, this.language, nullCallback);
        IParser parser = ParserFactory.createParser(trial, nullCallback, ParserMode.QUICK_PARSE, this.language);
        try {
            IASTExpression exp = parser.expression(null);
            if (exp.evaluateExpression() == 0) {
                return false;
            }
        }
        catch (Backtrack backtrack) {
            this.throwExpressionEvaluationError(expression);
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            this.throwExpressionEvaluationError(expression);
        }
        return true;
    }

    protected void throwExpressionEvaluationError(String expression) throws ScannerException {
        throw new ScannerException(ScannerException.ErrorCode.EXPRESSION_EVALUATION_ERROR, expression, this.getCurrentFile(), this.getCurrentOffset());
    }

    protected void skipOverSinglelineComment() throws ScannerException {
        StringBuffer comment = new StringBuffer("//");
        int commentOffset = this.lastContext.getOffset() - this.lastContext.undoStackSize() - 2;
        int commentStartLine = this.lastContext.getLine();
        block3: while (true) {
            int c = this.getChar();
            comment.append((char)c);
            switch (c) {
                case -1: 
                case 10: {
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
            break;
        }
        this.checkTaskTag(comment, commentOffset, commentStartLine);
    }

    protected boolean skipOverMultilineComment() throws ScannerException {
        int state = 0;
        boolean encounteredNewline = false;
        StringBuffer comment = new StringBuffer("/*");
        int commentOffset = this.lastContext.getOffset() - this.lastContext.undoStackSize() - 2;
        int commentStartLine = this.lastContext.getLine();
        int c = this.getChar();
        comment.append((char)c);
        while (state != 2 && c != -1) {
            if (c == 10) {
                encounteredNewline = true;
            }
            switch (state) {
                case 0: {
                    if (c != 42) break;
                    state = 1;
                    break;
                }
                case 1: {
                    if (c == 47) {
                        state = 2;
                        break;
                    }
                    if (c == 42) break;
                    state = 0;
                }
            }
            c = this.getChar();
            comment.append((char)c);
        }
        if (c == -1 && this.throwExceptionOnEOFWithinMultilineComment) {
            throw new ScannerException(ScannerException.ErrorCode.UNEXPECTED_EOF, this.getCurrentFile(), this.getCurrentOffset());
        }
        this.ungetChar(c);
        this.checkTaskTag(comment, commentOffset, commentStartLine);
        return encounteredNewline;
    }

    protected void poundInclude(int beginningOffset) throws ScannerException {
        this.skipOverWhitespace();
        int baseOffset = this.lastContext.getOffset() - this.lastContext.undoStackSize();
        String includeLine = this.getRestOfPreprocessorLine();
        StringBuffer fileName = new StringBuffer();
        boolean useIncludePath = true;
        int startOffset = baseOffset;
        int endOffset = baseOffset;
        if (!includeLine.equals("")) {
            Scanner helperScanner = new Scanner(new StringReader(includeLine), null, new ScannerInfo(this.definitions, this.originalConfig.getIncludePaths()), this.problemReporter, this.translationResult, new NullSourceElementRequestor(), this.mode, this.language);
            IToken t = null;
            try {
                t = helperScanner.nextToken(false);
            }
            catch (EndOfFile endOfFile) {
                if (this.throwExceptionOnBadPreprocessorSyntax) {
                    throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                }
                return;
            }
            try {
                if (t.getType() == 130) {
                    fileName.append(t.getImage());
                    startOffset = baseOffset + t.getOffset();
                    endOffset = baseOffset + t.getEndOffset();
                    useIncludePath = false;
                    t = helperScanner.nextToken(false);
                    if (this.throwExceptionOnBadPreprocessorSyntax) {
                        throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                    }
                    return;
                }
                if (t.getType() == 42) {
                    try {
                        t = helperScanner.nextToken(false);
                        startOffset = baseOffset + t.getOffset();
                        while (t.getType() != 46) {
                            fileName.append(t.getImage());
                            helperScanner.skipOverWhitespace();
                            int c = helperScanner.getChar();
                            if (c == 92) {
                                fileName.append('\\');
                            } else {
                                helperScanner.ungetChar(c);
                            }
                            t = helperScanner.nextToken(false);
                        }
                        endOffset = baseOffset + t.getEndOffset();
                    }
                    catch (EndOfFile endOfFile) {
                        if (this.throwExceptionOnBadPreprocessorSyntax) {
                            throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                        }
                        return;
                    }
                    t = helperScanner.nextToken(false);
                    if (this.throwExceptionOnBadPreprocessorSyntax) {
                        throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                    }
                    return;
                }
                if (this.throwExceptionOnBadPreprocessorSyntax) {
                    throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                }
            }
            catch (EndOfFile endOfFile) {}
        } else if (this.throwExceptionOnBadPreprocessorSyntax) {
            throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
        }
        String f = fileName.toString();
        if (this.mode == ParserMode.QUICK_PARSE) {
            if (this.requestor != null) {
                ISourceElementCallbackDelegate i = null;
                try {
                    i = this.astFactory.createInclusion(f, "", !useIncludePath, beginningOffset, startOffset, startOffset + f.length(), endOffset);
                }
                catch (Exception exception) {}
                if (i != null) {
                    i.enterScope(this.requestor);
                    i.exitScope(this.requestor);
                }
            }
        } else {
            this.handleInclusion(f.trim(), useIncludePath, startOffset, beginningOffset, endOffset);
        }
    }

    protected void poundDefine(int beginning) throws ScannerException, EndOfFile {
        String checkForRedefinition;
        this.skipOverWhitespace();
        String key = this.getNextIdentifier();
        int offset = this.contextStack.getCurrentContext().getOffset() - key.length() - this.contextStack.getCurrentContext().undoStackSize();
        if (this.mode == ParserMode.COMPLETE_PARSE && (checkForRedefinition = (String)this.definitions.get(key)) != null) {
            throw new ScannerException(ScannerException.ErrorCode.ATTEMPTED_REDEFINITION, key, this.getCurrentFile(), this.getCurrentOffset());
        }
        int c = this.getChar();
        if (c == 40) {
            StringBuffer buffer = new StringBuffer();
            c = this.getChar(true);
            while (c != 41) {
                if (c == 92) {
                    c = this.getChar();
                    if (c == 13) {
                        c = this.getChar();
                    }
                    if (c == 10) {
                        c = this.getChar();
                        continue;
                    }
                    this.ungetChar(c);
                    if (this.throwExceptionOnBadPreprocessorSyntax) {
                        throw new ScannerException(ScannerException.ErrorCode.MALFORMED_MACRO_DEFN, this.getCurrentFile(), this.getCurrentOffset());
                    }
                    return;
                }
                if (c == 13 || c == 10) {
                    if (this.throwExceptionOnBadPreprocessorSyntax) {
                        throw new ScannerException(ScannerException.ErrorCode.MALFORMED_MACRO_DEFN, this.getCurrentFile(), this.getCurrentOffset());
                    }
                    return;
                }
                if (c == -1) {
                    if (this.throwExceptionOnBadPreprocessorSyntax) {
                        throw new ScannerException(ScannerException.ErrorCode.UNEXPECTED_EOF, this.getCurrentFile(), this.getCurrentOffset());
                    }
                    return;
                }
                buffer.append((char)c);
                c = this.getChar(true);
            }
            String parameters = buffer.toString();
            StringTokenizer tokenizer = new StringTokenizer(parameters, ",");
            ArrayList<String> parameterIdentifiers = new ArrayList<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                parameterIdentifiers.add(tokenizer.nextToken().trim());
            }
            this.skipOverWhitespace();
            ArrayList<IToken> macroReplacementTokens = new ArrayList<IToken>();
            String replacementString = this.getRestOfPreprocessorLine();
            if (!replacementString.equals("")) {
                IScanner helperScanner = ParserFactory.createScanner(new StringReader(replacementString), null, new ScannerInfo(), this.mode, this.language, new NullSourceElementRequestor(), this.problemReporter, this.translationResult);
                helperScanner.setTokenizingMacroReplacementList(true);
                IToken t = helperScanner.nextToken(false);
                try {
                    while (true) {
                        if (t.getType() == -7) {
                            macroReplacementTokens.add(t);
                            t = helperScanner.nextToken(false);
                            int index = parameterIdentifiers.indexOf(t.getImage());
                            if (index == -1) {
                                if (this.throwExceptionOnBadPreprocessorSyntax) {
                                    throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
                                }
                                return;
                            }
                        }
                        macroReplacementTokens.add(t);
                        t = helperScanner.nextToken(false);
                    }
                }
                catch (EndOfFile endOfFile) {}
            }
            MacroDescriptor descriptor = new MacroDescriptor();
            descriptor.initialize(key, parameterIdentifiers, macroReplacementTokens, String.valueOf(key) + "(" + parameters + ")");
            this.addDefinition(key, descriptor);
        } else if (c == 10 || c == 13) {
            this.addDefinition(key, "");
        } else if (c == 32 || c == 9) {
            this.skipOverWhitespace();
            String value = this.getRestOfPreprocessorLine();
            this.addDefinition(key, value);
        } else if (c == 47) {
            c = this.getChar();
            if (c == 47) {
                this.skipOverSinglelineComment();
                this.addDefinition(key, "");
            } else if (c == 42) {
                if (this.skipOverMultilineComment()) {
                    this.addDefinition(key, "");
                } else {
                    String value = this.getRestOfPreprocessorLine();
                    this.addDefinition(key, value);
                }
            } else if (this.throwExceptionOnBadPreprocessorSyntax) {
                throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
            }
        } else {
            Util.debugLog("Scanner : Encountered unexpected character " + (char)c, IDebugLogConstants.PARSER);
            if (this.throwExceptionOnBadPreprocessorSyntax) {
                throw new ScannerException(ScannerException.ErrorCode.INVALID_PREPROCESSOR_DIRECTIVE, this.getCurrentFile(), this.getCurrentOffset());
            }
        }
        try {
            this.astFactory.createMacro(key, beginning, offset, offset + key.length(), this.contextStack.getCurrentContext().getOffset()).acceptElement(this.requestor);
        }
        catch (Exception exception) {}
    }

    protected Vector getMacroParameters(String params, boolean forStringizing) throws ScannerException {
        Scanner tokenizer = new Scanner(new StringReader(params), TEXT, new ScannerInfo(this.definitions, this.originalConfig.getIncludePaths()), this.problemReporter, this.translationResult, new NullSourceElementRequestor(), this.mode, this.language);
        Vector<String> parameterValues = new Vector<String>();
        Token t = null;
        String str = new String();
        boolean space = false;
        int nParen = 0;
        try {
            while (true) {
                int c;
                if ((c = tokenizer.getChar()) != 32 && c != 9 && c != 13 && c != 10) {
                    space = false;
                }
                if (c != -1) {
                    tokenizer.ungetChar(c);
                }
                t = (Token)(forStringizing ? tokenizer.nextTokenForStringizing() : tokenizer.nextToken(false));
                if (t.type == 8) {
                    ++nParen;
                } else if (t.type == 9) {
                    --nParen;
                } else if (t.type == 6 && nParen == 0) {
                    parameterValues.add(str);
                    str = "";
                    space = false;
                    continue;
                }
                if (space) {
                    str = String.valueOf(str) + ' ';
                }
                switch (t.type) {
                    case 130: {
                        str = String.valueOf(str) + '\"' + t.image + '\"';
                        break;
                    }
                    case 131: {
                        str = String.valueOf(str) + "L\"" + t.image + '\"';
                        break;
                    }
                    case 132: {
                        str = String.valueOf(str) + '\'' + t.image + '\'';
                        break;
                    }
                    default: {
                        str = String.valueOf(str) + t.image;
                    }
                }
                space = true;
            }
        }
        catch (EndOfFile endOfFile) {
            parameterValues.add(str);
            return parameterValues;
        }
    }

    protected void expandDefinition(String symbol, Object expansion, int symbolOffset) throws ScannerException {
        if (expansion instanceof String) {
            String replacementValue = (String)expansion;
            this.contextStack.updateContext(new StringReader(replacementValue), POUND_DEFINE + symbol, 3, null, this.requestor, symbolOffset, symbol.length());
        } else if (expansion instanceof IMacroDescriptor) {
            IMacroDescriptor macro = (IMacroDescriptor)expansion;
            this.skipOverWhitespace();
            int c = this.getChar();
            if (c == 40) {
                StringBuffer buffer = new StringBuffer();
                int bracketCount = 1;
                c = this.getChar();
                while (true) {
                    if (c == 40) {
                        ++bracketCount;
                    } else if (c == 41) {
                        --bracketCount;
                    }
                    if (bracketCount == 0 || c == -1) break;
                    buffer.append((char)c);
                    c = this.getChar(true);
                }
                int endMacroOffset = this.lastContext.getOffset() - this.lastContext.undoStackSize() - 1;
                String betweenTheBrackets = buffer.toString().trim();
                Vector parameterValues = this.getMacroParameters(betweenTheBrackets, false);
                Vector parameterValuesForStringizing = this.getMacroParameters(betweenTheBrackets, true);
                Token t = null;
                buffer = new StringBuffer();
                List tokens = macro.getTokenizedExpansion();
                List parameterNames = macro.getParameters();
                if (parameterNames.size() != parameterValues.size() && this.throwExceptionOnBadMacroExpansion) {
                    throw new ScannerException(ScannerException.ErrorCode.MACRO_USAGE_ERROR, symbol, this.getCurrentFile(), this.getCurrentOffset());
                }
                int numberOfTokens = tokens.size();
                int i = 0;
                while (i < numberOfTokens) {
                    IToken t2;
                    int index;
                    t = (Token)tokens.get(i);
                    if (t.type == 1) {
                        index = parameterNames.indexOf(t.image);
                        if (index == -1) {
                            buffer.append(t.image);
                        } else {
                            buffer.append((String)parameterValues.elementAt(index));
                        }
                    } else if (t.type == -7) {
                        t = (Token)tokens.get(++i);
                        index = parameterNames.indexOf(t.image);
                        if (index == -1) {
                            if (this.throwExceptionOnBadMacroExpansion) {
                                throw new ScannerException(ScannerException.ErrorCode.MACRO_PASTING_ERROR, this.getCurrentFile(), this.getCurrentOffset());
                            }
                        } else {
                            buffer.append('\"');
                            String value = (String)parameterValuesForStringizing.elementAt(index);
                            char[] val = value.toCharArray();
                            int length = value.length();
                            int j = 0;
                            while (j < length) {
                                char ch = val[j];
                                if (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
                                    while (ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n') {
                                        ch = val[++j];
                                    }
                                    buffer.append(' ');
                                }
                                if (ch == '\"' || ch == '\\') {
                                    buffer.append('\\');
                                    buffer.append(ch);
                                } else {
                                    buffer.append(ch);
                                }
                                ++j;
                            }
                            buffer.append('\"');
                        }
                    } else {
                        switch (t.type) {
                            case 130: {
                                buffer.append(String.valueOf('\"') + t.image + '\"');
                                break;
                            }
                            case 131: {
                                buffer.append("L\"" + t.image + '\"');
                                break;
                            }
                            case 132: {
                                buffer.append(String.valueOf('\'') + t.image + '\'');
                                break;
                            }
                            default: {
                                buffer.append(t.image);
                            }
                        }
                    }
                    boolean pastingNext = false;
                    if (i != numberOfTokens - 1 && (t2 = (IToken)tokens.get(i + 1)).getType() == -6) {
                        pastingNext = true;
                        ++i;
                    }
                    if (t.getType() != -6 && !pastingNext && i < numberOfTokens - 1) {
                        buffer.append(" ");
                    }
                    ++i;
                }
                String finalString = buffer.toString();
                this.contextStack.updateContext(new StringReader(finalString), POUND_DEFINE + macro.getSignature(), 3, null, this.requestor, symbolOffset, endMacroOffset - symbolOffset + 1);
            } else if (this.throwExceptionOnBadMacroExpansion) {
                throw new ScannerException(ScannerException.ErrorCode.MACRO_USAGE_ERROR, symbol, this.getCurrentFile(), this.getCurrentOffset());
            }
        } else {
            Util.debugLog("Unexpected class stored in definitions table. " + expansion.getClass().getName(), IDebugLogConstants.PARSER);
        }
    }

    protected String handleDefinedMacro() throws ScannerException {
        this.skipOverWhitespace();
        int c = this.getChar();
        if (c != 40 && this.throwExceptionOnBadMacroExpansion) {
            throw new ScannerException(ScannerException.ErrorCode.MACRO_USAGE_ERROR, "defined()", this.getCurrentFile(), this.getCurrentOffset());
        }
        StringBuffer buffer = new StringBuffer();
        c = this.getChar();
        while (c != -1 && c != 41) {
            buffer.append((char)c);
            c = this.getChar();
        }
        if (c == -1 && this.throwExceptionOnBadMacroExpansion) {
            throw new ScannerException(ScannerException.ErrorCode.MACRO_USAGE_ERROR, "defined()", this.getCurrentFile(), this.getCurrentOffset());
        }
        String definitionIdentifier = buffer.toString().trim();
        if (this.definitions.get(definitionIdentifier) != null) {
            return "1";
        }
        return "0";
    }

    public void setLanguage(ParserLanguage value) {
        this.language = value;
    }

    public void setThrowExceptionOnBadCharacterRead(boolean throwOnBad) {
        this.throwExceptionOnBadCharacterRead = throwOnBad;
    }

    public void setASTFactory(IASTFactory f) {
        this.astFactory = f;
    }

    public void checkTaskTag(StringBuffer comment, int commentStart, int commentStartLine) {
        if (this.taskTagsInfo == null) {
            return;
        }
        int commentLength = comment.length();
        int tagStartLine = commentStartLine;
        int foundTaskIndex = this.taskTagsInfo.foundTaskCount;
        char[][] taskTags = this.taskTagsInfo.taskTags;
        char[][] taskPriorities = this.taskTagsInfo.taskPriorities;
        if (foundTaskIndex > 0) {
            TaskTagsInfo.FoundTaskInfo lastInfo = this.taskTagsInfo.foundTaskInfo[foundTaskIndex - 1];
            if (lastInfo.foundTaskStartOffset >= commentStart) {
                return;
            }
        }
        int i = 0;
        while (i < commentLength) {
            if (comment.charAt(i) == '\n') {
                ++tagStartLine;
            }
            int nextPos = -1;
            char[] tag = null;
            char[] priority = null;
            int tagLength = 0;
            int itag = 0;
            while (itag < taskTags.length) {
                block22: {
                    tag = taskTags[itag];
                    tagLength = tag.length;
                    priority = taskPriorities != null && itag < taskPriorities.length ? taskPriorities[itag] : null;
                    int t = 0;
                    while (t < tagLength) {
                        if (comment.charAt(i + t) == tag[t]) {
                            ++t;
                            continue;
                        }
                        break block22;
                    }
                    nextPos = i + tagLength;
                    int fTC = this.taskTagsInfo.foundTaskCount;
                    if (this.taskTagsInfo.foundTaskInfo == null) {
                        this.taskTagsInfo.foundTaskInfo = new TaskTagsInfo.FoundTaskInfo[5];
                    } else if (fTC == this.taskTagsInfo.foundTaskInfo.length) {
                        TaskTagsInfo.FoundTaskInfo[] resizedFTI = new TaskTagsInfo.FoundTaskInfo[fTC * 2];
                        System.arraycopy(this.taskTagsInfo.foundTaskInfo, 0, resizedFTI, 0, fTC);
                    }
                    TaskTagsInfo.FoundTaskInfo lastFTI = this.taskTagsInfo.new TaskTagsInfo.FoundTaskInfo();
                    lastFTI.foundTaskTags = tag;
                    lastFTI.foundTaskPriorities = priority;
                    lastFTI.foundTaskStartOffset = i;
                    lastFTI.foundTaskLine = tagStartLine;
                    this.taskTagsInfo.foundTaskInfo[fTC] = lastFTI;
                    ++this.taskTagsInfo.foundTaskCount;
                    int jj = i + 1;
                    while (jj < nextPos) {
                        if (comment.charAt(jj) == '\n') {
                            ++tagStartLine;
                        }
                        ++jj;
                    }
                    i = nextPos;
                }
                ++itag;
            }
            ++i;
        }
        i = foundTaskIndex;
        while (i < this.taskTagsInfo.foundTaskCount) {
            char c;
            TaskTagsInfo.FoundTaskInfo fTI = this.taskTagsInfo.foundTaskInfo[i];
            TaskTagsInfo.FoundTaskInfo fTI2 = this.taskTagsInfo.foundTaskInfo[i + 1];
            int msgStart = fTI.foundTaskStartOffset + fTI.foundTaskTags.length;
            int max_value = i + 1 < this.taskTagsInfo.foundTaskCount ? fTI2.foundTaskStartOffset - 1 : Integer.MAX_VALUE;
            int end = -1;
            int j = msgStart;
            while (j < commentLength) {
                c = comment.charAt(j);
                if (c == '\n' || c == '\r') {
                    end = j - 1;
                    break;
                }
                ++j;
            }
            int n = end = end < max_value ? end : max_value;
            if (end < 0) {
                j = commentLength - 1;
                while (j >= msgStart) {
                    c = comment.charAt(j);
                    if (c == '*') {
                        end = j - 1;
                        break;
                    }
                    --j;
                }
                if (end < 0) {
                    end = commentLength - 1;
                }
            }
            while (Character.isWhitespace(comment.charAt(end)) && msgStart <= end) {
                --end;
            }
            while (Character.isWhitespace(comment.charAt(msgStart)) && msgStart <= end) {
                ++msgStart;
            }
            fTI.foundTaskEndOffset = end;
            int messageLength = end - msgStart + 1;
            char[] message = new char[messageLength];
            comment.getChars(msgStart, msgStart + messageLength, message, 0);
            fTI.foundTaskMessages = message;
            fTI.foundTaskStartOffset += commentStart;
            fTI.foundTaskEndOffset += commentStart;
            ++i;
        }
    }

    public void onParseEnd() {
        if (this.problemReporter != null && this.taskTagsInfo != null) {
            int i = 0;
            while (i < this.taskTagsInfo.foundTaskCount) {
                TaskTagsInfo.FoundTaskInfo fTI = this.taskTagsInfo.foundTaskInfo[i];
                this.problemReporter.task(new String(fTI.foundTaskTags), new String(fTI.foundTaskMessages), fTI.foundTaskPriorities == null ? null : new String(fTI.foundTaskPriorities), fTI.foundTaskStartOffset, fTI.foundTaskEndOffset, fTI.foundTaskLine, this.translationResult);
                ++i;
            }
        }
    }

    public int getLineNumberForOffset(int i) {
        ILineOffsetReconciler reconciler = ParserFactory.createLineOffsetReconciler(this.backupReader);
        return reconciler.getLineNumberForOffset(i);
    }

    protected static class endOfMacroTokenException
    extends Exception {
        protected endOfMacroTokenException() {
        }
    }

    public static class PreprocessorDirectives {
        public static final int DEFINE = 0;
        public static final int UNDEFINE = 1;
        public static final int IF = 2;
        public static final int IFDEF = 3;
        public static final int IFNDEF = 4;
        public static final int ELSE = 5;
        public static final int ENDIF = 6;
        public static final int INCLUDE = 7;
        public static final int LINE = 8;
        public static final int ERROR = 9;
        public static final int PRAGMA = 10;
        public static final int BLANK = 11;
        public static final int ELIF = 12;
    }

    private class TaskTagsInfo {
        char[][] taskTags = null;
        char[][] taskPriorities = null;
        FoundTaskInfo[] foundTaskInfo = null;
        int foundTaskCount = 0;

        TaskTagsInfo(ITranslationOptions options) {
            this.taskTags = options.getTaskTags();
            this.taskPriorities = options.getTaskPriorities();
        }

        class FoundTaskInfo {
            char[] foundTaskTags = null;
            char[] foundTaskMessages = null;
            char[] foundTaskPriorities = null;
            int foundTaskStartOffset = -1;
            int foundTaskEndOffset = -1;
            int foundTaskLine = -1;

            FoundTaskInfo() {
            }
        }
    }
}

