/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ITokenDuple;

public class TokenDuple
implements ITokenDuple {
    protected final IToken firstToken;
    protected final IToken lastToken;

    public TokenDuple(IToken first, IToken last) {
        this.firstToken = first;
        this.lastToken = last;
    }

    public IToken getFirstToken() {
        return this.firstToken;
    }

    public IToken getLastToken() {
        return this.lastToken;
    }

    public Iterator iterator() {
        return new TokenIterator();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        IToken prev = null;
        IToken iter = this.firstToken;
        while (true) {
            if (prev != null && prev.getType() != 3 && prev.getType() != 1 && prev.getType() != 42 && prev.getType() != 34 && iter.getType() != 46 && prev.getType() != 10 && iter.getType() != 11 && iter.getType() != 3) {
                buff.append(' ');
            }
            buff.append(iter.getImage());
            if (iter == this.lastToken) break;
            prev = iter;
            iter = iter.getNext();
        }
        return buff.toString().trim();
    }

    public boolean isIdentifier() {
        return this.firstToken == this.lastToken;
    }

    public int length() {
        int count = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        return count;
    }

    public ITokenDuple getSubrange(int startIndex, int endIndex) {
        return new TokenDuple(this.getToken(startIndex), this.getToken(endIndex));
    }

    public IToken getToken(int index) {
        if (index < 0 || index >= this.length()) {
            return null;
        }
        Iterator i = this.iterator();
        int count = 0;
        while (i.hasNext()) {
            IToken r = (IToken)i.next();
            if (count == index) {
                return r;
            }
            ++count;
        }
        return null;
    }

    public int findLastTokenType(int type) {
        int count = 0;
        int lastFound = -1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            IToken token = (IToken)i.next();
            if (token.getType() == type) {
                lastFound = count;
            }
            ++count;
        }
        return lastFound;
    }

    private class TokenIterator
    implements Iterator {
        private IToken iter;

        TokenIterator() {
            this.iter = TokenDuple.this.firstToken;
        }

        public boolean hasNext() {
            return this.iter != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            IToken temp = this.iter;
            this.iter = this.iter == TokenDuple.this.lastToken ? null : this.iter.getNext();
            return temp;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

