/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser;

import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IReferenceContext;
import org.eclipse.cdt.core.parser.ITranslationResult;

public class TranslationResult
implements ITranslationResult {
    public IProblem[] problems;
    public IProblem[] tasks;
    public int problemCount;
    public int taskCount;
    private int maxProblemPerUnit;
    public int unitIndex;
    public int totalUnitsKnown;
    public boolean hasBeenAccepted = false;
    public char[] fileName;
    public static final int DEFAULT_MAX_PROBLEMS_PER_UNIT = 100;

    public TranslationResult(char[] fileName, int unitIndex, int totalUnitsKnown, int maxProblemPerUnit) {
        this.fileName = fileName;
        this.unitIndex = unitIndex;
        this.totalUnitsKnown = totalUnitsKnown;
        this.maxProblemPerUnit = maxProblemPerUnit;
    }

    public TranslationResult(String fileName) {
        this(fileName.toCharArray(), 1, 1, 100);
    }

    private int computePriority(IProblem problem) {
        int priority = 100000 - problem.getSourceLineNumber();
        return priority;
    }

    public IProblem[] getAllProblems() {
        int taskCount;
        IProblem[] problems = this.getProblems();
        int problemCount = problems != null ? problems.length : 0;
        IProblem[] tasks = this.getTasks();
        int n = taskCount = tasks != null ? tasks.length : 0;
        if (taskCount == 0) {
            return problems;
        }
        if (problemCount == 0) {
            return tasks;
        }
        int totalNumberOfProblem = problemCount + taskCount;
        IProblem[] allProblems = new IProblem[totalNumberOfProblem];
        int allProblemIndex = 0;
        int taskIndex = 0;
        int problemIndex = 0;
        while (taskIndex + problemIndex < totalNumberOfProblem) {
            IProblem nextTask = null;
            IProblem nextProblem = null;
            if (taskIndex < taskCount) {
                nextTask = tasks[taskIndex];
            }
            if (problemIndex < problemCount) {
                nextProblem = problems[problemIndex];
            }
            IProblem currentProblem = null;
            if (nextProblem != null) {
                if (nextTask != null) {
                    if (nextProblem.getSourceStart() < nextTask.getSourceStart()) {
                        currentProblem = nextProblem;
                        ++problemIndex;
                    } else {
                        currentProblem = nextTask;
                        ++taskIndex;
                    }
                } else {
                    currentProblem = nextProblem;
                    ++problemIndex;
                }
            } else if (nextTask != null) {
                currentProblem = nextTask;
                ++taskIndex;
            }
            allProblems[allProblemIndex++] = currentProblem;
        }
        return allProblems;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public IProblem[] getErrors() {
        IProblem[] problems = this.getProblems();
        int errorCount = 0;
        int i = 0;
        while (i < this.problemCount) {
            if (problems[i].isError()) {
                ++errorCount;
            }
            ++i;
        }
        if (errorCount == this.problemCount) {
            return problems;
        }
        IProblem[] errors = new IProblem[errorCount];
        int index = 0;
        int i2 = 0;
        while (i2 < this.problemCount) {
            if (problems[i2].isError()) {
                errors[index++] = problems[i2];
            }
            ++i2;
        }
        return errors;
    }

    public IProblem[] getProblems() {
        if (this.problems != null) {
            if (this.problemCount != this.problems.length) {
                this.problems = new IProblem[this.problemCount];
                System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
            }
            if (this.maxProblemPerUnit > 0 && this.problemCount > this.maxProblemPerUnit) {
                this.quickPrioritize(this.problems, 0, this.problemCount - 1);
                this.problemCount = this.maxProblemPerUnit;
                this.problems = new IProblem[this.problemCount];
                System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
            }
            TranslationResult.quickSort(this.problems, 0, this.problems.length - 1);
        }
        return this.problems;
    }

    public IProblem[] getTasks() {
        if (this.tasks != null) {
            if (this.taskCount != this.tasks.length) {
                this.tasks = new IProblem[this.taskCount];
                System.arraycopy(this.tasks, 0, this.tasks, 0, this.taskCount);
            }
            TranslationResult.quickSort(this.tasks, 0, this.tasks.length - 1);
        }
        return this.tasks;
    }

    public boolean hasErrors() {
        if (this.problems != null) {
            int i = 0;
            while (i < this.problemCount) {
                if (this.problems[i].isError()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasProblems() {
        return this.problemCount != 0;
    }

    public boolean hasSyntaxError() {
        if (this.problems != null) {
            int i = 0;
            while (i < this.problemCount) {
                IProblem problem = this.problems[i];
                if ((problem.getID() & 0x40000000) != 0 && problem.isError()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean hasTasks() {
        return this.taskCount != 0;
    }

    public boolean hasWarnings() {
        if (this.problems != null) {
            int i = 0;
            while (i < this.problemCount) {
                if (this.problems[i].isWarning()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static void quickSort(IProblem[] list, int left, int right) {
        if (left >= right) {
            return;
        }
        int original_left = left;
        int original_right = right;
        int mid = list[(left + right) / 2].getSourceStart();
        while (true) {
            if (list[left].getSourceStart() < mid) {
                ++left;
                continue;
            }
            while (mid < list[right].getSourceStart()) {
                --right;
            }
            if (left <= right) {
                IProblem tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            TranslationResult.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            TranslationResult.quickSort(list, left, original_right);
        }
    }

    private void quickPrioritize(IProblem[] list, int left, int right) {
        if (left >= right) {
            return;
        }
        int original_left = left;
        int original_right = right;
        int mid = this.computePriority(list[(left + right) / 2]);
        while (true) {
            if (this.computePriority(list[right]) < mid) {
                --right;
                continue;
            }
            while (mid < this.computePriority(list[left])) {
                ++left;
            }
            if (left <= right) {
                IProblem tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            this.quickPrioritize(list, original_left, right);
        }
        if (left < original_right) {
            this.quickPrioritize(list, left, original_right);
        }
    }

    public void record(IProblem newProblem, IReferenceContext referenceContext) {
        if (newProblem.getID() == 536871362) {
            this.recordTask(newProblem);
            return;
        }
        if (this.problemCount == 0) {
            this.problems = new IProblem[5];
        } else if (this.problemCount == this.problems.length) {
            this.problems = new IProblem[this.problemCount * 2];
            System.arraycopy(this.problems, 0, this.problems, 0, this.problemCount);
        }
        this.problems[this.problemCount++] = newProblem;
    }

    private void recordTask(IProblem newProblem) {
        if (this.taskCount == 0) {
            this.tasks = new IProblem[5];
        } else if (this.taskCount == this.tasks.length) {
            this.tasks = new IProblem[this.taskCount * 2];
            System.arraycopy(this.tasks, 0, this.tasks, 0, this.taskCount);
        }
        this.tasks[this.taskCount++] = newProblem;
    }

    public ITranslationResult tagAsAccepted() {
        this.hasBeenAccepted = true;
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.fileName != null) {
            buffer.append("Filename : ").append(this.fileName).append('\n');
        }
        if (this.problems != null) {
            buffer.append(this.problemCount).append(" PROBLEM(s) detected \n");
            int i = 0;
            while (i < this.problemCount) {
                buffer.append("\t - ").append(this.problems[i]).append('\n');
                ++i;
            }
        } else {
            buffer.append("No PROBLEM\n");
        }
        return buffer.toString();
    }
}

