/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.eclipse.cdt.utils.spawner.ProcessFactory;

public class Addr2line {
    private Process addr2line;
    private BufferedReader stdout;
    private BufferedWriter stdin;
    private String lastaddr;
    private String lastsymbol;
    private String lastline;

    public Addr2line(String file) throws IOException {
        String[] args = new String[]{"addr2line", "-C", "-f", "-e", file};
        this.addr2line = ProcessFactory.getFactory().exec(args);
        this.stdin = new BufferedWriter(new OutputStreamWriter(this.addr2line.getOutputStream()));
        this.stdout = new BufferedReader(new InputStreamReader(this.addr2line.getInputStream()));
    }

    private void getOutput(String address) throws IOException {
        if (!address.equals(this.lastaddr)) {
            this.stdin.write(String.valueOf(address) + "\n");
            this.stdin.flush();
            this.lastsymbol = this.stdout.readLine();
            this.lastline = this.stdout.readLine();
            this.lastaddr = address;
        }
    }

    public String getLine(long address) throws IOException {
        this.getOutput(Integer.toHexString((int)address));
        return this.lastline;
    }

    public String getFunction(long address) throws IOException {
        this.getOutput(Integer.toHexString((int)address));
        return this.lastsymbol;
    }

    public void dispose() {
        try {
            this.stdout.close();
            this.stdin.close();
            this.addr2line.getErrorStream().close();
        }
        catch (IOException iOException) {}
        this.addr2line.destroy();
    }
}

